require 'Qt'
require 'gst'

require 'pathname'

require 'helper'
require 'device_pool'
require 'settings'
require 'webcam_video_stream'
require 'view_widget'
require 'control_widget'
require 'preview_widget'
require 'control_page'
require 'start_page'
require 'gallery_page'
require 'photo_page'
require 'video_page'
require 'settings_page'
require 'central_widget'
require 'main_window'


class WebKamApp < Qt::Application

  def initialize(argv)
    super(argv)

    @pixmaps_dir = File.expand_path(File.dirname(__FILE__) + '/../../share/webkam/pixmaps/') + '/'
    @sounds_dir = File.expand_path(File.dirname(__FILE__) + '/../../share/webkam/sounds/') + '/'
  end

  def self.run
    begin
      $webkam_app = WebKamApp.new(ARGV)
      $webkam_app.connect(SIGNAL :aboutToQuit) { WebcamVideoStream.destroy }

      $dev_pool = DevicePool.instance($webkam_app)

      $settings = Settings.instance($webkam_app)

      $fs_view = FSView.new

      MainWindow.new.show

      $webkam_app.exec
    ensure
      WebcamVideoStream.destroy
    end
  end

  def icon(name)
    Qt::Icon.new(@pixmaps_dir + name.to_s + '.png')
  end

  def pixmap(name)
    Qt::Pixmap.new(@pixmaps_dir + name.to_s + '.png')
  end

  def play_sound(name)
    @player ||= Gst::ElementFactory.make('playbin')
    @player.stop
    @player.uri = 'file://' + @sounds_dir + name.to_s + '.wav'
    @player.play
  end

  def version
    '0.3.2'
  end

  def name
    'webKam'
  end

  def website
    'http://code.google.com/p/webkam-kde4/'
  end

  def make_path(path)
    path = Pathname.new(path)
    begin
      Dir.mkdir(path)
    rescue SystemCallError
      make_path(path.parent)
      Dir.mkdir(path)
    end
  end

end

