/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from generate-enum-encoding-helpers.json
// by the script: JavaScriptCore/replay/scripts/CodeGeneratorReplayInputs.py

#include "config.h"
#include "generate-enum-encoding-helpers.json-TestReplayInputs.h"

#if ENABLE(WEB_REPLAY)
#include "InternalNamespaceImplIncludeDummy.h"
#include <platform/ExternalNamespaceImplIncludeDummy.h>
#include <platform/PlatformMouseEvent.h>
#include <replay/NondeterministicInput.h>

namespace Test {
SavedMouseButton::SavedMouseButton(MouseButton button)
    : NondeterministicInput<SavedMouseButton>()
    , m_button(button)
{
}

SavedMouseButton::~SavedMouseButton()
{
}
} // namespace Test

namespace JSC {
const String& InputTraits<Test::SavedMouseButton>::type()
{
    static NeverDestroyed<const String> type(ASCIILiteral("SavedMouseButton"));
    return type;
}

void InputTraits<Test::SavedMouseButton>::encode(EncodedValue& encodedValue, const Test::SavedMouseButton& input)
{
    encodedValue.put<WebCore::MouseButton>(ASCIILiteral("button"), input.button());
}

bool InputTraits<Test::SavedMouseButton>::decode(EncodedValue& encodedValue, std::unique_ptr<Test::SavedMouseButton>& input)
{
    WebCore::MouseButton button;
    if (!encodedValue.get<WebCore::MouseButton>(ASCIILiteral("button"), button))
        return false;

    input = std::make_unique<Test::SavedMouseButton>(button);
    return true;
}
EncodedValue EncodingTraits<InputQueue>::encodeValue(const InputQueue& enumValue)
{
    switch (enumValue) {
    case InputQueue::EventLoopInput: return EncodedValue::createString("EventLoopInput");
    case InputQueue::LoaderMemoizedData: return EncodedValue::createString("LoaderMemoizedData");
    case InputQueue::ScriptMemoizedData: return EncodedValue::createString("ScriptMemoizedData");
    default: ASSERT_NOT_REACHED(); return EncodedValue::createString("Error!");
    }
}

bool EncodingTraits<InputQueue>::decodeValue(EncodedValue& encodedValue, InputQueue& enumValue)
{
    String enumString = encodedValue.convertTo<String>();
    if (enumString == "EventLoopInput") {
        enumValue = InputQueue::EventLoopInput;
        return true;
    }
    if (enumString == "LoaderMemoizedData") {
        enumValue = InputQueue::LoaderMemoizedData;
        return true;
    }
    if (enumString == "ScriptMemoizedData") {
        enumValue = InputQueue::ScriptMemoizedData;
        return true;
    }
    return false;
}

EncodedValue EncodingTraits<WebCore::MouseButton>::encodeValue(const WebCore::MouseButton& enumValue)
{
    EncodedValue encodedValue = EncodedValue::createArray();
    if (enumValue & WebCore::NoButton) {
        encodedValue.append<String>(ASCIILiteral("NoButton"));
        if (enumValue == WebCore::NoButton)
            return encodedValue;
    }
    if (enumValue & WebCore::LeftButton) {
        encodedValue.append<String>(ASCIILiteral("LeftButton"));
        if (enumValue == WebCore::LeftButton)
            return encodedValue;
    }
    if (enumValue & WebCore::MiddleButton) {
        encodedValue.append<String>(ASCIILiteral("MiddleButton"));
        if (enumValue == WebCore::MiddleButton)
            return encodedValue;
    }
    if (enumValue & WebCore::RightButton) {
        encodedValue.append<String>(ASCIILiteral("RightButton"));
        if (enumValue == WebCore::RightButton)
            return encodedValue;
    }
    return encodedValue;
}

bool EncodingTraits<WebCore::MouseButton>::decodeValue(EncodedValue& encodedValue, WebCore::MouseButton& enumValue)
{
    Vector<String> enumStrings;
    if (!EncodingTraits<Vector<String>>::decodeValue(encodedValue, enumStrings))
        return false;

    for (const String& enumString : enumStrings) {
        if (enumString == "NoButton")
            enumValue = static_cast<WebCore::MouseButton>(enumValue | WebCore::NoButton);
        else if (enumString == "LeftButton")
            enumValue = static_cast<WebCore::MouseButton>(enumValue | WebCore::LeftButton);
        else if (enumString == "MiddleButton")
            enumValue = static_cast<WebCore::MouseButton>(enumValue | WebCore::MiddleButton);
        else if (enumString == "RightButton")
            enumValue = static_cast<WebCore::MouseButton>(enumValue | WebCore::RightButton);
    }

    return true;
}

EncodedValue EncodingTraits<WebCore::PlatformEvent::Type>::encodeValue(const WebCore::PlatformEvent::Type& enumValue)
{
    EncodedValue encodedValue = EncodedValue::createArray();
    if (enumValue & WebCore::PlatformEvent::Mouse) {
        encodedValue.append<String>(ASCIILiteral("Mouse"));
        if (enumValue == WebCore::PlatformEvent::Mouse)
            return encodedValue;
    }
    if (enumValue & WebCore::PlatformEvent::Key) {
        encodedValue.append<String>(ASCIILiteral("Key"));
        if (enumValue == WebCore::PlatformEvent::Key)
            return encodedValue;
    }
    if (enumValue & WebCore::PlatformEvent::Touch) {
        encodedValue.append<String>(ASCIILiteral("Touch"));
        if (enumValue == WebCore::PlatformEvent::Touch)
            return encodedValue;
    }
    if (enumValue & WebCore::PlatformEvent::Wheel) {
        encodedValue.append<String>(ASCIILiteral("Wheel"));
        if (enumValue == WebCore::PlatformEvent::Wheel)
            return encodedValue;
    }
    return encodedValue;
}

bool EncodingTraits<WebCore::PlatformEvent::Type>::decodeValue(EncodedValue& encodedValue, WebCore::PlatformEvent::Type& enumValue)
{
    Vector<String> enumStrings;
    if (!EncodingTraits<Vector<String>>::decodeValue(encodedValue, enumStrings))
        return false;

    for (const String& enumString : enumStrings) {
        if (enumString == "Mouse")
            enumValue = static_cast<WebCore::PlatformEvent::Type>(enumValue | WebCore::PlatformEvent::Mouse);
        else if (enumString == "Key")
            enumValue = static_cast<WebCore::PlatformEvent::Type>(enumValue | WebCore::PlatformEvent::Key);
        else if (enumString == "Touch")
            enumValue = static_cast<WebCore::PlatformEvent::Type>(enumValue | WebCore::PlatformEvent::Touch);
        else if (enumString == "Wheel")
            enumValue = static_cast<WebCore::PlatformEvent::Type>(enumValue | WebCore::PlatformEvent::Wheel);
    }

    return true;
}
} // namespace JSC

#endif // ENABLE(WEB_REPLAY)
