#include <stdio.h>
#include <string.h>
#include <regex.h>
#include <windows.h>
#include <ddk/imm.h>
#include <stdbool.h>
#include "wimeapi.h"
#include "ut.h"
#include "canna.h"
#include "apisup.h"
#include "list.h"

int MsgLoopN(int n,...); //wime.c
HWND NewWin(void);
bool wm_ime_composition(CannaContext_t* cx,char mj);

/*
  ƥֹϣ
*/

//01
bool wm_canna_init(CanHeader* ch UNUSED,int fd)
{
    int len,client_major,client_minor,n;
    uint16_t res[2];
    char *user;

    ImRead(&len,4);
    len = Swap4(len);
    char data[len];
    ImRead(data,len);
    LOG("data='%s', fd=%d\n",data,fd);

    if(FindClient(fd) != NULL){
	//ʣν
	res[0] = res[1] = -1;
    }else{
	n = sscanf(data,"%d.%d",&client_major,&client_minor);
	if((user = strchr(data,':')) != NULL)
	    ++user;
	if(n!=2 || client_major>WIME_CANNA_MAJOR || user==NULL){
	    /* 줿ǡ
	       ᥸㡼С󤬤ʤȤRETURN_VERSION_ERROR_STAT֤ȤˤʤäƤ뤬ϤʥIRproto.hˤꡢlibcannaˤϴޤޤƤʤΤˤʥäƤΤݤʤΤǡإåե˽񤤤Ƥ
	       ޥʡСϤȤꤢ̵뤹롣
	       桼̾ʤΤ̤Υ顼ˤ٤ݤʤΤǡ
	    */
	    *(uint32_t*)res = Swap4(RETURN_VERSION_ERROR_STAT);
	    MSG("illegal data\n");
	}else{
	    res[0] = Swap2(WIME_CANNA_MINOR);
	    res[1] = Swap2(OpenConnection(fd,user));
	    LOG("context=%hd fd=%d user='%s'\n",Swap2(res[1]),fd,user);
	}
    }
    return ImWrite(res,4);
}

//02
bool wm_canna_finalize(CanHeader* ch,int fd)
{
    char st = (CloseConnection(fd) ? 0:-1);
    LOG("fd %d ,status %hhd\n",fd,st);
    return Reply2(ch->Major,ch->Minor,st);
}

//03
bool wm_create_context(CanHeader* ch,int fd)
{
    int16_t cxn=-1;
    if(FindClient(fd) != NULL)
	OpenContext(fd,NewWin(),&cxn);
    LOG("context number %d,fd %d\n",cxn,fd);
    return Reply5(ch->Major,ch->Minor,cxn);
}

//04
bool wm_dup_context(CanHeader* ch,int fd)
{
    int16_t orig,dup=-1;
    HIMC orig_imc,dup_imc;
    CANDIDATEFORM candi_form;
    LOGFONT logfont;
    COMPOSITIONFORM comp_form;
    DWORD conv_st,sentence_st;
    CannaContext_t *cxo,*cxd;

    orig = Req2(ch);
    LOG("fd=%d, context=%hd\n",fd,orig);
    cxo = ValidContext(orig,__FUNCTION__);
    if(cxo != NULL){
	cxd = OpenContext(fd,NewWin(),&dup);

	dup_imc = ImmGetContext(cxd->Win);
	orig_imc = ImmGetContext(cxo->Win);
	
	ImmGetCandidateWindow(orig_imc,sizeof(CANDIDATEFORM),&candi_form);
	ImmSetCandidateWindow(dup_imc,&candi_form);

	ImmGetCompositionFont(orig_imc,&logfont);
	ImmSetCompositionFont(dup_imc,&logfont);

	ImmGetCompositionWindow(orig_imc,&comp_form);
	ImmSetCompositionWindow(dup_imc,&comp_form);

	ImmGetConversionStatus(orig_imc,&conv_st,&sentence_st);
	ImmSetConversionStatus(dup_imc,conv_st,sentence_st);

	ImmReleaseContext(cxo->Win,orig_imc);
	ImmReleaseContext(cxd->Win,dup_imc);

	ArCopy(&cxd->Dics,&cxo->Dics);
	ArCopy(&cxd->DicMode,&cxo->DicMode);

	LOG("%d --> %d\n",(unsigned)orig,(unsigned)dup);
    }
    return Reply5(ch->Major,ch->Minor,dup);
}

//05
bool wm_close_context(CanHeader* ch,int fd UNUSED)
{
    char st=-1;
    CannaContext_t* cx;
    int16_t cxn = Req2(ch);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	CloseContext(cx);
	st = 0;
    }
    return Reply2(ch->Major,ch->Minor,st);
}

/*???
  06 GetDictionaryList	ơ֥ϿƤ뼭ΰ
  07 GetDirectoryList	ǥ쥯ȥˤ뼭ΰ
  0b GetMountDicList	ơ֥ϿƤ뼭ꥹ
  060bƱʤ졩
  atok
  06 Ѥ褦ꤷƤ뼭ΰ(ǥեȤμ񥻥å)
  07 Ѳǽʼΰ
  0b ޥȤƤ뼭ΰ
  ȤƤߤ롣
  imm-api˼ϢΤΤϤʤΤǡؤδؿϤɤ褦ʤ
*/
//06 [atok]
bool wm_get_dic_list(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn;
    uint16_t bufsize;
    Req3(ch,&cxn,&bufsize);
    LOG("context=%hd, bufsize=%hd\n",cxn,bufsize);
    MSG("*** NOT IMPLIMENT ***\n"); 
    MSG("*** I DO NOTHING ***\n");
    return Reply6(ch->Major,ch->Minor,0,NULL,0); //ꥹȤʤｪλ
}

//07 [atok]
bool wm_get_dir_list(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn;
    uint16_t bufsize;
    Req3(ch,&cxn,&bufsize);
    LOG("context=%hd, bufsize=%hd\n",cxn,bufsize);
    MSG("*** NOT IMPLIMENT ***\n"); 
    MSG("*** I DO NOTHING ***\n");
    return Reply6(ch->Major,ch->Minor,0,NULL,0);
}

//̾Ͽ
//08
bool wm_mount_dic(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    char *name,st=-1;
    CannaContext_t *cx;

    name = Req15(ch,&mode,&cxn);
    VERBOSE(MSG("mode=0x%x context=%hd dic-name='%s'\n",mode,cxn,name);
	    MSG("*** I DO NOTHING ***\n"));
    if((cx = ValidContext(cxn,__FUNCTION__))!=NULL){
	char listterm=0;
	if(cx->Dics.use > 0)
	    -- cx->Dics.use; //ꥹȤνλޡȤ
	ArAddN(&cx->Dics,name,strlen(name)+1);
	ArAdd(&cx->Dics,&listterm);
	ArAdd(&cx->DicMode,&mode);
	st = 0;
    }
    return Reply2(ch->Major,ch->Minor,st);
}

//̾
//09
bool wm_unmount_dic(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    char *dicname,st=-1;
    CannaContext_t *cx;
    int dn;

    dicname = Req15(ch,&mode,&cxn);
    VERBOSE(MSG("mode=0x%x, context=%hd, dictionary name='%s'\n",mode,cxn,dicname);
	    MSG("*** I DO NOTHING ***\n"));
    if((cx = ValidContext(cxn,__FUNCTION__))!=NULL){
	if(cx->Dics.use>0 && (dn = ListFind(cx->Dics.adr,dicname))>0){
	    cx->Dics.use -= ListRemove(cx->Dics.adr,dn);
	    if(cx->Dics.use == 1) //ꥹȽλޡΤߤˤʤä
		cx->Dics.use = 0;
	    ArRemove(&cx->DicMode,dn);
	    st = 0;
	}else
	    LOG("not found dictionary '%s'\n",dicname);
    }
    return Reply2(ch->Major,ch->Minor,st);
}

/*???
  ͤͥ٤Ȥ뤬ϤɤͤʤΤ
  褯狼ʤΤǡꤵ줿ꥹȤƬ˻äƤ롣
*/
//0a
bool wm_remount_dic(CanHeader* ch,int fd UNUSED)
{
    char *dicname;
    int32_t pr;
    int16_t cxn;
    CannaContext_t *cx;
    int dn;
    char st=-1;

    dicname = Req15(ch,&pr,&cxn);
    VERBOSE(MSG("context=%hd, priority=%d, dic-name='%s'\n",cxn,pr,dicname);
	    MSG("*** I DO NOTHING ***\n"));
    if((cx = ValidContext(cxn,__FUNCTION__))!=NULL){
	dn = ListFind(cx->Dics.adr,dicname);
	if(dn >= 0){
	    int mode = *(int32_t*)ArElem(&cx->DicMode,dn);
	    ArInsert(ArRemove(&cx->DicMode,dn),0,1,&mode);
	    ListRemove(cx->Dics.adr,dn);
	    ListInsert(cx->Dics.adr,0,dicname);
	    st = 0;
	}else
	    LOG("not mount dictionary\n");
    }
    return Reply2(ch->Major,ch->Minor,st);
}

//0b
bool wm_mount_dic_list(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn;
    uint16_t bufsize;
    int n=-1,len;
    char* p = NULL;
    CannaContext_t *cx;

    Req3(ch,&cxn,&bufsize);
    LOG("context %hd, buffer size %hd\n",cxn,bufsize);
    if((cx = ValidContext(cxn,__FUNCTION__))!=NULL &&
       (len = ArUsing(&cx->Dics)) <= bufsize)
	n = ListCount(p = ArAdr(&cx->Dics));
    return Reply6(ch->Major,ch->Minor,n,p,len);
}

//0c
bool wm_query_dic(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    char *user,*dic;

    dic = Req19(ch,&mode,&cxn,&user);
    VERBOSE(MSG("context=%hd, mode=0x%x, user='%s', dic='%s'\n",cxn,mode,user,dic);	
	    MSG("*** NOT IMPLIMENT ***\n"));
    return Reply2(ch->Major,ch->Minor,-1);
}


/*
  ʤʻ쥳("#"ϤĤʤ)winοͥɤˤ
  ʻơ֥뤬ʤȤ0
  ??? IME_REGWORD_STYLE_USER_FIRSTImmRegisterWordǻȤȥ顼ˤʤä
  IME_REGWORD_STYLE_USER_FIRST+1ʹߤμ¤ˤȤƤΤ
  ΤȤǤϡʻбե뤬ʤХ顼ˤƤ
*/
int canna_hinshi_to_win(const char *can_code)
{
    HinshiCor* hc;
    regex_t reg;
    regmatch_t m;

    if((hc=WimeData.HinshiTab) == NULL){
	MSG("not found hinshi table\n");
	return 0;
    }
    for(; hc->Ccode!=NULL; ++hc){
	if(regcomp(&reg,hc->Ccode,REG_EXTENDED)==0){
	    if(regexec(&reg,can_code,1,&m,0)==0)
		break;
	    regfree(&reg);
	}
    }
    if(hc->Ccode != NULL)
	regfree(&reg);
    else{
	MSG("unknown part code:%s\n",can_code);
	hc=WimeData.HinshiTab; //Ƭˤ륳ɤ֤
    }
    return hc->Wcode;
}

//??? -mno-cygwinʤ?
//char *strtok_r(char*,const char*,char**);
/* gcc-HǸȡno-cygwinȤstring.h/usr/local/include/wine/msvcrt,
   ̵ȤϤʳ(/usr/include)ɤ߹Ǥ롣ǡwine-1.1.1ʳ
   msvcrt/string.hstrtok_r̵
   windowsǤstrtok_sߤǤwineˤϤʤ
*/
char* strtok_r_(char* s,const char* d,char** p)
{
    if(s == NULL)
	s = *p;
    if(s != NULL){
	s += strspn(s,d);
	if(*s != 0){
	    *p = s+strcspn(s,d);
	    if(**p != 0)
		*((*p)++) = 0;
	}else
	    *p = s = NULL;
    }
    return s;
}
#define strtok_s strtok_r_

//0d RkDefineDic
bool reg_or_unreg_word(CanHeader* ch,BOOL WINAPI (*proc)(HKL,LPCWSTR, DWORD, LPCWSTR))
{
    int16_t cxn;
    char *dicname,*wordrec,*hinshi,*wrp,*tok;
    char *mb[2]/*ɤߤȴ*/;
    int sty;
    uint16_t *wd[2];

    dicname = Req12((Req12_t*)ch,&cxn,&wordrec);
    LOG("context=%hd, words='%s', dic-name=%s\n",cxn,wordrec,dicname);

    wrp = wordrec;
    while((mb[0] = strtok_s(wrp," ",&tok)) != NULL){
	hinshi = strtok_s(NULL," ",&tok); //ʻ쥳ʸ
	mb[1] = strtok_s(NULL," ",&tok); //Ͽ
	if(hinshi==NULL || mb[1]==NULL){
	    MSG("illegal word info.\n");
	    break;
	}
	sty = canna_hinshi_to_win(hinshi+1);
	if(sty == 0){ //ʻơ֥뤬ʤ
	    mb[0] = ""; //顼ˤ뤿Ŭʥɥ쥹Ƥ
	    break;
	}
	LOG("reading=[%s] style=0x%x word=[%s]\n",mb[0],sty,mb[1]);

	for(int n=0; n<2; ++n)
	    wd[n] = EjToU16(NULL,mb[n]);
	if(!proc(GetKeyboardLayout(0),wd[0],sty,wd[1])){
	    MSG("fail Imm(Un)RegisterWordW\n");
	    break;
	}
	for(int n=0; n<2; ++n)
	    free(wd[n]);
	wrp = NULL;
    }
    free(wordrec);
    return Reply2(ch->Major,ch->Minor,(mb[0]==NULL?0:-1));
}

//0d RkDefineDic
bool wm_define_word(CanHeader* ch,int fd UNUSED)
{
    LOG("\n"); //ؿ̾ɽ
    return reg_or_unreg_word(ch,ImmRegisterWordW);
}

//0e RkDeleteDic
bool wm_delete_word(CanHeader* ch,int fd UNUSED)
{
    LOG("\n"); //ؿ̾ɽ
    return reg_or_unreg_word(ch,ImmUnregisterWordW);
}

bool set_yomi_str(CannaContext_t* cx,int sentence_mode,int notify_cmd,const char* yomi,int32_t fer_mode)
{
    int r=0;
    HIMC imc = ImmGetContext(cx->Win);

#ifdef SETCONTEXT_FAIL
    SetCurrentImc(imc,TRUE);
#else
    ImmSetOpenStatus(imc,TRUE);
    ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CANCEL,0); //Ƚλ򤷤ʤ翷HWNDǤΥǡĤäƤȤ롣
#endif

    ImmSetConversionStatus(imc,CONV_MODE,sentence_mode);

    if((r = (*WimeData.SetRead)(imc,yomi))){
	if((r=ImmNotifyIME(imc,NI_COMPOSITIONSTR,notify_cmd,0))){
	    cx->FerMode = fer_mode;
	    cx->Conv = 0;
	}else
	    MSG("fail ImmNotifyIME()\n");
    }else
	MSG("fail ImmSetCompositionStringA/W()\n");
    ImmReleaseContext(cx->Win,imc);
    return r!=0;
}

//0f RkBgnBun
bool wm_begin_conv(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    bool r=false;
    char *yomi;
    CannaContext_t *cx;

    yomi = Req14(ch,&mode,&cxn);
    LOG("mode 0x%x, context %hd, yomi='%s'\n",mode,cxn,yomi);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	r = set_yomi_str(cx,IME_SMODE_PHRASEPREDICT,CPS_CONVERT,yomi,mode);
    }
    free(yomi);
    return r ? wm_ime_composition(cx,ch->Major) : (cx->Conv=-1,Reply5(ch->Major,ch->Minor,-1));
}

//Ѵ⡼ɤɲäο֤
//append_fer_cand()⻲
int fer_mode_num(int32_t mode)
{
    int count;
    for(count=0; (mode&RK_XFERMASK)!=0; mode>>=RK_XFERBITS){
	//⡼0x0fϽ롣 ???Ϥʤ
	if((mode & RK_XFERMASK) != RK_XFERMASK)
	    ++ count;
    }
    return count;
}

/*
  ߤѴ̤ΥꥹȤ롣ꥹȽλΥ̥ʸɲä롣
  ʸɤcej
  ͡ʸ
*/
int current_cand_list(int clstart,Array* lst,const CannaContext_t* cx,HIMC imc)
{
    int st=0;
    Array cej;
    char at;

    ArNew(&cej,2,NULL);
    for(; GetClause(imc,cx,GCS_COMPSTR,clstart,clstart,&cej,&at)!=NULL; ++clstart){
	if(at!=ATTR_TARGET_CONVERTED && at!=ATTR_CONVERTED && at!=ATTR_FIXEDCONVERTED)
	    break; //ޤѴƤʤФǽ
	ArAddAr(lst,&cej);
	//{Array x;ArNew(&x,1,NULL);Dump1(" %x",ArAdr(lst),ArUsingBytes(lst),&x);printf("***%s\n",ArAdr(&x));}
	++ st; //ͭʸο
    }
    if(st > 0){
	uint16_t nl=0;
	ArAdd(lst,&nl); //ꥹȽλޡ
    }
    ArDelete(&cej);
    return st;
}

/*
  begin_convert,resize_pause³
  WM_IME_COMPOSITIONν
  Context[cx].Convʸֹ

  ??? 1.5.1ޤǤϲäƤåޤƽƤ1.6.0ǤѴؿ
  Ƥå롼פ˹ԤľܤƤ֤Ȥˤatok21Ǥʤ
  ۤimeǤϤɤ å륿ߥ󥰤Ѵ٤ƽäȤ
  ޤʤΤ
  ä˼ưѴξ硢ŪѴ򤷤Ƥ櫓ǤϤʤä夹ˤδؿƤǤ뤬פʸƱ˹Ԥ꤬ꤽʵ롣
  Ф餯ǤäƤߤơи᤽
*/
bool wm_ime_composition(CannaContext_t* cx,char mj)
{
    int st;
    Array candlist;
    bool ret;

    HIMC imc = ImmGetContext(cx->Win);
    VERBOSE(MSG("major code=0x%hhx, target clause number %d\n",mj,cx->Conv);DbgComp(imc,__func__));
    SaveFixedClause(imc,cx); //Ѵ뤿Ӥ˸ʸϾ񤭤ƤޤΤ¸롣

    //ʬc-eucjpѴʤ饳ԡ
    ArNew(&candlist,2,NULL);
    st = current_cand_list(cx->Conv,&candlist,cx,imc); //ͭʸο
    if(st > 0)
	st += cx->Conv; //ResizePause֤ʸʸʹߤǤϤʤʸ
    VERBOSE(Array a;
	    ArNew(&a,1,NULL);
	    MSG("cl-count=%d, candi-data-size=%d, data=%s\n",st,ArUsingBytes(&candlist),ArAdr(Dump1(" %02x",ArAdr(&candlist),ArUsingBytes(&candlist),&a)));
	    ArDelete(&a);
	);

    ret = Reply7(mj,0,st,ArAdr(&candlist),ArUsing(&candlist));
    cx->Conv = -1;
    ImmReleaseContext(cx->Win,imc);
    ArDelete(&candlist);
    return ret;
}

/*
  ѴֹѴꥹȥڡֹȥڡֹˤ롣
  䥦ɥФʤȤ *page=-1
  Ƭλ顼λ-1

  !!! GetCandidacyListΥ⡼ɤɲä줿ɤߤʤɤ򤵤줿Ϥɤ롩
  ڡʤΤǥ顼ˤʤ롣
*/
int page_index(int cln,Array* candlistpage,int index,int* page)
{
    if(index > 0){ //Ƭʳ
	if(cln >= candlistpage->use){
	    *page = CANDLISTMAX; //ʸǸϽФƤʤ
	}else{
	    CandListPageInfo* pi = ArElem(candlistpage,cln);
	    if(pi->Seq > 0)
		*page = -1; //䥦ɥʤ
	    else{
		for(*page=0; *page<CANDLISTMAX; ++*page){
		    if(pi->Size[*page] == 0){ //ꥹȤʤ
			MSG("clause %d:candidate list page %d is none\n",cln,*page);
			index = -1;
			break;
		    }
		    if(index < pi->Size[*page])
			break;
		    index -= pi->Size[*page];
		}
	    }
	}
	if(*page == CANDLISTMAX){
	    MSG("clause %d:candidate page not found\n",cln);
	    index = -1;
	}
    }else{
	LOG("clause %d:first candidate word\n",cln);
	index = -1;
    }
    return index;
}

//ǽŪѴimeȿǤ
void update_cand(HIMC imc,const int16_t* candnum,int len,Array* pi,const CannaContext_t* cx)
{
    int cn,page;
    for(int clnum=cx->FixedNum; clnum<len; ++clnum,++candnum){
	if((cn=page_index(clnum,pi,*candnum,&page))>=0){
	    switch(SetTarget(imc,clnum,cx)){
	    case ChangeTargetSuccess:
		if(page >= 0){
		    if(ImmNotifyIME(imc,NI_OPENCANDIDATE,page,0) &&
		       ImmNotifyIME(imc,NI_SELECTCANDIDATESTR,page,cn)){
			LOG("candidate page %d,index %d\n",page,cn);
		    }else
			MSG("fail ImmNotifyIME\n");
		}else{
		    while(--cn >= 0)
			ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CONVERT,0);
		}
	    case ChangeTargetFixed:
		break;
	    case ChangeTargetFail:
		MSG("fail SetTarget\n");
	    }
	}
    }
}

//10 RkEndBun
bool wm_end_conv(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,clses,*candnums;
    int32_t mode;
    int numlen;
    CannaContext_t *cx;
    char st=-1;

    candnums = Req10((Req10_t*)ch,&cxn,&clses,&mode);
    numlen = (ch->Length-8)/2;
    VERBOSE(Array a;
	    ArNew(&a,1,NULL);
	    MSG("context %hd, clauses %hd, mode %d, candidate list(%d)%s\n",cxn,clses,mode,numlen,ArAdr(Dump2(" %hd",candnums,numlen,&a)));
	    ArDelete(&a);
	);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	HIMC imc = ImmGetContext(cx->Win);
	//??? mode!=1ϥ󥻥ȤƤΤ
	if(mode==1){
	    update_cand(imc,candnums,numlen,&cx->CandInfo,cx);
	    st = ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_COMPLETE,0);
	    if(st)
		VERBOSE(DbgComp(imc,__FUNCTION__));
	}else
	    st = ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CANCEL,0);
	if(!st)
	    MSG("fail ImmNotifyIME\n");
#ifdef SETCONTEXT_FAIL
	SetCurrentImc(imc,FALSE);
#else
	ImmSetOpenStatus(imc,FALSE);
#endif
	ImmNotifyIME(imc,NI_CLOSECANDIDATE,0,0); //???ʸɬפ
	ImmReleaseContext(cx->Win,imc);
	ResetContext(cx);
	st = 0;
    }
    return Reply2(ch->Major,ch->Minor,st);
}

/*
  ⡼ɤˤäyomi(cej,ѤҤ餬)ѴƸꥹȤɲä
  ɲä֤
  ??? ⡼ɤ0xf(֤RK_CTRLHENKAN)ʤΤϲ
*/
int append_fer_cand(int mode,Array* lb,uint16_t* yomi)
{
    Array fer;
    int count=0,len;

    ArNew(&fer,2,NULL);
    len = WcLen(yomi)+1; //̥ʸޤ
    for(; (mode&RK_XFERMASK)!=0; mode>>=RK_XFERBITS){
	switch(mode & RK_XFERMASK){
	case RK_HFER: //Ⱦʸ
	    LOG("Hankaku\n");
	    ZenToHan(ArAlloc(&fer,len*2+1),(char*)yomi); //Τˣʸˤʤ뤫⤷ʤ
	    ToWc(ArAdr(&fer),ArAdr(&fer));
	    ArSetUsing(&fer,WcLen(ArAdr(&fer))+1);
	    ArAddAr(lb,&fer);
	    break;
	case RK_KFER: //
	    LOG("Katakana\n");
	    HiraToKata(ArAlloc(&fer,len),(char*)yomi,-1);
	    ToWc(ArAdr(&fer),ArAdr(&fer));
	    ArSetUsing(&fer,WcLen(ArAdr(&fer))+1);
	    ArAddAr(lb,&fer);
	    break;
	case RK_XFER: //Ҥ餬 ??? RK_ZFERȤΰ㤤ϡ
	    LOG("Hiragana\n");
	    ArAddN(lb,yomi,len);
	    break;
	case RK_ZFER: //ʸ
	    LOG("Zenkaku\n");
	    ArAddN(lb,yomi,len);
	}
	++count;
    }
    ArDelete(&fer);
    return count;
}

/*???
  atok2008ǤѴϸ촴롣ʤǤ꤬ʤޤɬס
  windowsǤθꥹȥɥǤ꤬ʤøɽƤ롣
  ꤬ʤμˡ狼ʤimm apiˤ̵
  Ȥꤢ򣱤Ĥ򤷡ΤȤѴʸФ
  ʥ饤ȤϤȤˤ롣
  [wine1.1.22]vje-dǤImmNotifyIME()ƤǤimcʤ褯狼ʤΤ
  vjeξGetCandidateA()ȤȤˤ롣
  atokưȽ̤ƤδؿȤΤʤat.cͭˤ٤
*/
void GetCandidateAtok(HIMC imc,const CannaContext_t* cx,Array* euclist,int clnum,unsigned listnum,CANDIDATELIST* cb)
{
    Array cej;
    ArNew(&cej,2,NULL);
    for(unsigned cannum=0; cannum<cb->dwCount; ++cannum){
	if(!ImmNotifyIME(imc,NI_SELECTCANDIDATESTR,listnum,cannum)){
	    MSG("fail ImmNotifyIME(NI_SELECTCANDIDATESTR)\n");
	    break;
	}
	ArAddAr(euclist,GetClause(imc,cx,GCS_COMPSTR,clnum,clnum,&cej,NULL));
    }
    ArDelete(&cej);
}

void GetCandidateA(HIMC imc,const CannaContext_t* cx,Array* euclist,int clnum,unsigned listnum,CANDIDATELIST* cb)
{
    char *sj;
    Array cej;

    ArNew(&cej,2,NULL);
    for(unsigned cannum=0; cannum<cb->dwCount; ++cannum){
	sj = (char*)cb + cb->dwOffset[cannum];
	SjToEj(ArAlloc(&cej,strlen(sj)+1),sj,-1);
	ToWc(ArAdr(&cej),ArAdr(&cej));
	ArAddN(euclist,ArAdr(&cej),WcLen(ArAdr(&cej))+1);
    }
    ArDelete(&cej);
}	

void GetCandidateW(HIMC imc,const CannaContext_t* cx,Array* euclist,int clnum,unsigned listnum,CANDIDATELIST* cb)
{
    uint16_t *u16;
    Array cej;

    ArNew(&cej,2,NULL);
    for(unsigned cannum=0; cannum<cb->dwCount; ++cannum){
	u16 = (uint16_t*)((char*)cb + cb->dwOffset[cannum]);
	ArAlloc(&cej,WcLen(u16)+1);
	U16ToCej(ArAdr(&cej),u16,-1);
	ArAddAr(euclist,&cej);
    }
    ArDelete(&cej);
}	

/*
  Ѵc-eucjpˤƥꥹȤɲä롣ꥹȽλޡϤĤʤ
  euclistblocksize:2(wchar)
  ꥹȤο֤顼λ-1
*/
int lookup_cand_win(HIMC imc,Array* euclist,CandListPageInfo* pi,int clnum,const CannaContext_t* cx)
{
    Array candpage;
    int n,cand_count,listnum;
    CANDIDATELIST *cb;

#if 0
    if(!ImmNotifyIME(imc,NI_OPENCANDIDATE,0,0)){
	LOG("can't open candidate list\n");
	return -1;
    }
#endif

    ArNew(&candpage,1,NULL);
    cand_count = listnum = 0;
    do{
	//ImmGetCandidateListA/WʤƤʤ
	if((n = ImmGetCandidateList(imc,listnum,NULL,0)) == 0){
	    LOG("page %d has no candidate list\n",listnum);
	    break;
	}
	LOG("ImmGetCandidateList:page %d size %d\n",listnum,n);
	ArAlloc(&candpage,n);
	ImmGetCandidateList(imc,listnum,ArAdr(&candpage),ArUsingBytes(&candpage));

	//c-eucjpѴʤꥹȥХåեɲä
	cb = ArAdr(&candpage);
	cand_count += cb->dwCount;
	pi->Size[listnum] = cb->dwCount;
	if(euclist != NULL){
	    (*WimeData.GetCandidate)(imc,cx,euclist,clnum,listnum,cb);
	}
    }while(++listnum<CANDLISTMAX && ImmNotifyIME(imc,NI_CHANGECANDIDATELIST,listnum,0));

#if 1
    //裱᤹
    if(listnum > 0)
	ImmNotifyIME(imc,NI_CHANGECANDIDATELIST,0,0);
    if(cand_count > 0)
	ImmNotifyIME(imc,NI_SELECTCANDIDATESTR,0,0);
#endif

#if 0
    ImmNotifyIME(imc,NI_CLOSECANDIDATE,0,0);
    ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CONVERT,0);
    //??? ̤äƤޤΤǡѴ롣ʤǡ
#endif

    ArDelete(&candpage);
    return cand_count;
}

/*
  Ѵc-eucjpˤƥꥹȤɲä롣ꥹȽλޡϤĤʤ
  euclistblocksize:2(wchar)
  ꥹȤο֤顼λ-1
  euclist==NULLǤok
*/
int make_cand_list(HIMC imc,Array* euclist,CandListPageInfo* pi,int clnum,const CannaContext_t* cx)
{
    int count=0;
    Array cej;
    bool open_cand_win;

    /*
      "䥦ɥɽޤǤɬפѴ"ΤȤImmGetCandidateListϣ֤ImmNotifyIMENI_OPENCANDIDATEꤷƤ䥦ɥɽʤʤȤʤʤΤǡimcϣܤѴ֤ǤȤơ̤Ѵ֤ˤʤޤImmNotifyIMEѴΤӤѴ̤Ͽ롣
      ˡѴꥹȤä硢ؤΥॢǤʤܤθǳꤷ٣ѴʤФʤʤʤΤǡѴåĴ١WM_IME_NOTIFY(IMN_OPENCANDIDATE)褿ƤޤǤƱѴ롣
      ƤʸǺǽ򤹤롢ȤϤޤ̵ˡˤнϴñ(ޤǤˡǤ򤷤Ƥ)CandListPageInfoɬפʤʤΤɤ뤫
      uimϲ뤿ӤʸθĴ٤ä㤯٤ʤʡᤫ
    */
    ArNew(&cej,2,NULL);
    do{
	if(euclist!=NULL){
	    ArAddAr(euclist,GetClause(imc,cx,GCS_COMPSTR,clnum,clnum,&cej,NULL));
	}
	++count;
	ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CONVERT,0);
	open_cand_win = (MsgLoopN(1,WM_IME_NOTIFY,IMN_OPENCANDIDATE,NULL)==0);
    }while(!open_cand_win && GetAttr(imc,clnum,cx)!=ATTR_TARGET_NOTCONVERTED);

    if(open_cand_win){
	//ꥻåȤƤľ
	LOG("retry call lookup_cand_win()\n");
	if(euclist!=NULL)
	    ArClear(euclist);
	count = lookup_cand_win(imc,euclist,pi,clnum,cx);
    }else{
	//ܤѴ֤᤹
	ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CONVERT,0);
	pi->Seq = count;
    }
    ArDelete(&cej);
    return count;
}

void dump_cand_list(int num,const uint16_t* ws)
{
    Array lb;
    char *wd;

    ArNew(&lb,1,NULL);
    for(; *ws!=0; ws+=WcLen(ws)+1){
	ArPrint(&lb,"[%s]",wd=ToMb(ws));
	free(wd);
    }
    MSG("list=%d %s\n",num,ArAdr(&lb));
    ArDelete(&lb);
}

//11
bool wm_get_candi_list(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,cls_num,cand_count=-1;
    uint16_t bufsize,nul=0;
    HIMC imc;
    Array euclist,cej;
    CannaContext_t *cx;
    bool ret;

    Req6(ch,&cxn,&cls_num,&bufsize);
    LOG("context %d,clause-number %d,buffer size=%u\n",cxn,cls_num,bufsize);
    ArNew(&euclist,2,NULL);
    if((cx=ValidContext(cxn,__FUNCTION__)) != NULL){
	imc = ImmGetContext(cx->Win);
	ArNew(&cej,2,NULL);
	switch(SetTarget(imc,cls_num,cx)){ //ʸѹ
	case ChangeTargetSuccess:
	    if(cls_num < ArUsing(&cx->CandInfo))
		//ǰΤξϾäƤ
		memset(ArElem(&cx->CandInfo,cls_num),0,sizeof(CandListPageInfo));
	    else
		ArAlloc(&cx->CandInfo,cls_num+1); //ʸޤǤϳݤ
	    cand_count = make_cand_list(imc,&euclist,ArElem(&cx->CandInfo,cls_num),cls_num,cx);
	    if(cand_count >= 0){
#if 0
		//[1.8.5]cand_count0ˤʤ뤳Ȥ̵Ȼפ
                if(cand_count == 0){
                    /* Ѵ̰ʳ˸䤬ʤѴ̤ */
		    ArAddAr(&euclist,GetClause(imc,cx,GCS_COMPSTR,cls_num,cls_num,&cej,NULL));
                    ++cand_count;
                }
#endif
		//ɤߤɲ
		GetClause(imc,cx,GCS_COMPREADSTR,cls_num,cls_num,&cej,NULL);
		cand_count += append_fer_cand(cx->FerMode,&euclist,ArAdr(&cej)); //⡼ɤˤäƸꥹȤɲä
		ArAddAr(&euclist,&cej); //ɤߤɲ
		ArAdd(&euclist,&nul);	//ꥹȽλ򼨤̥ʸ

		VERBOSE(dump_cand_list(cand_count,ArAdr(&euclist)));

		if(ArUsingBytes(&euclist) > bufsize){
		    MSG("bufsize too small,need %d\n",ArUsingBytes(&euclist));
		    ArClear(&euclist);
		    cand_count = -1;
		}
	    }
	    break;
	case ChangeTargetFixed:
	    LOG("this clause is fixed\n");
	    break;
	case ChangeTargetFail:
	    MSG("fail SetTarget\n");
	}
	ArDelete(&cej);
    }
    ret = Reply7(ch->Major,ch->Minor,cand_count,ArAdr(&euclist),ArUsing(&euclist));
    ArDelete(&euclist);
    ImmReleaseContext(cx->Win,imc);
    return ret;
}

//12
bool wm_get_yomi(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,cln;
    uint16_t bufsize;
    HIMC imc;
    bool st=true;
    CannaContext_t *cx;
    Array cej;

    ArNew(&cej,2,NULL);
    Req6(ch,&cxn,&cln,&bufsize);
    LOG("context=%hd, clause=%hd, bufsize=%hd\n",cxn,cln,bufsize);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	imc = ImmGetContext(cx->Win);
	if(ArUsingBytes(GetClause(imc,cx,GCS_COMPREADSTR,cln,cln,&cej,NULL)) <= bufsize){
	    LOG("yomi:[%s]\n",ArAdr(&cej));
	}else{
	    MSG("buffer too small\n");
	    st = false;
	}
    }
    st = Reply7(ch->Major,ch->Minor,(st ? EjLen(ArAdr(&cej)):-1),ArAdr(&cej),ArUsing(&cej));
    ArDelete(&cej);
    ImmReleaseContext(cx->Win,imc);
    return st;
}

//եȥξ֤򥻥åȤ
void set_state(unsigned char state,uint16_t vk)
{
    if(vk & 0xff00){
	unsigned char keytab[256];
	GetKeyboardState(keytab);
	if((vk & VKMODKEY(WINMODKEY_SHIFT)) != 0)
	    keytab[VK_SHIFT]=state;
	if((vk & VKMODKEY(WINMODKEY_CTRL)) != 0)
	    keytab[VK_CONTROL]=state;
	if((vk & VKMODKEY(WINMODKEY_ALT)) != 0)
	    keytab[VK_MENU]=state;
	SetKeyboardState(keytab);
    }
}

/*??? '>','?'ʤɥեȥɬפʾ硢SetKeyboardState()̵֤ѹƤ롣 SendInput()ʤɤȤ٤ ⤽⺬Ū˥ץְäƤ뵤롣
  vk=ۥɡ壸ӥåȤˤϥեȾ֤򥻥åȤ롣
*/
bool proc_key_vk(uint16_t vk,HWND wh,HKL kl)
{
    bool st = false;
    uint32_t vkch = vk&0xff; //ۥ(եȤʤ)
    uint32_t sc = MapVirtualKeyEx(vkch,0,kl); //ۥɢ󥳡
    uint32_t pk = (sc<<16)|1; //ImmProcessKeyѤΥ󥳡

    set_state(0xff,vk);
    if(ImmProcessKey(wh,kl,vkch,pk,0)){
	if(ImmTranslateMessage(wh,WM_KEYDOWN,VK_PROCESSKEY,pk))
	    st = true;
	else
	    MSG("fail ImmTranslateMessage(), vkey=0x%hx, scancode=0x%x\n",vk,sc);
    }else{
	LOG("fail ImmProcessKey(),vkey=0x%hx, scancode=0x%x\n",vk,sc);
    }
    set_state(0,vk);
    return st;
}
bool proc_key_ch(char ch,HWND wh,HKL kl)
{
    return proc_key_vk(VkKeyScanEx(ch,kl),wh,kl); //ʸɢۥ
}

/*
  eucjpѤҤ餬ʤ޻ˤHWND
*/
bool send_roman(const char* yomi,HWND wh,HKL kl)
{
    bool st=true;
    char roman[strlen(yomi)*3+1];
    for(char* rp=Zen2Roman(roman,yomi); *rp!=0; ++rp){
	if(!proc_key_ch(*rp,wh,kl)){
	    st = false;
	    break;
	}
    }
    return st;
}

//13
bool wm_subst_yomi(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn;
    uint16_t beg,end,len;
    char *yomi;
    CannaContext_t* cx;
    bool st;

    yomi = Req4(ch,&cxn,&beg,&end,&len);
    VERBOSE(Array a;
	    ArNew(&a,1,NULL);
	    MSG("context=%hd, begin=%hd, end=%hd, length=%hd, yomi=%s\n",cxn,beg,end,len,yomi);
	    MSG("yomi dump:%s\n",ArAdr(Dump1(" %02x",yomi,strlen(yomi),&a)));
	    ArDelete(&a);
	);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	HKL kl = GetKeyboardLayout(0);
	if(len==0 && beg==end){
	    /*??? ڡ(Ѵ)򲡤ĹʸʤǸƤӽФ롣
	      Фʸ֤ȡFlushYomi褦
	      ??? 1.7.0:ѴƤȤbsʤɤϤƤ
	      ƤӽФ(beg<end)ߤѴ֤֤Τ
	      ??? 1.8.1:Ѵλ(beg==end)>0,ʸ֤FlushYomi,
	      ǡ޻λҲλbsǽ(beg==end)==0Ǹߤ
	      Ѵ֤֤(ʤʸʸ
	    */
	    int cln=0;
	    Array lst;
	    ArNew(&lst,2,NULL);
	    if(beg == 0){
		HIMC imc = ImmGetContext(cx->Win);
		cln = current_cand_list(0,&lst,cx,imc);
		ImmReleaseContext(cx->Win,imc);
	    }
	    st = Reply7(ch->Major,ch->Minor,cln,ArAdr(&lst),ArUsing(&lst));
	    ArDelete(&lst);
	}else{
	    while(++beg <= end)
		proc_key_ch('\b',cx->Win,kl); /* ɤʸν */
	    if(send_roman(yomi,cx->Win,kl)){ /* Ǹɲ */
		cx->Conv = 0;
		st = wm_ime_composition(cx,ch->Major);
	    }else
		st = Reply5(ch->Major,ch->Minor,-1); //顼
	}
    }else
	st = Reply5(ch->Major,ch->Minor,-1);
    free(yomi);
    return st;
}

//14
bool wm_store_yomi(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,cl;
    char *yomi;
    CannaContext_t* cx;
    bool st;

    yomi = Req11(ch,&cxn,&cl);
    LOG("context=%hd, clause=%hd, yomi='%s'\n",cxn,cl,yomi);

    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	Array scs[CS_MAX];
	HIMC imc = ImmGetContext(cx->Win);
	CompNew(scs);

	StoreComp(scs,imc,0,cl,EN_ALL);
	LoadComp(scs,imc);
	send_roman(yomi,cx->Win,GetKeyboardLayout(0));
	if(cx->CandInfo.use > cl+1)
	    cx->CandInfo.use = cl+1; //clޤ

	CompDelete(scs);
	ImmReleaseContext(cx->Win,imc);
	
	cx->Conv = 0;
	st = wm_ime_composition(cx,ch->Major);
    }else
	st = Reply5(ch->Major,ch->Minor,-1);
    free(yomi);
    return st;
}

/*???
  ɤȤ˸ƤФ Ȥꤢ줿ȤˤƤߤ롣
*/
//15
bool wm_store_range(CanHeader* ch,int fd)
{
    int16_t cxn,cl;
    char *yomi;
    CannaContext_t *cx,*tmpcx=NULL;
    Array cs[CS_MAX],cand;
    HIMC imc,tmpimc;
    bool st;
    int cl_r;

    yomi = Req11(ch,&cxn,&cl);
    LOG("context=%hd, clause=%hd, yomi='%s'\n",cxn,cl,yomi);

    ArNew(&cand,2,NULL);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL &&
       cl >= cx->FixedNum &&
       (tmpcx = OpenContext(fd,NewWin(),NULL))!=NULL &&
       set_yomi_str(tmpcx,IME_SMODE_SINGLECONVERT,CPS_CONVERT,yomi,0)){
	imc = ImmGetContext(cx->Win);
	tmpimc = ImmGetContext(tmpcx->Win);
	CompNew(cs);

	SetTarget(imc,cl,cx);//imctmpimcʸ᤬Ťʤʤ褦ˤ
	cl_r = cl - cx->FixedNum;
	StoreComp(cs,imc,0,cl_r,EN_ALL);	//cl-1ޤ
	StoreComp(cs,tmpimc,0,-1,EN_ALL);	//ñʸѴcl
	StoreComp(cs,imc,cl_r+1,-1,EN_ALL);	//cl+1ʹ
	if(LoadComp(cs,imc)){
	    if(ArUsing(&cx->CandInfo) > cl_r+1)
		ArSetUsing(&cx->CandInfo,cl_r+1); //clޤ
	    GetClause(imc,cx,GCS_COMPSTR,cl,cl,&cand,NULL);
	    VERBOSE(DbgComp(imc,__FUNCTION__));
	}else
	    MSG("fail load_comp()\n");

	CompDelete(cs);
	ImmReleaseContext(cx->Win,imc);
	ImmReleaseContext(tmpcx->Win,tmpimc);
    }

    CloseContext(tmpcx);
    st = Reply3(ch->Major,ch->Minor,(ArUsing(&cand)>0?0:-1),ArAdr(&cand),ArUsing(&cand));
    ArDelete(&cand);
    free(yomi);
    return st;
}

//16
bool wm_get_last_yomi(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,st=-1;
    uint16_t bufsize;
    Array cej;
    CannaContext_t* cx;
    bool ret;

    ArNew(&cej,2,NULL);
    Req3(ch,&cxn,&bufsize);
    LOG("context=%hd, bufsize=%hd\n",cxn,bufsize);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	int n;
	HIMC imc = ImmGetContext(cx->Win);
	if((n = GetAttrCl(imc,ATTR_INPUT,cx)) >= 0){
	    GetClause(imc,cx,GCS_COMPSTR,n,n,&cej,NULL);
	    st = ArUsing(&cej)-1;
	    LOG("cl-num=%d, string='%s'\n",n,(char*)ArAdr(&cej));
	}else{
	    //??? ̤ʸ᤬ʤȤϥ顼ʤΤ Ȥꤢｪλ롣
	    st = 0;
	    LOG("noting\n");
	}
	ImmReleaseContext(cx->Win,imc);
    }
    ret = Reply7(ch->Major,ch->Minor,st,ArAdr(&cej),ArUsing(&cej));
    ArDelete(&cej);
    return ret;
}

//17
bool wm_flush_yomi(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,cl,*cand;
    int32_t mode,n;
    bool st=false;
    CannaContext_t* cx;

    cand = Req10((Req10_t*)ch,&cxn,&cl,&mode);
    VERBOSE(Array a;
	    ArNew(&a,1,NULL);
	    MSG("context=%hd, clause=%hd, mode=%d, candidate=%s\n",cxn,cl,mode,ArAdr(Dump2("%hd ",cand,(ch->Length-8)/2,&a)));
	    ArDelete(&a);
	);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	HIMC imc = ImmGetContext(cx->Win);
	Array scs[CS_MAX],*at=scs+CS_STRATTR;
	char a;

	/*ѴƤʤʸ᤬뤫*/
	CompNew(scs);
	StoreComp(scs,imc,0,-1,EN_STRATTR);
	for(n=0; n<ArUsing(at); ++n){
	    a = *(char*)ArElem(at,n);
	    if(a==ATTR_INPUT || a==ATTR_TARGET_NOTCONVERTED)
		break;
	}
	cx->Conv = 0;
	cx->FerMode = mode;
	if(n < ArUsing(at)){
	    //ִ̤ʸ᤬
	    if(ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CONVERT,0)){
		st = true; //ȤWM_IME_COMPOSITIONåνǤ
	    }else
		MSG("fail ImmNotifyIME\n");
	}else{
	    //ǤѴѤ
	    LOG("already convert\n");
	    st = true; //??? ޤѴ
	}
	CompDelete(scs);
	ImmReleaseContext(cx->Win,imc);
    }
    return st ? wm_ime_composition(cx,ch->Major) : Reply5(ch->Major,ch->Minor,-1);
}

/*???
  StoreRangeƱĻȤ뤫狼ʤѴʸʾˤʤäƤФΤ?
  ѥåȤʸʸǤΤʸʹߤλĤʸ
*/
//18
bool wm_remove_yomi(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,cl,*cand;
    int32_t mode;
    CannaContext_t *cx;
    bool st=false;
    char clall=-1; //ʸ
    HIMC imc;

    cand = Req10((Req10_t*)ch,&cxn,&cl,&mode);
    VERBOSE(Array a;
	    ArNew(&a,1,NULL);
	    MSG("context=%hd, clause=%hd, mode=%d, candidate=%s\n",cxn,cl,mode,ArAdr(Dump2("%hd ",cand,(ch->Length-8)/2,&a)));
	    ArDelete(&a);
	);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	st = true;
	imc = ImmGetContext(cx->Win);
	if(mode && cl>=cx->FixedNum)
	    update_cand(imc,cand,cl-cx->FixedNum+1,&cx->CandInfo,cx);
	if(cl < cx->FixedNum-1){
	    //ʸΤߺ(ʸϣİʾĤ)
	    Array *fx[]={&cx->FixedStr,&cx->FixedYomi};
	    uint16_t *p;
	    for(int n=0; n<2; ++n){
		p = StrListNthWc(fx[n]->adr,cx->FixedNum,cl+1);
		fx[n]->use -= p - (uint16_t*)(fx[n]->adr); //ĤĹ
		memcpy(fx[n]->adr,p,fx[n]->use*fx[n]->blocksize);
	    }
	    cx->FixedNum -= cl+1;
	    LOG("fixed clauses %d\n",cx->FixedNum);
	}else{
	    //ʸ̤ʸϺ뤫⤷ʤ
	    if(cl >= cx->FixedNum){
		Array scs[CS_MAX];
		CompNew(scs);
		SetTarget(imc,cl+1,cx);
		StoreComp(scs,imc,cl+1-cx->FixedNum,-1,EN_ALL);
		if((st = LoadComp(scs,imc)))
		    VERBOSE(DbgComp(imc,__FUNCTION__));
		else
		    MSG("fail LoadComp()\n");
		CompDelete(scs);
	    }
	    cx->FixedNum = 0;
	    ArDelete(&cx->FixedStr);
	    ArDelete(&cx->FixedYomi);
	}
	if(st){
	    clall = cx->FixedNum+ClauseLen(imc,cx);

	    /* clޤǤθ󤬤оä˵ͤ */
	    int len = ArUsing(&cx->CandInfo) - cl - 1;
	    if(len >= 0){
		memcpy(cx->CandInfo.adr,ArElem(&cx->CandInfo,cl+1),len*cx->CandInfo.blocksize);
		cx->CandInfo.use = len;
		LOG("new candinfo length=%d\n",len);
	    }
	}
	ImmReleaseContext(cx->Win,imc);
    }
    //??? ȤꤢĤʸ֤Ƥߤ
    return Reply2(ch->Major,ch->Minor,clall);
}

//19
bool wm_get_simple_kanji(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn;
    char *dic,*yomi;
    uint16_t yomi_len,cand_bufsize,hinshi_bufsize;

    dic = Req13((Req13_t*)ch,&cxn,&yomi,&yomi_len,&cand_bufsize,&hinshi_bufsize);
    MSG("*** NOT IMPLIMENT ***\n");
    LOG("context=%hd, dic=%s, yomi='%s', yomi-len=%hd, cand-bufsize=%hd, hinshi-bufsize=%hd\n",cxn,dic,yomi,yomi_len,cand_bufsize,hinshi_bufsize);
    free(yomi);
    return Reply5(ch->Major,ch->Minor,-1);
}

//1a
bool wm_resize_pause(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,clnum,act;
    int st=0,*cls,*rcls;
    HIMC imc=NULL;
    char dum[5];
    CannaContext_t *cx;
    Array yomi,scs[CS_MAX],*cls_a=scs+CS_STRCL,*rcls_a=scs+CS_READCL;

    CompNew(scs);
    ArNew(&yomi,2,NULL);
    Req7(ch,&cxn,&clnum,&act);
    LOG("context=%hd, clause=%hd, action=%hd\n",cxn,clnum,act);
    if((cx = ValidContext(cxn,__FUNCTION__))!=NULL && clnum>=cx->FixedNum){
	imc = ImmGetContext(cx->Win);
	StoreComp(scs,imc,0,-1,EN_STRCL|EN_READCL);
	++ cls_a->use; //ǸǡʸˤȤ
	++ rcls_a->use;
	cls = cls_a->adr;
	rcls = rcls_a->adr;
	switch(SetTarget(imc,clnum,cx)){
	case ChangeTargetSuccess:
	    switch(act){
	    case -1: //ʸ򿭤Ф  ʸγϰ֤ʸ
		cls[clnum+1] += WimeData.CharSize;
		GetClause(imc,cx,GCS_COMPREADSTR,clnum+1,clnum+1,&yomi,NULL);
		rcls[clnum+1] += EjZen2Han(dum,ArAdr(&yomi));
		st = 1;
		break;
	    case -2: //ʸ̤  ʸγϰ֤ʸ
		cls[clnum+1] -= WimeData.CharSize;
		/*
		  ʸĴ
		  ʸκǸУʸ̤ʤФʤʤ(""Ȥ)
		*/
		GetClause(imc,cx,GCS_COMPREADSTR,clnum,clnum,&yomi,NULL);
		rcls[clnum+1] -= EjZen2Han(dum,ForwardEj(ArAdr(&yomi),EjLen(ArAdr(&yomi))-1));
		st = 1;
		break;
	    default:
		MSG("illegal action\n");
	    }
	    break;
	case ChangeTargetFixed:
	    LOG("this clause is fixed\n");
	    break;
	case ChangeTargetFail:
	    MSG("fail SetTarget()\n");
	}
    }
    if(st){
	st = (*WimeData.SetCompStr)(imc,SCS_CHANGECLAUSE,cls,ArUsingBytes(cls_a),rcls,ArUsingBytes(rcls_a));
	if(st){ //ʸȱʸ᤬ƶ뢪CandInfo򣰤᤹
	    if(clnum < ArUsing(&cx->CandInfo)){
		int n=1;
		if(clnum+1 < ArUsing(&cx->CandInfo))
		    ++n;
		memset(ArElem(&cx->CandInfo,clnum),0,n*sizeof(CandListPageInfo));
	    }
	}else{
	    VERBOSE(DbgComp(imc,"fail ImmSetCompositionString"));
	}
    }
    if(imc!=NULL)
	ImmReleaseContext(cx->Win,imc);
    CompDelete(scs);
    ArDelete(&yomi);
    return st ? (cx->Conv=clnum,wm_ime_composition(cx,ch->Major)) : Reply5(ch->Major,ch->Minor,-1);
}

//1b
bool wm_get_hinshi(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,cl,cand;
    uint16_t bufsize;

    Req8(ch,&cxn,&cl,&cand,&bufsize);
    MSG("*** NOT IMPLIMENT ***\n");
    LOG("context=%hd, clause=%hd, candidate=%hd, bufsize=%hu\n",cxn,cl,cand,bufsize);
    return Reply2(ch->Major,ch->Minor,-1);
}

//1c
bool wm_get_lex(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,cl,cand,bufsize;

    Req9(ch,&cxn,&cl,&cand,&bufsize);
    MSG("*** NOT IMPLIMENT ***\n"); 
    LOG("context=%hd, clause=%hd, candidate=%hd, bufsize=%hd\n",cxn,cl,cand,bufsize);
    return Reply5(ch->Major,ch->Minor,-1);
}

//1d RkGetStat
bool wm_get_status(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,clnum,cand;
    CannaContext_t *cx;
    int datalen=0;
    char st=-1;

    Req7(ch,&cxn,&clnum,&cand);
    LOG("context=%hd, clause number=%hd, candidate number=%hd\n",cxn,clnum,cand);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	Array e;
	int cand_count=-1;
	HIMC imc = ImmGetContext(cx->Win);
	ArNew(&e,1,NULL);
	cx->RkSt.bunnum = clnum;
	cx->RkSt.candnum = cand;

	/* [1.8.4]uimǤϸꥹȤФˤapiƤФ餷Τǡ
	   Ĵ٤ */
	CandListPageInfo *pi = ArElem(&cx->CandInfo,clnum);
	if(clnum>=ArUsing(&cx->CandInfo) || (pi->Seq==0 && pi->Size[0]==0)){
	    /* ʸǸꥹȤФƤʤȤ
	       䤬ʤäȤSize[0]0ˤʤ롣ꥹȤĴ٤ɤ
	       狼ʤΤǡΤȤϤƺĴ٤롣Τ˥ե饰ɲ
	       Τ⤦äȤ[1.8.5]䤬̵Ƥpi->Seq1ˤʤ(Ϥ)*/
	    ArAlloc(&cx->CandInfo,clnum+1);
	    pi = ArElem(&cx->CandInfo,clnum);
	    switch(SetTarget(imc,clnum,cx)){
	    case ChangeTargetSuccess:
		cand_count = make_cand_list(imc,NULL,pi,clnum,cx);
		break;
	    case ChangeTargetFixed:
		LOG("this clause is fixed\n");
		break;
	    case ChangeTargetFail:
		MSG("fail SetTarget\n");
	    }
	}
	cx->RkSt.diccand = pi->Seq;
	for(int n=0; n<CANDLISTMAX; ++n)
	    cx->RkSt.diccand += pi->Size[n];
	cx->RkSt.maxcand = cx->RkSt.diccand + fer_mode_num(cx->FerMode);
	// ylen,klenϥХȿǤϤʤʸ
	cx->RkSt.ylen = EjLen(ArAdr(GetClause(imc,cx,GCS_COMPREADSTR,clnum,clnum,&e,NULL)));
	cx->RkSt.klen = EjLen(ArAdr(GetClause(imc,cx,GCS_COMPSTR,clnum,clnum,&e,NULL)));
	cx->RkSt.tlen = 1; //??? ϲ
	datalen = sizeof(RkStat)/4;
	st = 0;
	ArDelete(&e);
	ImmReleaseContext(cx->Win,imc);

	LOG("bunnum=%d, candnum=%d, maxcand=%d, diccand=%d, ylen=%d, klen=%d, tlen=%d\n",cx->RkSt.bunnum,cx->RkSt.candnum,cx->RkSt.maxcand,cx->RkSt.diccand,cx->RkSt.ylen,cx->RkSt.klen,cx->RkSt.tlen);
    }
    return Reply4(ch->Major,ch->Minor,st,(int32_t*)(&cx->RkSt),datalen);
}

//1e
bool wm_set_locale(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    char *loc;

    loc = Req15(ch,&mode,&cxn);
    MSG("*** NOT IMPLIMENT ***\n");
    LOG("context=%hd, mode=%d, locale=%s\n",cxn,mode,loc);
    return Reply2(ch->Major,ch->Minor,-1);
}

/*???
  ɤ褦 IME_SMODE_AUTOMATICˤɤ߲̾򥻥åȤƤⲿⵯʤ
  ImmNotifyIME()ѴǤ뤬Ǥ̤ϢʸѴѤʤ
  饤ȤƤɤ߲̾޻ᤷϤȤime뤳Ȥˤ롣
  Ϥޤ⤦äȤޤˡϤʤ
*/
//1f
bool wm_auto_conv(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn;
    uint16_t bufsize;
    int32_t mode;
    HIMC imc;
    CannaContext_t *cx;
    char st=-1;

    Req5(ch,&cxn,&bufsize,&mode);
    LOG("context=%hd, bufsize=%hd, mode=0x%x\n",cxn,bufsize,mode);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	imc = ImmGetContext(cx->Win);
#ifdef SETCONTEXT_FAIL
	SetCurrentImc(imc,TRUE);
#else
	ImmSetOpenStatus(imc,TRUE);
	ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CANCEL,0);
#endif
	ImmSetConversionStatus(imc,CONV_MODE,IME_SMODE_AUTOMATIC);
	ImmReleaseContext(cx->Win,imc);
	cx->FerMode = mode;
	st=0;
    }
    return Reply2(ch->Major,ch->Minor,st);
}

//20
bool wm_query_ext(CanHeader* ch,int fd UNUSED)
{
    static const char name[]=
	"GetServerInfo\0"	"GetAccessControlList\0"
	"CreateDictionary\0"	"DeleteDictionary\0"
	"RenameDictionary\0"	"GetWordTextDictionary\0"
	"ListDictionary\0"	"Sync\0"
	"ChmodDictionary\0"	"CopyDictionary\0"

	//ɲ	pkt.hΥץȥֹ,main.cinit_cb()ѹ뤳
	"WimeOpenIMEDialog\0"
	"WimeSetCompWin\0"
	"WimeGetCompWin\0"
	"WimeSendKey\0"
	"WimeEnableIme\0"
	"WimeMoveShadowWin\0"
	"WimeSetCompFont\0"
	"WimeShowStatusWindow\0"
	"WimeGetCompStr\0"
	"WimeSetCandWin\0"
	"WimeRegXWindow\0"
	"WimeGetResultStr\0"
	"WimeSetResultStr\0"
	"WimeReconvert\0"
	;
    Req17_t *rq = (Req17_t*)ch;

    LOG("found index=%d\n",SubList(name,rq->p1));
    return Reply2(ch->Major,ch->Minor,SubList(name,rq->p1));
}

/*???
  ⡼ɤȥƥȤϤɤäȤ˻Ȥ
  ƥȤꤵȤȤϡƥȤȤ˥ץ̾ꤵȤȡ
*/
//21
bool wm_set_app_name(CanHeader* ch,int fd)
{
    char *name;
    int32_t mode;
    int16_t cxn;

    name = Req15(ch,&mode,&cxn);
    LOG("mode %d,context %hd,name %s, IGNORE mode and context\n",mode,cxn,name);
    FindClient(fd)->App = strdup(name);
    return Reply2(ch->Major,ch->Minor,0);
}

//22
bool wm_notice_group(CanHeader* ch,int fd)
{
    char *name;
    int32_t mode;
    int16_t cxn;

    name = Req15(ch,&mode,&cxn);
    LOG("mode %d,context %hd,group %s, IGNORE mode and context\n",mode,cxn,name);
    FindClient(fd)->Group = strdup(name);
    return Reply2(ch->Major,ch->Minor,0);
}

//24
bool wm_kill_server(CanHeader* ch,int fd UNUSED)
{
    LOG("kill wime\n");
    Reply2(ch->Major,ch->Minor,0);
    ImCloseAll();
    PostQuitMessage(0);
    return true;
}

//1-01
bool wm_get_server_info(CanHeader* ch,int fd UNUSED)
{
    MSG("*** NOT IMPLIMENT ***\n");
    return Reply2(ch->Major,ch->Minor,-1);
}

//1-02
bool wm_get_acl(CanHeader* ch,int fd UNUSED)
{
    MSG("*** NOT IMPLIMENT ***\n");
    return Reply5(ch->Major,ch->Minor,-1);
}

//1-03
bool wm_create_dic(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    char *dic;

    dic = Req15(ch,&mode,&cxn);
    MSG("*** NOT IMPLIMENT ***\n");
    LOG("context=%hd, mode=%d, dic=%s\n",cxn,mode,dic);
    return Reply2(ch->Major,ch->Minor,-1);
}

//1-04
bool wm_delete_dic(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    char *dic;

    dic = Req15(ch,&mode,&cxn);
    MSG("*** NOT IMPLIMENT ***\n"); 
    LOG("context=%hd, mode=%d, dic=%s\n",cxn,mode,dic);
    return Reply2(ch->Major,ch->Minor,-1);
}

//1-05
bool wm_rename_dic(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    char *cur_dic,*new_dic;

    new_dic = Req19(ch,&mode,&cxn,&cur_dic);
    MSG("*** NOT IMPLIMENT ***\n"); 
    LOG("context=%hd, mode=%d, current-dic=%s, new-dic=%s\n",cxn,mode,cur_dic,new_dic);
    return Reply2(ch->Major,ch->Minor,-1);
}

//1-06
bool wm_get_word_text_dic(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn;
    char *dir,*dic;
    uint16_t bufsize;

    bufsize = Req18((Req18_t*)ch,&cxn,&dir,&dic);
    MSG("*** NOT IMPLIMENT ***\n");
    LOG("context=%hd, directory=%s, dic=%s, bufsize=%hu\n",cxn,dir,dic,bufsize);
    return Reply5(ch->Major,ch->Minor,-1);
}

//1-07
/* ɥȤǤ׵᥿18ˤʤäƤ롣
   Υץȥ륿 i16,s8,u16 򥿥16ˤ
*/
bool wm_list_dic(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn;
    uint16_t bufsize;
    char *dirs;

    bufsize = Req16((Req16_t*)ch,&cxn,&dirs);
    MSG("*** NOT IMPLIMENT ***\n");
    LOG("context=%hd, bufsize=%hu, dir=%s\n",cxn,bufsize,dirs);
    return Reply2(ch->Major,ch->Minor,-1);
}

//1-08
bool wm_sync(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    char *dic;

    dic = Req15(ch,&mode,&cxn);
    MSG("*** NOT IMPLIMENT ***\n");
    LOG("context=%hd, mode=%d, dic=%s\n",cxn,mode,dic);
    return Reply2(ch->Major,ch->Minor,-1);
}

//1-09
bool wm_chmod_dic(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    char *dic;

    dic = Req15(ch,&mode,&cxn);
    MSG("*** NOT IMPLIMENT ***\n");
    LOG("context=%hd, mode=%d, dic=%s\n",cxn,mode,dic);
    return Reply5(ch->Major,ch->Minor,-1);
}

//1-0a
bool wm_copy_dic(CanHeader* ch,int fd UNUSED)
{
    int32_t mode;
    int16_t cxn;
    char *dir,*src,*dst;

    dst = Req21(ch,&mode,&cxn,&dir,&src);
    MSG("*** NOT IMPLIMENT ***\n");
    LOG("context=%hd, mode=%d, dir=%s, source=%s, destination=%s\n",cxn,mode,dir,src,dst);
    return Reply2(ch->Major,ch->Minor,-1);
}

/*
  ׵ᡧtype2
	i16  ܥåμ
		0=ץѥƥ
		1=ñ졿Ͽ
		2=桼
  type2
	i8   顼λ=-1

  ??? IME_CONFIG_REGISTERWORDԤΤϤʤ
*/
bool wm_wime_dialog(CanHeader* ch,int fd UNUSED)
{
    int modes[]={IME_CONFIG_GENERAL,IME_CONFIG_REGISTERWORD,IME_CONFIG_SELECTDICTIONARY};
    char st=-1;
    CannaContext_t* cx;
    uint16_t dialog_type = Req2(ch);
    REGISTERWORDA reg;

    LOG("dialog type code %d\n",dialog_type);

    //ImmConfigureIMEhwndϥХ륳ƥȤΤΤȤȤˤ롣
    reg.lpReading = reg.lpWord = NULL;
    cx = Context.adr;

    if(dialog_type<3 && ImmConfigureIME(GetKeyboardLayout(0),cx->Win,modes[dialog_type],&reg)){
	st = 0;
    }
    return Reply2(ch->Major,ch->Minor,st);
}

#ifdef DEBUG
//lp=intκѿΥɥ쥹,ͣ
BOOL CALLBACK EnumWin(HWND h,LPARAM lp)
{
    const char* hmdl(int mod)
    {
	static char buf[100];
	return GetModuleFileName((HMODULE)mod,buf,100) ? buf : "?";
    }

    int st,*counter=(int*)lp;
    char buf[100];
    LONG wl[][2]={{GWL_EXSTYLE,0},{GWL_STYLE,0},{GWL_WNDPROC,0},{GWL_HINSTANCE,0},{GWL_HWNDPARENT,0},{GWL_ID,0},{GWL_USERDATA,0}};
    DWORD cl[][2]={{GCW_ATOM,0},{GCL_HMODULE,0},{GCL_MENUNAME,0}};

    if((*counter)++ == 0)
	MSG("hwnd	class	exstyle	style	wndproc	instance	parent	id	userdata	atom	module	menu\n");

    for(st=0; st<7; ++st)
        wl[st][1] = GetWindowLong(h,wl[st][0]);
    for(st=0; st<3; ++st)
        cl[st][1] = GetClassLong(h,cl[st][0]);
    st = GetClassName(h,buf,100);

    MSG("%x\t%s\t",(unsigned)h,(st?buf:"(error)"));
    MSG("%x\t%x\t",wl[0][1],wl[1][1]); //exstyle,style
    MSG("%x\t",wl[2][1]); //wndproc
    MSG("%x(%s)\t%x\t",wl[3][1],hmdl(wl[3][1]),wl[4][1]); //instance,parent
    MSG("%x\t%x\t",wl[5][1],wl[6][1]); //id,userdata
    MSG("%x\t%x(%s)\t%x\n",cl[0][1],cl[1][1],hmdl(cl[1][1]),cl[2][1]); //atom,module,menu

    return TRUE;
}

void debug_window(HWND w)
{
    int dum=0;
    MSG("window listing...\n");
    EnumWindows(EnumWin,(LPARAM)&dum);
    MSG("...end,%d windows\n",dum);

    COMPOSITIONFORM cf;
    HIMC imc=ImmGetContext(w);
    ImmGetCompositionWindow(imc,&cf);
    ImmReleaseContext(w,imc);
    switch(cf.dwStyle){
    case CFS_DEFAULT:
	MSG("comp-form:default\n");
	break;
    case CFS_FORCE_POSITION:
	MSG("comp_form:force %d %d\n",cf.ptCurrentPos.x,cf.ptCurrentPos.y);
	break;
    case CFS_POINT:
	MSG("comp_form:point %d %d\n",cf.ptCurrentPos.x,cf.ptCurrentPos.y);
	break;
    case CFS_RECT:
	MSG("comp_form:rect %d %d %d %d\n",cf.rcArea.left,cf.rcArea.top,cf.rcArea.right,cf.rcArea.bottom);
	break;
    default:
	MSG("comp_form:??? (%x)\n",cf.dwStyle);
    }

    MSG("fg window:%x exist:%d visible:%d\n",(unsigned)GetForegroundWindow(),IsWindow(w),IsWindowVisible(w));
    MSG("fg window info...\n");
    dum=0;
    EnumWin(GetForegroundWindow(),(LPARAM)&dum);
    MSG("...end\n");
}
#endif

/*
  ImmSetCompositionWindow
  ׵ᡧtype11
	i16=ƥֹ
	i16=style
	s16=WIME_POS_DEFAULT:ʤ
	    WIME_POS_{FORCE,POINT}:x,y
	    WIME_POS_RECT:x,y,w,h   windowsȤϰ㤦Τ
  type2
	bool
*/
bool wm_wime_set_comp_win(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,style;
    uint16_t *params;
    COMPOSITIONFORM cf;
    CannaContext_t *cx;
    bool st=false;

    params = Req11r(ch,&cxn,&style);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	HIMC imc = ImmGetContext(cx->Win);

	switch(style){
	case WIME_POS_DEFAULT:
	    cf.dwStyle = CFS_DEFAULT;
	    break;
	case WIME_POS_FORCE:
	    cf.dwStyle = CFS_FORCE_POSITION;
	    break;
	case WIME_POS_POINT:
	    cf.dwStyle = CFS_POINT;
	    break;
	case WIME_POS_RECT:
	    cf.dwStyle = CFS_RECT;
	}

	switch(style){
	case WIME_POS_FORCE:
	case WIME_POS_POINT:
	    cf.ptCurrentPos.x = params[0];
	    cf.ptCurrentPos.y = params[1];
	    LOG("cxn=%hd pos=(%hd,%hd)\n",cxn,params[0],params[1]);
	    break;
	case WIME_POS_RECT:
	    cf.rcArea.left = params[0];
	    cf.rcArea.top = params[1];
	    cf.rcArea.right = params[0]+params[2];
	    cf.rcArea.bottom = params[1]+params[3];
	    //RECTΥإפǤ(r,b)ϻͳѤ˴ޤޤʤ
	    LOG("cxn=%hd rect=(%hd,%hd)-(%hd,%hd)\n",cxn,cf.rcArea.left,cf.rcArea.top,cf.rcArea.right,cf.rcArea.bottom);
	}
	st = ImmSetCompositionWindow(imc,&cf);
	ImmReleaseContext(cx->Win,imc);
	LOG("cxn %hd,wnd %x,ret %d\n",cxn,(unsigned)cx->Win,st);
    }
    return Reply2(ch->Major,ch->Minor,st);
}

/*
  ׵ᡧtype3
	i16=ƥֹ
	u16=winβۥ(VK_...ȥեȾ(8bit,cf. VkKeyScanEx))
  type6
	i16=	-2:Ѵ׵ᤵ줿
		-1:ime˽ʤä
		0:̵ʥƥֹ
		1:ime˽줿
	s8=ime˽줿Ȥγʸ(eucjp)()
*/
bool wm_wime_send_key(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,st=0;
    uint16_t vk;
    CannaContext_t *cx;
    Array ej;
    bool rep_st;

    ArNew(&ej,1,NULL);
    Req3(ch,&cxn,&vk);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	HIMC imc = ImmGetContext(cx->Win);
	HKL kl = GetKeyboardLayout(0);

	//ImmSetConversionStatus(imc,CONV_MODE,IME_SMODE_PHRASEPREDICT);

	if(proc_key_vk(vk,cx->Win,kl)){
	    st = 1;
	    GetClause(imc,cx,GCS_RESULTSTR,0,-1,&ej,NULL);
	    VERBOSE(DbgComp(imc,__func__));
	}else
	    st = -1;

	/*
	  Ѵλ,δؿWM_IME_REQUEST롣
	  proc_key_vk()ImmProcessKey()ǥå롼פ󤵤褦
	  proc_key_vk()̤ä̤ʤä褯ʬʤΤǡȤˤejϲ롣
	*/
	if(cx->Flags & PENDING_RECONV){
	    st = -2;
	    cx->Flags &= ~PENDING_RECONV;
	    ArDelete(&ej);
	    LOG("reconvertion --> pending\n");
	}

	ImmReleaseContext(cx->Win,imc);
	LOG("cxn %hd,wnd %x:vk 0x%hx --> proc_key status %hd\n",cxn,(unsigned)cx->Win,vk,st);
    }
    rep_st = Reply6s(ch->Major,ch->Minor,st,ArAdr(&ej));
    ArDelete(&ej);
    return rep_st;
}

/*
  ׵ᡧtype11
	i16=ƥֹ
	i16=ѴʸΥ֡ʸñ̡
	s16=Ѵ˻Ȥʸ(u16)
  type4
	i8=bool
	s32[0]=оʬγϰ(ʸñ)
	s32[1]=оʬĹʸñ̡
 */
bool wm_wime_reconv(CanHeader* ch,int fd UNUSED)
{
    uint16_t *reconv;
    int16_t cxn,cursor;
    CannaContext_t *cx;
    HIMC imc;
    int sz,bufsize;
    RECONVERTSTRING *rs;
    int32_t info[2];
    bool st;

    reconv = Req11r(ch,&cxn,&cursor);
    cx = ValidContext(cxn,__FUNCTION__);
    imc = ImmGetContext(cx->Win);
    sz = (WcLen(reconv)+1)*2;

    {
	Array x;ArNew(&x,1,NULL);
	if(reconv != NULL)
	    Dump2(" %04x",reconv,sz/2,&x);
	LOG("reconvert cursor:%hd, string:%s\n",cursor,ArAdr(&x));
	ArDelete(&x);
    }

    rs = calloc(bufsize = sizeof(RECONVERTSTRING)+sz,1);
    memcpy(rs+1,reconv,sz);
    rs->dwStrLen = sz-2;	//̥ʸϽ
    rs->dwStrOffset = sizeof(*rs);
    rs->dwTargetStrOffset = cursor*2;	//Хñ
    st = ImmSetCompositionStringW(imc,SCS_QUERYRECONVERTSTRING,rs,bufsize,NULL,0) && ImmSetCompositionStringW(imc,SCS_SETRECONVERTSTRING,rs,bufsize,NULL,0);
    info[0] = rs->dwCompStrOffset/2;	//??? atok08ǤϥХȿߤ
    info[1] = rs->dwCompStrLen;		//??? äʸߤ

    LOG("status %d, CompStrOffset %d, CompStrLen %d\n",st,rs->dwCompStrOffset,rs->dwCompStrLen);
    VERBOSE(DbgComp(imc,__func__));

    ImmReleaseContext(cx->Win,imc);
    free(rs);
    return Reply4(ch->Major,ch->Minor,st,info,2);
}

/*
  imcıƥɥΰ֤礭ѹ
  (x,y),(w,h)줾Τɤ餫ǤлѤʤ
  s16ʸȤ(ХȥѤ)뤳
  ׵ᡧtype11
	i16=ƥֹ
	i16=unused
	s16[0,1]=(x,y)
	s16[2,3]=(w,h)
  type2
	bool
*/
bool wm_wime_move_shadow_win(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,dum,*ax;
    CannaContext_t *cx;
    bool st=false;

    ax = (int16_t*)Req11r(ch,&cxn,&dum);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	int flg = SWP_NOREDRAW; /*SWP_NOZORDER|SWP_HIDEWINDOW|*/
	if(ax[0]<0 || ax[1]<0)
	    flg |= SWP_NOMOVE;
	if(ax[2]<0 || ax[3]<0)
	    flg |= SWP_NOSIZE;
	st = SetWindowPos(cx->Win,HWND_TOP,ax[0],ax[1],ax[2],ax[3],flg);
	LOG("context %hd (%hd,%hd)-%hdx%hd --> status %d\n",cxn,ax[0],ax[1],ax[2],ax[3],st);
    }
    return Reply2(ch->Major,ch->Minor,st);
}

//xlfdΥ̾ͤˤ
//!!! mediumFW_NORMAL400ǤϤʤ500ˤʤäƤޤɤ롩
int weight_value(const char* w,int wlen)
{
    struct{
	char *name;
	int value;
    } tab[]={
	{"thin",FW_THIN},{"extralight",FW_EXTRALIGHT}, {"ultraright",FW_ULTRALIGHT},{"light",FW_LIGHT},	{"normal",FW_NORMAL},{"regular",FW_REGULAR},{"medium",FW_MEDIUM},{"semibold",FW_SEMIBOLD}, {"demibold",FW_DEMIBOLD},{"bold",FW_BOLD},{"extrabold",FW_EXTRABOLD},{"ultrabold",FW_ULTRABOLD}, {"heavy",FW_HEAVY},{"black",FW_BLACK}
    };
    char wname[wlen+1];
    memcpy(wname,w,wlen);
    wname[wlen]=0;

    int v = FW_NORMAL;
    for(unsigned n=0; n<ITEMS(tab); ++n){
	if(strcasecmp(wname,tab[n].name)==0){
	    v=tab[n].value;
	    break;
	}
    }
    return v;
}

/*
  եȥåȤjisx0208LOGFONTꤹ롣
*/
bool fontset_to_logfont(LOGFONT* lf,const char* fs)
{
    char *pt[14],jx0208[]="jisx0208";
    bool st=false;

    memset(lf,0,sizeof(*lf));
    lf->lfCharSet=SHIFTJIS_CHARSET;
    lf->lfOutPrecision=OUT_DEFAULT_PRECIS;
    lf->lfClipPrecision=CLIP_DEFAULT_PRECIS;
    lf->lfWeight = FW_NORMAL;

    while(fs != NULL){
	//xlfdǤƬɥ쥹pt[]
	for(int n=0; n<14; ++n)
	    pt[n] = NULL;
	for(int n=0; n<14; ++n){
	    if((pt[n] = strchr(fs,'-'))==NULL || *(fs = ++pt[n])==0)
		break;
	}

	if(strncasecmp(pt[12],jx0208,sizeof(jx0208)-1) == 0){
	    int len = pt[2]-pt[0]-1;
	    memcpy(lf->lfFaceName,pt[0],len);
	    lf->lfFaceName[len] = 0;
	    lf->lfFaceName[pt[1]-pt[0]-1] = ' ';

	    lf->lfHeight = atoi(pt[6]);
	    lf->lfWeight = weight_value(pt[2],pt[3]-pt[2]-1);
	    if(*pt[3] == 'i')
		lf->lfItalic = TRUE;
	    st=true;
	    break;
	}

	fs = strchr(fs,',');
    }
    return st;
}

/*
  ѴɥΥեȤꤹ
  ׵ᡧtype15
	i32=طʿ
	i16=ƥֹ
	s8=եȥå
  type5
	i16=եȤι⤵顼λ0

  ??? طʿλϤɤ뤫
*/
bool wm_wime_set_comp_font(CanHeader* ch,int fd UNUSED)
{
    int16_t h=0,cxn;
    uint32_t bg;
    CannaContext_t *cx;
    char *fontname;

    MSG("*** PARTIAL IMPLIMENT ***\n"); 
    fontname = Req15(ch,(int32_t*)&bg,&cxn);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	LOGFONT lf;
	int height;
	HIMC imc = ImmGetContext(cx->Win);

	LOG("fontset '%s'\n",fontname);
	if(fontset_to_logfont(&lf,fontname)){
	    LOG("alias name='%s',size %d,weight %d,italic=%d\n",lf.lfFaceName,lf.lfHeight,lf.lfWeight,lf.lfItalic);
	    if(!ImmSetCompositionFont(imc,&lf))
		MSG("fail ImmSetCompositionFont()\n");
	}else
	    MSG("fail fontset_to_logfont()\n");

	ImmGetCompositionFont(imc,&lf);
	h = abs(lf.lfHeight);
	LOG("facename '%s',height %d\n",lf.lfFaceName,lf.lfHeight);

	ImmReleaseContext(cx->Win,imc);
    }
    return Reply5(ch->Major,ch->Minor,h);
}

//ơɥɽ
void show_status_window(CannaContext_t* cx,bool shw)
{
    if(shw){
	if(!(cx->Flags & OPEN_STATUS_WINDOW)){
	    //ΥƥȤϤޤơɥɽƤʤ
	    cx->Flags |= OPEN_STATUS_WINDOW;
	    if(WimeData.StWinHolders++ == 0){
		SendMessageW(cx->Win,WM_IME_NOTIFY,IMN_OPENSTATUSWINDOW,0);
		LOG("show status window\n");
	    }
	}else
	    LOG("already show status window\n");
    }else{
	CheckCloseStWin(cx);
    }
}

/*
  ơɥɽ
  ƤΥƥȤɽˤȤ˥ơɥĤ롣

  ׵ᡧtype3
	i16=ƥֹ
	u16=bool
  type5
	i16=bool
*/
bool wm_wime_show_status_window(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,shw,st=0;
    CannaContext_t *cx;

    Req3(ch,&cxn,(uint16_t*)&shw);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	show_status_window(cx,shw);
	st=1;//ޤΤȤˣ֤
    }
    return Reply5(ch->Major,ch->Minor,st);
}

/*
  imeѤ
  ׵ᡧtype9
	i16=ƥֹ
	i16=bool open_ime
	i16=bool use status window(open_ime==falseʤ鶯Ūfalse)
	i16=bool use compostion window(open_ime==falseʤ鶯Ūfalse)
  type2
	bool
  Ʊ˥ơɥɽ/ɽ롣ȤΤxim顢ơɥɬפ
*/
bool wm_wime_enable_ime(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,en_ime,stwin,compwin;
    CannaContext_t *cx;
    bool st=false;

    Req9(ch,&cxn,&en_ime,&stwin,&compwin);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	HIMC imc = ImmGetContext(cx->Win);
	if(en_ime){
	    //뤬ŤʤäƤȸ䥦ɥƤޤΤǰ־ˤ
	    BringWindowToTop(cx->Win);

	    if(stwin)
		cx->Flags |= PROC_NOTIFY_MSG;
	    if(compwin)
		cx->Flags |= PROC_COMP_MSG;
	    SetCurrentImc(imc,TRUE);
	    ImmSetConversionStatus(imc,CONV_MODE,IME_SMODE_PHRASEPREDICT);
	    show_status_window(cx,true);
	}else{
	    show_status_window(cx,false);
	    SetCurrentImc(imc,FALSE);
	    cx->Flags &= ~(PROC_NOTIFY_MSG|PROC_COMP_MSG);
	}
	ImmReleaseContext(cx->Win,imc);
	LOG("cxn %hd en_ime %hd:flags 0x%x\n",cxn,en_ime,cx->Flags);
	st=true;
    }
    return Reply2(ch->Major,ch->Minor,st);
}

/*
  Ѵʸ
  ׵ᡧtype2
	i16=ƥֹ
  type10
	i8	顼=0,Ѵʸ󤬤=1,ʤ=-1
	s8	Ѵʸ
	s8	(nil)
	s32	WimeCompStrInfo
*/
bool wm_wime_get_comp_str(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn;
    CannaContext_t *cx;
    WimeCompStrInfo si;
    char ret_code=0;
    Array comp_str;

    ArNew(&comp_str,1,NULL);
    si.TargetClause = -1;
    cxn = Req2(ch);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	Array ej;
	char attr;
	int cln;
	HIMC imc = ImmGetContext(cx->Win);
	ArNew(&ej,1,NULL);

	//ʸeucjpˤƤĤʤ
	for(cln=0; GetClause(imc,cx,GCS_COMPSTR,cln,cln,&ej,&attr)!=NULL; ++cln){
	    if(attr==ATTR_TARGET_CONVERTED || attr==ATTR_TARGET_NOTCONVERTED){
		si.TargetClause = EjLen(ArAdr(&comp_str));
		si.TargetClLen = EjLen(ArAdr(&ej));
	    }
	    ArAddAr(ArDec(&comp_str),&ej);
	}
	si.Length = EjLen(ArAdr(&comp_str));

	//CursorPosDeltaStart
	INPUTCONTEXT *ic=(INPUTCONTEXT*)ImmLockIMC(imc);
	COMPOSITIONSTRING *cs=(COMPOSITIONSTRING*)ImmLockIMCC(ic->hCompStr);
	si.CursorPos = cs->dwCursorPos;
	si.DeltaStart = cs->dwDeltaStart;
	ImmUnlockIMCC(ic->hCompStr);
	ImmUnlockIMC(imc);

	ImmReleaseContext(cx->Win,imc);
	ArDelete(&ej);

	if(cln > 0){
	    LOG("'%s' %d %d %d %d %d\n",(char*)ArAdr(&comp_str),si.CursorPos,si.DeltaStart,si.TargetClause,si.TargetClLen,si.Length);
	    ret_code = 1;
	}else{
	    LOG("(none)\n");
	    ret_code = -1;
	}
    }

    bool st = Reply10(ch->Major,ch->Minor,ret_code,(ret_code>0 ? ArAdr(&comp_str):""),"",(int32_t*)&si,sizeof(si));
    ArDelete(&comp_str);
    return st;
}

/*
  Ѵɥξ
  ׵ᡧtype2
	i16=ƥֹ
  type4
	i8	顼=0
	s32[0]	(WIME_POS_xxx)
	s32[1]	x
	s32[2]	y
	s32[3]	w
	s32[4]	h

	Ȥʤɸǡ-1
*/
bool wm_wime_get_comp_win(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn;
    CannaContext_t *cx;
    int32_t v[5],*vp;
    char st=0;

    cxn = Req2(ch);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	COMPOSITIONFORM cf;
	HIMC imc = ImmGetContext(cx->Win);
	if(ImmGetCompositionWindow(imc,&cf)){
	    vp = memset(v,-1,sizeof(v));
	    st = 1;
	    switch(cf.dwStyle){
	    case CFS_DEFAULT:
		*vp = WIME_POS_DEFAULT;
		break;
	    case CFS_FORCE_POSITION:
		*vp = WIME_POS_FORCE;
		break;
	    case CFS_POINT:
		*vp = WIME_POS_POINT;
		break;
	    case CFS_RECT:
		*vp = WIME_POS_RECT;
	    }
	    ++vp;
	    switch(cf.dwStyle){
	    case CFS_FORCE_POSITION:
	    case CFS_POINT:
		*(vp++) = cf.ptCurrentPos.x;
		*(vp++) = cf.ptCurrentPos.y;
		break;
	    case CFS_RECT:
		*(vp++) = cf.rcArea.left;
		*(vp++) = cf.rcArea.top;
		*(vp++) = cf.rcArea.right - cf.rcArea.left;
		*(vp++) = cf.rcArea.bottom - cf.rcArea.top;
	    }
	    VERBOSE(Array a;
		    ArNew(&a,1,NULL);
		    MSG("%s\n",ArAdr(Dump4("[%d]",v,ITEMS(v),&a)));
		    ArDelete(&a);
		);
	}else
	    MSG("fail ImmGetCompositionWindow\n");
	ImmReleaseContext(cx->Win,imc);
    }
    return Reply4(ch->Major,ch->Minor,st,v,ITEMS(v));
}

/*
  ImmSetCandidateWindow
  ׵ᡧtype11
	i16=ƥֹ
	i16=style WIME_POS_POINT,WIME_POS_EXCLUDE
	s16 [0,1]=x,y
	    [2,3,4,5]=x,y,w,h WIME_POS_EXCLUDEΤȤ(WIME_POS_POINTǤ̵)
  type2
	bool
*/
bool wm_wime_set_cand_win(CanHeader* ch,int fd UNUSED)
{
    int16_t cxn,style;
    uint16_t *params;
    CannaContext_t *cx;
    bool st=false;

    params = Req11r(ch,&cxn,&style);
    if((cx = ValidContext(cxn,__FUNCTION__)) != NULL){
	CANDIDATEFORM cf;
	HIMC imc = ImmGetContext(cx->Win);

	cf.dwIndex = 0;
	cf.ptCurrentPos.x = params[0];
	cf.ptCurrentPos.y = params[1];
	LOG("cxn=%hd pos=(%hd,%hd)\n",cxn,params[0],params[1]);
	switch(style){
	case WIME_POS_POINT:
	    cf.dwStyle = CFS_CANDIDATEPOS;
	    break;
	case WIME_POS_EXCLUDE:
	    cf.dwStyle = CFS_EXCLUDE;
	    cf.rcArea.left = params[2];
	    cf.rcArea.top = params[3];
	    cf.rcArea.right = cf.rcArea.left+params[4];
	    cf.rcArea.bottom = cf.rcArea.top+params[5];
	    LOG("rect=(%hd,%hd)-(%hd,%hd)\n",cf.rcArea.left,cf.rcArea.top,cf.rcArea.right,cf.rcArea.bottom);
	}
	st = ImmSetCandidateWindow(imc,&cf);
	ImmReleaseContext(cx->Win,imc);
	LOG("cxn %hd,wnd %x,ret %d\n",cxn,(unsigned)cx->Win,st);
    }
    return Reply2(ch->Major,ch->Minor,st);
}

/*
  ׵:PktRegXWin
  :ʤ
*/
bool wm_wime_reg_x_window(CanHeader* ch,int fd UNUSED)
{
    PktRegXWin *p = (typeof(p))(ch+1);
    CannaContext_t *cx;
    bool st=false;

    if((cx = ValidContext(p->cxn,__FUNCTION__)) != NULL){
	cx->XWin = p->xwin;
	st = true;
	LOG("cxn %hd window %x\n",p->cxn,p->xwin);
    }
    return st;
}

/*
  ׵ᡧPktCxNum
  ʸ(utf16le,̥ʸդ)
*/
bool wm_wime_get_result_str(CanHeader* ch,int fd UNUSED)
{
    PktCxNum *p = (typeof(p))(ch+1);
    CannaContext_t *cx;
    bool st;
    Array scs[CS_MAX];

    CompNew(scs);
    if((cx = ValidContext(p->cxn,__FUNCTION__)) != NULL){
	int nul=0;
	HIMC imc = ImmGetContext(cx->Win);
	StoreComp(scs,imc,0,-1,EN_RESULT);
	ArAdd(&scs[CS_RESULT],&nul);
	ImmReleaseContext(cx->Win,imc);
	VERBOSE(Array d;ArNew(&d,2,NULL);MSG("result str(utf16)=%s\n",ArAdr(Dump2(" 0x%04x",ArAdr(&scs[CS_RESULT]),ArUsing(&scs[CS_RESULT]),&d)));ArDelete(&d));
    }
    st = ReplyN(ch->Major,ch->Minor,ArAdr(&scs[CS_RESULT]),ArUsingBytes(&scs[CS_RESULT]));
    CompDelete(scs);
    return st;
}

/*
  ʸϤȤ롣
  ׵ᡧPktResultStr(eucjp)
  ʤ
*/
bool wm_wime_set_result_str(CanHeader* ch,int fd UNUSED)
{
    PktResultStr *p = (typeof(p))(ch+1);
    CannaContext_t *cx;
    bool st=false;
    if((cx = ValidContext(p->cxn,__FUNCTION__)) != NULL){
	LOG("context %d,string='%s'\n",p->cxn,p->str);

	HIMC imc = ImmGetContext(cx->Win);
	SetCurrentImc(imc,TRUE);
	ImmSetConversionStatus(imc,CONV_MODE,IME_SMODE_PHRASEPREDICT);
	uint16_t *uc = EjToU16(NULL,p->str);
	ImmSetCompositionStringW(imc,SCS_QUERYRECONVERTSTRING,uc,WcLen(uc)*2,NULL,0);
	DbgComp(imc,__func__);
	ImmSetCompositionStringW(imc,SCS_SETRECONVERTSTRING,uc,WcLen(uc)*2,NULL,0);
	DbgComp(imc,__func__);
	ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CONVERT,0);
	DbgComp(imc,__func__);


	//st = set_yomi_str(cx,IME_SMODE_PHRASEPREDICT,CPS_COMPLETE,p->str,0);

/*
	HIMC imc = ImmGetContext(cx->Win);
#ifdef SETCONTEXT_FAIL
	SetCurrentImc(imc,FALSE);
#else
	ImmSetOpenStatus(imc,FALSE);
#endif
	ImmReleaseContext(cx->Win,imc);
*/

/*
	if(st)
	    PostMessage(cx->Win,WM_IME_COMPOSITION,0,GCS_RESULTSTR|GCS_RESULTCLAUSE);
*/
    }
    return st;
}
