#include "wimexim.h"
#include "wimeapi.h"
#include <X11/Xutil.h>

/*
  ic°FocusWindowѥɥĤ롣
  rootFocusWindowϻȤƤʤȤ֤פ
*/

extern char *DefaultCompFont;

static void init(CallbackParam* p)
{
    SetCompFont(p->Ic);
    WimeSetCompWin(p->Ic->WimeCxn,WIME_POS_POINT,0,0);

    int x=0,y=0,h=p->Ic->CompFontHeight,w=h*20;
    p->Ic->Attrs.FocusWindow = XCreateSimpleWindow(p->Disp,XDefaultRootWindow(p->Disp),x,y,w,h,0,0,WhitePixel(p->Disp,XDefaultScreen(p->Disp)));
    p->Ic->Attrs.Defined |= FLG(IC_FOCUS_WINDOW);

    //Խ뤬ư줿ư
    XSelectInput(p->Disp,p->Ic->Attrs.FocusWindow,StructureNotifyMask);

    //ϼΤclientǹԤʤΤ,Խɥ˥եʤ褦ˤ 
    XWMHints *hints = XAllocWMHints(); //0ꥢ(hints->input=False)
    hints->flags = InputHint;
    XSetWMHints(p->Disp,p->Ic->Attrs.FocusWindow,hints);
    XFree(hints);
}

//StructureNotifyMask򥻥åȤɥ֤
static Window target_window(const IcData* ic)
{
    return ic->Attrs.FocusWindow;
}
//ư
static void move_wime(Display* disp,const IcData* ic,int x UNUSED,int y UNUSED)
{
    MoveWineWindow(disp,ic);
    WimeSetCompWin(ic->WimeCxn,WIME_POS_POINT,0,0);
}

static int open_ime(CallbackParam* p,bool st)
{
    WimeEnableIme(p->Ic->WimeCxn,st,true,true);

    if(st){
	XMapWindow(p->Disp,p->Ic->Attrs.FocusWindow);
    }else
	XUnmapWindow(p->Disp,p->Ic->Attrs.FocusWindow);
    return 0;
}

static void cleanup(CallbackParam* p)
{
    if(p->Ic->Attrs.FocusWindow != 0){
	XDestroyWindow(p->Disp,p->Ic->Attrs.FocusWindow);
    }
}

static int done_preedit(CallbackParam* p UNUSED)
{
    return 0;
}

static bool reject_key(CallbackParam* p UNUSED)
{
    return true;
}

ConvCallbackFuncs ConvFuncRootInput = {
    .OpenIme =		open_ime,
    .Done =		done_preedit,
    .Draw =		ConvDoNothing,
    .RejectKey =	reject_key,
    .Cleanup =		cleanup,
    .SetSpotLoc =	ConvDoNothing,
    .Init =		init,
    .TargetWindow =	target_window,
    .MoveWime =		move_wime,
};
