##############################################################################
## Name:        cppImpl.py
## Purpose:     generates c++ file and saves it
## Author:      Alex Thuering
## Created:     2005/05/10
## RCS-ID:      $Id: cppImpl.py,v 1.2 2005/05/16 11:00:17 ntalex Exp $
## Copyright:   (c) 2005 Alex Thuering
## Notes:       some modules adapted from svgl project
##############################################################################

import os.path
import genFile

class Impl:
	def __init__(self, name, script_name):
		self.name = name
		self.script_name = script_name
		self.content=''

	def add_content(self, content):
		self.content = self.content + content

	def dump(self, path=''):
		data = '''\
//////////////////////////////////////////////////////////////////////////////
// Name:        %s.cpp
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by %s
//////////////////////////////////////////////////////////////////////////////

%s
'''%(self.name, self.script_name, self.content)

		filename = os.path.join(path, self.name+'.cpp')
		f = genFile.gfopen(filename,'w')
		f.write(data)
