.ds q \N'34'
.TH RADEON __drivermansuffix__ __vendorversion__
.SH NAME
radeon \- ATI/AMD RADEON video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qradeon\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B radeon
is an __xservername__ driver for ATI/AMD RADEON-based video cards with the
following features:
.PP
.PD 0
.TP 2
\(bu
Full support for 8-, 15-, 16- and 24-bit pixel depths;
.TP
\(bu
RandR 1.2 and RandR 1.3 support;
.TP
\(bu
Full EXA 2D acceleration;
.TP
\(bu
Textured XVideo acceleration including anti-tearing support (Bicubic filtering
only available on R/RV3xx, R/RV/RS4xx, R/RV5xx, and RS6xx/RS740);
.TP
\(bu
3D acceleration;
.PD
.SH SUPPORTED HARDWARE
The
.B radeon
driver supports PCI, AGP, and PCIe video cards based on the following ATI/AMD chips
(note: list is non-exhaustive):
.PP
.PD 0
.TP 12
.B R100
Radeon 7200
.TP 12
.B RV100
Radeon 7000(VE), M6, RN50/ES1000
.TP 12
.B RS100
Radeon IGP320(M)
.TP 12
.B RV200
Radeon 7500, M7, FireGL 7800
.TP 12
.B RS200
Radeon IGP330(M)/IGP340(M)
.TP 12
.B RS250
Radeon Mobility 7000 IGP
.TP 12
.B R200
Radeon 8500, 9100, FireGL 8800/8700
.TP 12
.B RV250
Radeon 9000PRO/9000, M9
.TP 12
.B RV280
Radeon 9200PRO/9200/9200SE/9250, M9+
.TP 12
.B RS300
Radeon 9100 IGP
.TP 12
.B RS350
Radeon 9200 IGP
.TP 12
.B RS400/RS480
Radeon XPRESS 200(M)/1100 IGP
.TP 12
.B R300
Radeon 9700PRO/9700/9500PRO/9500/9600TX, FireGL X1/Z1
.TP 12
.B R350
Radeon 9800PRO/9800SE/9800, FireGL X2
.TP 12
.B R360
Radeon 9800XT
.TP 12
.B RV350
Radeon 9600PRO/9600SE/9600/9550, M10/M11, FireGL T2
.TP 12
.B RV360
Radeon 9600XT
.TP 12
.B RV370
Radeon X300, M22
.TP 12
.B RV380
Radeon X600, M24
.TP 12
.B RV410
Radeon X700, M26 PCIe
.TP 12
.B R420
Radeon X800 AGP
.TP 12
.B R423/R430
Radeon X800, M28 PCIe
.TP 12
.B R480/R481
Radeon X850 PCIe/AGP
.TP 12
.B RV505/RV515/RV516/RV550
Radeon X1300/X1400/X1500/X1550/X2300
.TP 12
.B R520
Radeon X1800
.TP 12
.B RV530/RV560
Radeon X1600/X1650/X1700
.TP 12
.B RV570/R580
Radeon X1900/X1950
.TP 12
.B RS600/RS690/RS740
Radeon X1200/X1250/X2100
.TP 12
.B R600
Radeon HD 2900
.TP 12
.B RV610/RV630
Radeon HD 2400/2600/2700/4200/4225/4250
.TP 12
.B RV620/RV635
Radeon HD 3410/3430/3450/3470/3650/3670
.TP 12
.B RV670
Radeon HD 3690/3850/3870
.TP 12
.B RS780/RS880
Radeon HD 3100/3200/3300/4100/4200/4250/4290
.TP 12
.B RV710/RV730
Radeon HD 4330/4350/4550/4650/4670/5145/5165/530v/545v/560v/565v
.TP 12
.B RV740/RV770/RV790
Radeon HD 4770/4730/4830/4850/4860/4870/4890
.TP 12
.B CEDAR
Radeon HD 5430/5450/6330/6350/6370
.TP 12
.B REDWOOD
Radeon HD 5550/5570/5650/5670/5730/5750/5770/6530/6550/6570
.TP 12
.B JUNIPER
Radeon HD 5750/5770/5830/5850/5870/6750/6770/6830/6850/6870
.TP 12
.B CYPRESS
Radeon HD 5830/5850/5870
.TP 12
.B HEMLOCK
Radeon HD 5970
.TP 12
.B PALM
Radeon HD 6310/6250
.TP 12
.B SUMO/SUMO2
Radeon HD 6370/6380/6410/6480/6520/6530/6550/6620
.TP 12
.B BARTS
Radeon HD 6790/6850/6870/6950/6970/6990
.TP 12
.B TURKS
Radeon HD 6570/6630/6650/6670/6730/6750/6770
.TP 12
.B CAICOS
Radeon HD 6430/6450/6470/6490
.TP 12
.B CAYMAN
Radeon HD 6950/6970/6990
.TP 12
.B ARUBA
Radeon HD 7000 series
.TP 12
.B TAHITI
Radeon HD 7900 series
.TP 12
.B PITCAIRN
Radeon HD 7800 series
.TP 12
.B VERDE
Radeon HD 7700 series
.TP 12
.B OLAND
Radeon HD 8000 series
.TP 12
.B HAINAN
Radeon HD 8000 series
.TP 12
.B BONAIRE
Radeon HD 7790 series
.TP 12
.B KAVERI
KAVERI APUs
.TP 12
.B KABINI
KABINI APUs
.TP 12
.B HAWAII
Radeon R9 series
.TP 12
.B MULLINS
MULLINS APUs
.PD
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The following driver
.B Options
are supported:
.TP
.BI "Option \*qSWcursor\*q \*q" boolean \*q
Selects software cursor.  The default is
.B off.
.TP
.BI "Option \*qAccel\*q \*q" boolean \*q
Enables or disables all hardware acceleration.
.br
The default is
.B on.
.TP
.BI "Option \*qZaphodHeads\*q \*q" string \*q
Specify the RandR output(s) to use with zaphod mode for a particular driver
instance.  If you use this option you must use this option for all instances
of the driver.
.br
For example:
.B
Option \*qZaphodHeads\*q \*qLVDS,VGA-0\*q
will assign xrandr outputs LVDS and VGA-0 to this instance of the driver.
.TP
.BI "Option \*qColorTiling\*q \*q" "boolean" \*q
The framebuffer can be addressed either in linear or tiled mode. Tiled mode can provide
significant performance benefits with 3D applications.  Tiling will be disabled if the drm
module is too old or if the current display configuration does not support it.  On R600+
this enables 1D tiling mode.
.br
The default value is
.B on
for R/RV3XX, R/RV4XX, R/RV5XX, RS6XX, RS740, R/RV6XX, R/RV7XX, RS780, RS880,
EVERGREEN, CAYMAN, ARUBA, Southern Islands, and Sea Islands and
.B off
for R/RV/RS1XX, R/RV/RS2XX, RS3XX, and RS690/RS780/RS880 when fast fb feature is enabled.
.TP
.BI "Option \*qColorTiling2D\*q \*q" "boolean" \*q
The framebuffer can be addressed either in linear, 1D, or 2D tiled modes. 2D tiled mode can
provide significant performance benefits over 1D tiling with 3D applications.  Tiling
will be disabled if the drm module is too old or if the current display configuration
does not support it. KMS ColorTiling2D is only supported on R600 and newer chips and requires
Mesa 9.0 or newer for R6xx-ARUBA, Mesa 9.2 or newer for Southern Islands, and Mesa
10.1 or newer for Sea Islands.
.br
The default value is
.B on
for R/RV6XX, R/RV7XX, RS780, RS880, EVERGREEN, CAYMAN, ARUBA, Southern Islands, and
Sea Islands.
.TP
.BI "Option \*qDRI\*q \*q" integer \*q
Define the maximum level of DRI to enable. Valid values are 2 for DRI2 or 3 for DRI3.
The default is
.B 3 for DRI3
if the Xorg version is >= 1.18.3 and glamor is enabled, otherwise
.B 2 for DRI2. Note:
DRI3 may not work correctly in all cases with EXA, enable at your own risk.
.TP
.BI "Option \*qEnablePageFlip\*q \*q" boolean \*q
Enable DRI2 page flipping.  The default is
.B on.
Pageflipping is supported on all radeon hardware.
.TP
.BI "Option \*qTearFree\*q \*q" boolean \*q
Set the default value of the per-output 'TearFree' property, which controls
tearing prevention using the hardware page flipping mechanism. TearFree is
on for any CRTC associated with one or more outputs with TearFree on. Two
separate scanout buffers need to be allocated for each CRTC with TearFree
on. If this option is set, the default value of the property is 'on' or 'off'
accordingly. If this option isn't set, the default value of the property is
.B auto,
which means that TearFree is on for outputs with rotation or other RandR
transforms, and for RandR 1.4 slave outputs, otherwise off.
.TP
.BI "Option \*qAccelMethod\*q \*q" "string" \*q
Chooses between available acceleration architectures.  Valid values are
.B EXA
(for pre-TAHITI GPUs) and
.B glamor
(for R300 or higher). The default is
.B glamor
with R600 or newer (with Xorg >= 1.18.3, otherwise with TAHITI or newer), otherwise
.B EXA.

.PP
The following driver
.B Options
are supported for
.B glamor
:
.TP
.BI "Option \*qShadowPrimary\*q \*q" boolean \*q
This option enables a so-called "shadow primary" buffer for fast CPU access to
pixel data, and separate scanout buffers for each display controller (CRTC).
This may improve performance for some 2D workloads, potentially at the expense
of other (e.g. 3D, video) workloads.
Note in particular that enabling this option currently disables page flipping.
The default is
.B off.

.PP
The following driver
.B Options
are supported for
.B EXA
:
.TP
.BI "Option \*qEXAVSync\*q \*q" boolean \*q
This option attempts to avoid tearing by stalling the engine until the display
controller has passed the destination region.  It reduces tearing at the cost
of performance and has been known to cause instability on some chips.
The default is
.B off.
.TP
.BI "Option \*qEXAPixmaps\*q \*q" boolean \*q
Under KMS, to avoid thrashing pixmaps in/out of VRAM on low memory cards,
we use a heuristic based on VRAM amount to determine whether to allow EXA
to use VRAM for non-essential pixmaps.  This option allows us to override the
heuristic.  The default is
.B on
with > 32MB VRAM, off with < 32MB or when fast fb feature is enabled for RS690/RS780/RS880.
.TP
.BI "Option \*qSwapbuffersWait\*q \*q" boolean \*q
This option controls the behavior of glXSwapBuffers and glXCopySubBufferMESA
calls by GL applications.  If enabled, the calls will avoid tearing by making
sure the display scanline is outside of the area to be copied before the copy
occurs.  If disabled, no scanline synchronization is performed, meaning tearing
will likely occur.  Note that when enabled, this option can adversely affect
the framerate of applications that render frames at less than refresh rate.
.IP
The default value is
.B on.

.SH TEXTURED VIDEO ATTRIBUTES
The driver supports the following X11 Xv attributes for Textured Video.
You can use the "xvattr" tool to query/set those attributes at runtime.

.TP
.BI "XV_VSYNC"
XV_VSYNC is used to control whether textured adapter synchronizes
the screen update to the monitor vertical refresh to eliminate tearing.
It has two values: 'off'(0) and 'on'(1). The default is
.B 'on'(1).

.TP
.BI "XV_CRTC"
XV_CRTC is used to control which display controller (crtc) the textured
adapter synchronizes the screen update with when XV_VSYNC is enabled.
The default, 'auto'(-1), will sync to the display controller that more
of the video is on; when this is ambiguous, the display controller associated
with the RandR primary output is preferred.  This attribute is useful for
things like clone mode where the user can best decide which display should be
synced.
The default is
.B 'auto'(-1).

.TP
.BI "XV_BICUBIC"
XV_BICUBIC is used to control whether textured adapter should apply
a bicubic filter to smooth the output. It has three values: 'off'(0), 'on'(1)
and 'auto'(2). 'off' means never apply the filter, 'on' means always apply
the filter and 'auto' means apply the filter only if the X and Y
sizes are scaled to more than double to avoid blurred output.  Bicubic
filtering is not currently compatible with other Xv attributes like hue,
contrast, and brightness, and must be disabled to use those attributes.
The default is
.B 'off'(0).

.SH SEE ALSO
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.IP " 1." 4
Wiki page:
.RS 4
https://www.x.org/wiki/radeon
.RE
.IP " 2." 4
Overview about radeon development code:
.RS 4
https://cgit.freedesktop.org/xorg/driver/xf86-video-ati/
.RE
.IP " 3." 4
Mailing list:
.RS 4
https://lists.freedesktop.org/mailman/listinfo/amd-gfx
.RE
.IP " 4." 4
IRC channel:
.RS 4
#radeon on irc.freenode.net
.RE
.IP " 5." 4
Query the bugtracker for radeon bugs:
.RS 4
https://bugs.freedesktop.org/query.cgi?product=xorg&component=Driver/Radeon
.RE
.IP " 6." 4
Submit bugs & patches:
.RS 4
https://bugs.freedesktop.org/enter_bug.cgi?product=xorg&component=Driver/Radeon
.RE

.SH AUTHORS
.nf
Authors include:
Rickard E. (Rik) Faith   \fIfaith@precisioninsight.com\fP
Kevin E. Martin          \fIkem@freedesktop.org\fP
Alan Hourihane           \fIalanh@fairlite.demon.co.uk\fP
Marc Aurele La France    \fItsi@xfree86.org\fP
Benjamin Herrenschmidt   \fIbenh@kernel.crashing.org\fP
Michel D\(:anzer            \fImichel@daenzer.net\fP
Alex Deucher             \fIalexdeucher@gmail.com\fP
Bogdan D.                \fIbogdand@users.sourceforge.net\fP
Eric Anholt              \fIeric@anholt.net\fP
