/*
 *   libmetatag - A media file tag-reader library
 *   Copyright (C) 2003, 2004  Pipian
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tag_c.h>
#ifdef MAKE_BMP
#include "include/bmp_vfs.h"
#endif
#include "../fmt.h"
#include "../config.h"
#include "include/unicode.h"
#include "include/tags.h"
#include "include/endian.h"
#include "include/wma.h"
#include "include/cdaudio.h"

void metatag_set_artist(metatag_t *meta, char *artist) {
	if (meta->artist != NULL) {
		free(meta->artist);
	}
	if (artist != NULL) {
		meta->artist = malloc(strlen(artist) + 1);
		strcpy(meta->artist, artist);
	}
	else {
		meta->artist = NULL;
	}
}

void metatag_set_title(metatag_t *meta, char *title) {
	if (meta->title != NULL) {
		free(meta->title);
	}
	if (title != NULL) {
		meta->title = malloc(strlen(title) + 1);
		strcpy(meta->title, title);
	}
	else {
		meta->title = NULL;
	}
}

void metatag_set_album(metatag_t *meta, char *album) {
	if (meta->album != NULL) {
		free(meta->album);
	}
	if (album != NULL ) {
		meta->album = malloc(strlen(album) + 1);
		strcpy(meta->album, album);
	}
	else {
		meta->album = NULL;
	}
}

void metatag_set_year(metatag_t *meta, char *year) {
	if (meta->year != NULL) {
		free(meta->year);
	}
	if (year != NULL) {
		meta->year = malloc(strlen(year) + 1);
		strcpy(meta->year, year);
	}
	else {
		meta->year = NULL;
	}
}

void metatag_set_track(metatag_t *meta, char *track) {
	if (meta->track != NULL) {
		free(meta->track);
	}
	if (track != NULL) {
		meta->track = malloc(strlen(track) + 1);
		strcpy(meta->track, track);
	}
	else {
		meta->track = NULL;
	}
}

void metatag_set_genre(metatag_t *meta, char *genre) {
	if (meta->genre != NULL) {
		free(meta->genre);
	}
	if (genre != NULL) {
		meta->genre = malloc(strlen(genre) + 1);
		strcpy(meta->genre, genre);
	}
	else {
		meta->genre = NULL;
	}
}

void get_tag_data(metatag_t *meta, char *filename, int track)
{
	
	TagLib_File *file;
	TagLib_Tag *tag;
	const TagLib_AudioProperties *properties;

	if(track > 0)
	{
		fetchCDAudio(meta, filename, track);
		return;
	}
	else
	{
		/** 
		 * First off, try libtag to see if we can get the tag nicely... if not,
		 * fall back to our own parser for wma 
		 **/
		
		file = taglib_file_new(filename);

		if (file != NULL) {
			tag = taglib_file_tag(file);
			properties = taglib_file_audioproperties(file);

			metatag_set_artist(meta, taglib_tag_artist(tag));
			metatag_set_title(meta, taglib_tag_title(tag));
			metatag_set_album(meta, taglib_tag_album(tag));

			taglib_tag_free_strings();
			taglib_file_free(file);
		}
		else {
			if (fetchWMA(filename, meta)) {
				return;
			}
		}
	}
	
	return;
}

void metatag_free(metatag_t *meta)
{
	if(meta->artist) {
		free(meta->artist);
	}
	if (meta->title) {
		free(meta->title);
	}
	if (meta->album) {
		free(meta->album);
	}
	if (meta->year) {
		free(meta->year);
	}
	if (meta->track) {
		free(meta->track);
	}
	if (meta->genre) {
		free(meta->genre);
	}
	free(meta);
}

metatag_t *metatag_new(void)
{
	metatag_t *ret;
	
	if(!(ret = calloc(sizeof(*ret), 1)))
		return NULL;
	
	return ret;
}
