/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxcjpgrn.h,v 1.1.26.1 2004/07/09 01:51:14 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXCJPGRN_H
#define PXCJPGRN_H

// Forward declarations
typedef _INTERFACE IHXBuffer             IHXBuffer;
typedef _INTERFACE IHXValues             IHXValues;
typedef _INTERFACE IHXCommonClassFactory IHXCommonClassFactory;
class PXMapManager;
class CIJGLibraryWrapper;


class CRealPixJPEGRendererCodec : public CHXBaseCountingObject,
                                  public IHXPlugin,
                                  public IHXRealPixRendererCodec
{
public:
    CRealPixJPEGRendererCodec();
    virtual ~CRealPixJPEGRendererCodec();

    // IUnknown Methods
    STDMETHOD (QueryInterface)  (THIS_ REFIID ID, void** ppObj);
    STDMETHOD_(UINT32, AddRef)  (THIS);
    STDMETHOD_(UINT32, Release) (THIS);

    // IHXPlugin methods
    STDMETHOD(GetPluginInfo) (THIS_ REF(BOOL)        bMultipleLoad,
                                    REF(const char*) pDescription,
                                    REF(const char*) pCopyright,
                                    REF(const char*) pMoreInfoURL,
                                    REF(ULONG32)     ulVersionNumber);
    STDMETHOD(InitPlugin)    (THIS_ IUnknown*        pContext);

    // IRMARealPixRendererCodec
    STDMETHOD(GetRendererCodecInfo) (THIS_ REF(const char**) rppszFileMimeType,
                                           REF(UINT32)       rulHighestSupportedContentVersion,
                                           REF(UINT32)       rulHighestSupportedStreamVersion);
    STDMETHOD(ValidInputData)       (THIS_ IHXBuffer* pBuffer, REF(BOOL)   rbValid);
    STDMETHOD(GetHeaderInfo)        (THIS_ IHXBuffer*      pBuffer,
                                           IHXBuffer*      pOpaqueImageData,
                                           REF(HXxSize)     rImageDim,
                                           REF(UINT32)      rulNumFrames,
                                           REF(IHXValues*) rpImageInfo,
                                           REF(UINT32)      rulSessionHandle);
    STDMETHOD(GetFrameInfo)         (THIS_ UINT32           ulSessionHandle,
                                           UINT32           ulFrameNum,
                                           REF(HXxRect)     rFrameDim,
                                           REF(IHXValues*) rpMoreInfo);
    STDMETHOD(SetDecompressParam)   (THIS_ UINT32      ulSessionHandle,
                                           UINT32      ulFrameNum,
                                           IHXBuffer* pOutputBuffer,
                                           HXxSize     cFrameDim,
                                           UINT32      ulRowStride,
                                           UINT32      ulBitsPerPixel,
                                           UINT32      ulColorFormat,
                                           BOOL        bRowsInverted,
                                           IHXValues* pMoreParam);
    STDMETHOD(Decompress)           (THIS_ UINT32      ulSessionHandle,
                                           IHXBuffer* pBuffer,
                                           IHXBuffer* pOpaquePacketData);
    STDMETHOD(GetDecompressStatus)  (THIS_ UINT32     ulSessionHandle,
                                           REF(INT32) rlStatus);
    STDMETHOD(FinishDecompress)     (THIS_ UINT32 ulSessionHandle);

    // CRealPixJPEGRendererCodec methods
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
protected:
    enum {kMarkerSOF0 = 0xC0, kMarkerSOF1 = 0xC1, kMarkerSOF2 = 0xC2, kMarkerDHT  = 0xC4,
          kMarkerRST0 = 0xD0, kMarkerRST1 = 0xD1, kMarkerRST2 = 0xD2, kMarkerRST3 = 0xD3,
          kMarkerRST4 = 0xD4, kMarkerRST5 = 0xD5, kMarkerRST6 = 0xD6, kMarkerRST7 = 0xD7,
          kMarkerSOI  = 0xD8, kMarkerEOI  = 0xD9, kMarkerSOS  = 0xDA, kMarkerDQT  = 0xDB,
          kMarkerDRI  = 0xDD, kMarkerAPP0 = 0xE0, kMarkerTEM  = 0x01};

    INT32                   m_lRefCount;
    IUnknown*               m_pContext;
    IHXCommonClassFactory* m_pCommonClassFactory;
    PXMapManager*           m_pMapManager;

    static const char*  m_pszDescription;
    static const char*  m_pszCopyright;
    static const char*  m_pszMoreInfoURL;
    static const char*  m_ppszFileExtensions[];
    static const char*  m_ppszFileMimeType[];
    static const char*  m_pszCodecASMRules;
    static const UINT32 m_ulHighestSupportedContentVersion;
    static const UINT32 m_ulHighestSupportedStreamVersion;

    HX_RESULT           InsertDummyData(CIJGLibraryWrapper* pWrap,
                                        IHXBuffer*         pCurrData,
                                        IHXBuffer*         pCurrOpaque);
    HX_RESULT           ComputeStatistics(BYTE *pBuf,            UINT32 ulLen,
                                          UINT32 &rulNumPackets, UINT32 &rulMinSize,
                                          UINT32 &rulMaxSize,    UINT32 &rulAvgSize);
    void                ReleaseAllWrappers();
};

#endif
