/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smlfctry.cpp,v 1.6.2.1 2004/07/09 01:58:10 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "hxplugn.h"
#include "hxver.h"
#include "ihxpckts.h"
#include "hxrendr.h"
#include "hxcore.h"
#include "hxhyper.h"
#include "hxasm.h"
#include "hxerror.h"
#include "hxvsurf.h"
#include "hxformt.h"
#include "smiltype.h"
#include "hxsm2sm.h"
#include "baseobj.h"
#include "hxstring.h"
#include "baserend.h"
#include "vbasernd.h"
#if defined(HELIX_FEATURE_SMIL2_BRUSH)
#include "brushff.h"
#include "brushrnd.h"
#endif /* #if defined(HELIX_FEATURE_SMIL2_BRUSH) */
// CSmil1DocumentRenderer needs this fof proxying CSmilDocumentRenderer:
#include "hxgroup.h"
#if defined(HELIX_FEATURE_SMIL2)
#include "smlrendr.h"
#endif /* #if defined(HELIX_FEATURE_SMIL2) */
#if defined(HELIX_FEATURE_SMIL1)
#include "sm1rendr.h"
#endif /* #if defined(HELIX_FEATURE_SMIL1) */
#include "smlfctry.h"

#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

HX_RESULT (STDAPICALLTYPE* const CSmilPluginFactory::m_fpCreateInstanceArray[])(IUnknown**) =
{
#if defined(HELIX_FEATURE_SMIL2)
    CSmilRenderer::HXCreateInstance,
#endif /* #if defined(HELIX_FEATURE_SMIL2) */
#if defined(HELIX_FEATURE_SMIL1)
    CSmil1Renderer::HXCreateInstance,
#endif /* #if defined(HELIX_FEATURE_SMIL1) */
#if defined(HELIX_FEATURE_SMIL2_BRUSH)
    CBrushFileFormat::HXCreateInstance,
    CBrushRenderer::HXCreateInstance,
#endif /* #if defined(HELIX_FEATURE_SMIL2_BRUSH) */
    NULL
};

HX_RESULT (STDAPICALLTYPE* const CSmilPluginFactory::m_fpUnloadArray[])(void) =
{
#if defined(HELIX_FEATURE_SMIL2)
    CSmilRenderer::CanUnload2,
#endif /* #if defined(HELIX_FEATURE_SMIL2) */
#if defined(HELIX_FEATURE_SMIL1)
    CSmil1Renderer::CanUnload2,
#endif /* #if defined(HELIX_FEATURE_SMIL1) */
#if defined(HELIX_FEATURE_SMIL2_BRUSH)
    CBrushFileFormat::CanUnload2,
    CBrushRenderer::CanUnload2,
#endif /* #if defined(HELIX_FEATURE_SMIL2_BRUSH) */
    NULL
};

STDAPI ENTRYPOINT(HXCREATEINSTANCE)(IUnknown** ppIUnknown)
{
    HX_RESULT retVal = HXR_FAIL;

    if (ppIUnknown)
    {
        CSmilPluginFactory* pFactory = new CSmilPluginFactory();
        if (pFactory)
        {
            retVal = pFactory->QueryInterface(IID_IUnknown, (void**) ppIUnknown);
        }
    }

    return retVal;
}

STDAPI ENTRYPOINT(CanUnload2)(void)
{
    for(int i=0; CSmilPluginFactory::m_fpUnloadArray[i]; i++)
    {
        if( HXR_OK != (CSmilPluginFactory::m_fpUnloadArray[i])() )
        {
            return HXR_FAIL;
        }
    }
    return HXR_OK;
}

CSmilPluginFactory::CSmilPluginFactory()
{
    m_lRefCount = 0;
    for (m_usNumPlugins = 0; m_fpCreateInstanceArray[m_usNumPlugins]; m_usNumPlugins++);
}

CSmilPluginFactory::~CSmilPluginFactory()
{
}

STDMETHODIMP CSmilPluginFactory::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (ppvObj)
    {
        // Set default
        *ppvObj = NULL;
        // Check for IID type
        if (IsEqualIID(riid, IID_IUnknown))
        {
            AddRef();
            *ppvObj = (IUnknown*) (IHXPluginFactory*) this;
        }
        else if (IsEqualIID(riid, IID_IHXPluginFactory))
        {
            AddRef();
            *ppvObj = (IHXPluginFactory*) this;
        }
        else
        {
            retVal = HXR_NOINTERFACE;
        }
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

STDMETHODIMP_(UINT32) CSmilPluginFactory::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}


STDMETHODIMP_(UINT32) CSmilPluginFactory::Release()
{
    if (InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;

    return 0;
}

STDMETHODIMP_(UINT16) CSmilPluginFactory::GetNumPlugins()
{
    return m_usNumPlugins;
}

STDMETHODIMP CSmilPluginFactory::GetPlugin(UINT16 usIndex, IUnknown** ppPlugin)
{
    HX_RESULT retVal = HXR_FAIL;

    if (usIndex < m_usNumPlugins && ppPlugin)
    {
        retVal = m_fpCreateInstanceArray[usIndex](ppPlugin);
    }

    return retVal;
}

