/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: consoleui.h,v 1.1.2.1 2004/07/09 02:03:14 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
/************************************************************************
 * consoleui.cpp -- UI without the gooey
 *
 */
#ifndef _CONSOLEUI_H_
#define _CONSOLEUI_H_

//#define xprintf(x) printf x
#define xprintf(x) /* x */

#if defined _UNIX && !defined _CONSOLE
#define _CONSOLE
#endif

#if defined(_FREEBSD) || defined(_OPENBSD) || defined(_NETBSD) || defined(_MAC_UNIX)
#define TCGETS TIOCGETA
#define TCSETS TIOCSETA
#endif /* _FREEBSD || _OPENBSD || _NETBSD */

class ConsoleUI
{
public:
    ConsoleUI();
    virtual ~ConsoleUI();

#ifdef _CONSOLE
public:
    virtual char* PromptForItem(const char* szPrompt,
                                const char* szDefault,
                                char**      pszResponse,
                                const char* szMessage);

    virtual int ShowMessage(const char* szFormat, ...);
    virtual int ShowErrorMessage(const char* szFormat, ...);
    virtual int FlushOutput(void) { return fflush(0); }
    virtual void WaitForEnter(const char* szPrompt);
    virtual void ClearScreen(void);
    virtual const char* GetPagerCmd(void);
    virtual void DisplayTextFile (const char* szFile);
    virtual void DisplayText(const char* szText);
    virtual void PromptForUsernamePassword(char**      pszUsername,
                                           char**      pszPassword,
                                           const char* szMessage);
    virtual void PrintUsage(const char* szProgName, const char* szOpt);

    virtual void SetEchoOff(void);
    virtual void SetEchoOn(void);

    virtual void StartPrintingDots(void);
    virtual void StopPrintingDots(void);

private:

    int m_nDotPid;
    struct termios m_oldtty;

#else
    // define stubs for now -- FIXME
public:
    virtual char* PromptForItem(const char* szPrompt,
                                const char* szDefault,
                                char**      pszResponse,
                                const char* szMessage) { return 0; }

    virtual int ShowMessage(const char* szFormat, ...) { return 0; }
    virtual int ShowErrorMessage(const char* szFormat, ...) { return 0; }
    virtual int FlushOutput(void) { return 0; }
    virtual void WaitForEnter(const char* szPrompt){ return; }
    virtual void ClearScreen(void){ return; }
    virtual const char* GetPagerCmd(void){ return 0; }
    virtual void DisplayTextFile (const char* szFile){ return; }
    virtual void DisplayText(const char* szText){ return; }
    virtual void PromptForUsernamePassword(char**      pszUsername,
                                           char**      pszPassword,
                                           const char* szMessage){ return; }
    virtual void PrintUsage(const char* szProgName, const char* szOpt)
    { return; }

    virtual void SetEchoOff(void){ return; }
    virtual void SetEchoOn(void) { return; }

    virtual void StartPrintingDots(void) { return; }
    virtual void StopPrintingDots(void) { return; }


#endif //_CONSOLE
};

#endif //_CONSOLEUI_H_
