/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: winstage1.h,v 1.1.2.1 2004/07/09 02:03:10 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */


#ifndef _WINSTAGE1_H_
#define _WINSTAGE1_H_

/***********************************************************************
 * defines
 */

#ifndef SECOND_STAGE_NAME
#define SECOND_STAGE_NAME "setup.exe"
#endif
#ifndef SECOND_STAGE_PROG
#define SECOND_STAGE_PROG "Bin" PATH_SEP SECOND_STAGE_NAME
#endif

#define ARCHDIR     "~hxsetup"

#define MAX_PASS 128
#define MAX_PASS_ATTEMPTS 3

#define DECOMPRESS_BLOCK_SIZE 4096
#define DECOMPRESS_BUFFER_SIZE 16384

// Dialog strings
#define PROGRESS_TITLE \
    "Extracting files for Helix installation"

#define ERROR_TITLE "Setup Error"

#define INFO_TITLE "Setup Information"

#define PASS_TITLE "Installation Password"

#define ERR_OUTOFMEMORY \
    "There is not enough memory available to complete the installation."

#define ERR_DOWNLOAD_ERROR \
    "Possible download error. Please download this file again."

#define ERR_RES_LOAD \
    "The setup file is corrupted.\n" \
    ERR_DOWNLOAD_ERROR

#define ERR_TEMP_DIR \
    "Could not create directory for temporary files.\n" \
    "Please make sure the disk is not full or write-protected."

#define ERR_WRITE \
    "Error writing temporary files. Please make sure\n" \
    "the disk is not full or write-protected."

#define ERR_DEARCH \
    "Setup decompression failed.\n" \
    ERR_DOWNLOAD_ERROR

#define ERR_BAD_ARCHIVE_TYPE \
    "Internal error -- unknown archive type.\n" \
    ERR_DOWNLOAD_ERROR

#define ERR_GENERAL \
    "The setup could not be completed."

#define ERR_BAD_PASS \
    "The password you entered is incorrect."

#define ERR_MAX_PASS \
    "The maximum number of password attempts has been exceeded. \n"


class WinStage1 : public Stage1
{
public:
    WinStage1();
    virtual ~WinStage1();

protected:
    static UINT32 GetResource(const char* szName, BYTE*& pBuffer);
        
    virtual void ReportError(const char* szError) = 0;
    virtual BOOL MakeArchDir(void);

    virtual HX_RESULT Dearchive(BYTE* pArchive);
    virtual HX_RESULT DearchiveBZ2(BYTE* pArchive);

    virtual HX_RESULT UpdateProgress(UINT32 ulBytesDone) = 0;

    virtual HX_RESULT RunSecondStage(void);
    virtual HX_RESULT RunSecondStageCmd(char* szCmd) = 0;

    virtual inline void Cleanup() { RemoveDirRecursive(m_szArchiveDir); }
};

#endif // _WINSTAGE1_H_
