/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: CHXClientEngineContext.cpp,v 1.7.2.3 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "CHXClientEngineContext.h"
#include "CHXClientBuffer.h"

#include "enter_hx_headers.h"
#include "ihxpckts.h"
#include "hlxclib/string.h"

#include "hxsmartptr.h"
HX_SMART_POINTER_INLINE( SPIHXBuffer, IHXBuffer );
#include "exit_hx_headers.h"

CHXClientEngineContext::~CHXClientEngineContext( void )
{
}

CHXClientEngineContext::CHXClientEngineContext( const HXClientEngineCallbacks* pClientEngineCallbacks )
	: m_pClientEngineCallbacks( pClientEngineCallbacks )
{
}

BEGIN_INTERFACE_LIST_NOCREATE( CHXClientEngineContext )
	INTERFACE_LIST_ENTRY_DELEGATE_BLIND( ClientEngineContextQI )
    INTERFACE_LIST_ENTRY_SIMPLE( IHXSystemRequired )
END_INTERFACE_LIST

HX_RESULT
CHXClientEngineContext::ClientEngineContextQI( REFIID riid, void** ppvObj )
{
	if ( IsEqualIID( IID_IHXPreferences, riid ) )
	{
		if ( m_pClientEngineCallbacks &&
			 m_pClientEngineCallbacks->ReadPreference && m_pClientEngineCallbacks->WritePreference )
		{
			AddRef();
			IHXPreferences* pIThisAsIHXPreferences = this;
			*ppvObj = pIThisAsIHXPreferences;
			return HXR_OK;
		}
		return HXR_FAIL;
	}
	if ( IsEqualIID( IID_IHXPreferences3, riid ) )
	{
		// DeletePreference callback is not required for us to override the engine's preferences.
		if ( m_pClientEngineCallbacks &&
			 m_pClientEngineCallbacks->ReadPreference && m_pClientEngineCallbacks->WritePreference )
		{
			AddRef();
			IHXPreferences3* pIThisAsIHXPreferences3 = this;
			*ppvObj = pIThisAsIHXPreferences3;
			return HXR_OK;
		}
		return HXR_FAIL;
	}
	return HXR_FAIL;
}

STDMETHODIMP
CHXClientEngineContext::ReadPref( const char* pPrefKey, REF(IHXBuffer*) pBuffer )
{
	if ( !pPrefKey ) return HXR_INVALID_PARAMETER;
	if ( !m_pClientEngineCallbacks || !m_pClientEngineCallbacks->ReadPreference ) return HXR_UNEXPECTED;
	
	UInt32 bufferLength = 0;
	( void ) m_pClientEngineCallbacks->ReadPreference( pPrefKey, NULL, bufferLength, &bufferLength );
	if ( bufferLength > 0 )
	{
		SPIHXBuffer spIBuffer = new CHXClientBuffer;
		if ( !spIBuffer.IsValid() ) return HXR_OUTOFMEMORY;
		
		HX_RESULT result = spIBuffer->SetSize( bufferLength );
		if ( FAILED( result ) ) return result;
		
		if ( m_pClientEngineCallbacks->ReadPreference( pPrefKey, spIBuffer->GetBuffer(), bufferLength, &bufferLength ) )
		{
			pBuffer = spIBuffer.Ptr();
			pBuffer->AddRef();
			return HXR_OK;
		}
	}
	return HXR_FAIL;
}

STDMETHODIMP
CHXClientEngineContext::WritePref( const char* pPrefKey, IHXBuffer* pBuffer )
{
	if ( !pPrefKey ) return HXR_INVALID_PARAMETER;
	if ( !pBuffer ) return HXR_INVALID_PARAMETER;
	if ( !m_pClientEngineCallbacks || !m_pClientEngineCallbacks->WritePreference ) return HXR_UNEXPECTED;
	
	return m_pClientEngineCallbacks->WritePreference( pPrefKey, pBuffer->GetBuffer(), pBuffer->GetSize() ) ? HXR_OK : HXR_FAIL;
}

STDMETHODIMP
CHXClientEngineContext::DeletePref( const char* pPrefKey )
{
	if ( !pPrefKey ) return HXR_INVALID_PARAMETER;
	if ( !m_pClientEngineCallbacks ) return HXR_UNEXPECTED;

	return m_pClientEngineCallbacks->DeletePreference ?
		   ( m_pClientEngineCallbacks->DeletePreference( pPrefKey ) ? HXR_OK : HXR_FAIL ) : HXR_FAIL;
}

STDMETHODIMP
CHXClientEngineContext::Open( const char* pCompanyName, const char* pProductName, 
							  ULONG32 nProdMajorVer, ULONG32 nProdMinorVer )
{
	// See no reason at this time to forward this to a callback. Read/Write/Delete implies a corresponding Open.
	return HXR_OK;
}

STDMETHODIMP
CHXClientEngineContext::OpenShared( const char* pCompanyName )
{
	// See no reason at this time to forward this to a callback. Read/Write/Delete implies a corresponding Open.
	return HXR_OK;
}

STDMETHODIMP
CHXClientEngineContext::HasFeatures( IHXUpgradeCollection* pFeatures )
{
	if ( !pFeatures ) return HXR_INVALID_PARAMETER;
	if ( !m_pClientEngineCallbacks || !m_pClientEngineCallbacks->HasFeature ) return HXR_FAIL;

	UINT32 numOfFeatures = pFeatures->GetCount();
	if ( numOfFeatures <= 0 ) return HXR_INVALID_PARAMETER;
	
	HXUpgradeType upgradeType;
	UINT32 majorVersion, minorVersion;
	UINT32 index = numOfFeatures;
	do
	{
		--index;
		
		SPIHXBuffer spFeature = new CHXClientBuffer;
		pFeatures->GetAt( index, upgradeType, spFeature.Ptr(), majorVersion, minorVersion );
		char* pFeature = ( char* ) spFeature->GetBuffer();
		if ( !pFeature || !*pFeature )
		{
			pFeatures->Remove( index );
		}
		else
		{
			// Pass each feature to callback discounting leading URI.
			static const char* const kFeaturePrefixURI = "http://features.real.com/?";
			UInt32 const kFeaturePrefixLength = strlen( kFeaturePrefixURI );
			static char const kFeatureDelimiterChar = '&';
			
			if ( 0 == strncmp( pFeature, kFeaturePrefixURI, kFeaturePrefixLength ) )
			{
				pFeature += kFeaturePrefixLength;
			}
			bool shouldRemoveAllButLastFeature = true;
			char* pDelimiter = strchr( pFeature, kFeatureDelimiterChar );
			while ( pDelimiter )
			{
				*pDelimiter = 0;
				if ( !m_pClientEngineCallbacks->HasFeature( pFeature ) )
				{
					shouldRemoveAllButLastFeature = false;
					break;
				}
				pFeature = pDelimiter + 1;
				pDelimiter = strchr( pFeature, kFeatureDelimiterChar );
			}
			if ( shouldRemoveAllButLastFeature && m_pClientEngineCallbacks->HasFeature( pFeature ) )
			{
				pFeatures->Remove( index );
			}
		}
	}
	while( index > 0 );
	
	numOfFeatures = pFeatures->GetCount();
	return ( numOfFeatures > 0 ) ? HXR_FAIL : HXR_OK;
}
