/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: macyuvblt.h,v 1.1.1.1.42.1 2004/07/09 01:59:02 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _MACYUVBLT_H_
#define _MACYUVBLT_H_

#include "macblt.h"

#include <ImageCompression.h>

class CMacYUVBlt : public CMacBlt
{
public:
    CMacYUVBlt();
    virtual ~CMacYUVBlt();

    virtual HX_RESULT 
        CreateSurface(int cidIn, int& cidOut,
                      int nWidth, int nHeight,
                      int nFlags, HWND hWnd,
                      int nCountIn, int& nCountOut);

    virtual HX_RESULT 
        LockSurface(UCHAR** ppDestPtr,
                    LONG32* pnDestPitch,
                    int& cid,
                    REF(HXxSize) srcSize,
                    int nIndex=0);

    virtual HX_RESULT
        FillSurface(int cidIn,
                    UCHAR* pSrcBuffer,
                    HXxSize* pSrcSize,
                    HXxRect* prSrcRect,
                    UCHAR* pDstBuffer,
                    LONG32 nDstPitch,
                    HXxRect* prDestRect);
    
    virtual HX_RESULT
        UnlockSurface(UCHAR* pSurfPtr, int nIndex=0);

    virtual HX_RESULT
        RenderSurface(HXxSize* pSrcSize,
                      HXxRect* prSrcRect,
                      HXxRect* prDestRect,
                      int nIndex=0);
    
    virtual HX_RESULT
        DestroySurface(int cid); 


protected:
    WindowPtr m_Window;
    ImageDescriptionHandle	m_ImageDescriptionHandle;
    ImageSequence		m_SequenceID;
    long			m_nOverlaySourceWidth;
    long			m_nOverlaySourceHeight;
    long			m_nOverlayRowBytes;
    long			m_nOverlayBufferSize;
    void*			m_pOverlayBuf;
    HXxRect			m_OverlayScreenRect;

    void	_CreateYUVBuffer();
    void	_CreateOverlay(long screenCoorX, long screenCoorY, long screenWidth, long screenHeight);
    void	_CleanUpOverlay();

};

#endif //_MACYUVBLT_H_
