/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: gifimage.h,v 1.1.26.1 2004/07/09 01:54:26 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CGIFIMAGE_H
#define _CGIFIMAGE_H

#include "hxtypes.h"
#include "hxresult.h"
#include "lzw.h"

class CGIFImage
{
public:
    struct GraphicControlExtension
    {
        UINT32 m_ulDisposalMethod;
        BOOL   m_bUserInputExpected;
        BOOL   m_bTransparentIndexGiven;
        UINT32 m_ulDelayTime;
        UINT32 m_ulTransparentColorIndex;
    };

    struct ImageDescriptor
    {
        UINT32 m_ulImageLeft;
        UINT32 m_ulImageTop;
        UINT32 m_ulImageWidth;
        UINT32 m_ulImageHeight;
        BOOL   m_bLocalColorTablePresent;
        BOOL   m_bInterlaced;
        BOOL   m_bLocalColorsSorted;
        UINT32 m_ulLocalColorTableBits;
        UINT32 m_ulLocalColorTableNumEntries;
    };
protected:
    enum
    {
        kRedIndex                          = 0,
        kGreenIndex                        = 1,
        kBlueIndex                         = 2,
        kStateConstructed                  = 0,
        kStateDecoInitialized              = 1,
        kStateDecoInProgress               = 2,
        kStateDecoFinished                 = 3,
        kDisposalMethodNoneSpecified       = 0,
        kDisposalMethodDoNotDispose        = 1,
        kDisposalMethodRestoreToBackground = 2,
        kDisposalMethodRestoreToPrevious   = 3
    };

    ImageDescriptor         m_cID;
    GraphicControlExtension m_cGCE;
    BOOL                    m_bGCEPresent;
    BYTE                   *m_pucLocalColorMap;
    BOOL                    m_bGlobalColorMapPresent;
    UINT32                  m_ulNumGlobalColors;
    BYTE                   *m_pucGlobalColorMap;
    BYTE                   *m_pOutputBuffer;
    UINT32                  m_ulOutputBufferSize;
    UINT32                  m_ulCurX;
    UINT32                  m_ulCurY;
    UINT32                  m_ulPass;
    BYTE                   *m_pOutPtr;
    UINT32                  m_ulState;
    LZWCodec               *m_pLZWCodec;
    BOOL                    m_bValid;

    void Reset();
    void BumpPixel();
public:
    CGIFImage();

    ~CGIFImage();

    void        SetGlobalColorMap(UINT32 ulNumColors, BYTE *pMap);
    HX_RESULT   SetCompressedBufferSize(UINT32 ulSize);
    HX_RESULT   InitDecompress(BYTE *pBuffer, UINT32 ulLen);
    HX_RESULT   Decompress(BYTE *pBuffer, UINT32 ulLen);
    HX_RESULT   GetIndexImage(BYTE *pLogicalScreen, UINT32 ulWidth, UINT32 ulHeight,
                              UINT32 ulPadWidth, BOOL bRowsInverted);
    HX_RESULT   GetRGBImage(BYTE *pLogicalScreen, UINT32 ulWidth, UINT32 ulHeight, UINT32 ulPadWidth,
                            UINT32 ulBytesPerPixel, BOOL bRowsInverted, BOOL bRGBOrdering,
                            BYTE ucBackRed, BYTE ucBackGreen, BYTE ucBackBlue,
                            BYTE ulAlpha = 0);
    HX_RESULT   GetRGBImageEx(BYTE *pLogicalScreen, UINT32 ulWidth, UINT32 ulHeight, UINT32 ulPadWidth,
                              UINT32 ulBytesPerPixel, BOOL bRowsInverted, BOOL bRGBOrdering,
                              UINT32 ulBgColor, BOOL bMediaOpacity, UINT32 ulMediaOpacity,
                              BOOL bChromaKey, UINT32 ulChromaKey, UINT32 ulChromaKeyTol, UINT32 ulChromaKeyOpacity);
    HX_RESULT   GetRGB32(BYTE *pBuffer, UINT32 ulRowStride, BOOL bRowsInverted);
    void        TermDecompress();

    BYTE       *GetOutputBuffer()                      { return m_pOutputBuffer; }
    BOOL        Finished()                             { return (m_ulState == kStateDecoFinished ? TRUE : FALSE); }
    void        SetFinished()                          { m_ulState = kStateDecoFinished; }
    BOOL        LocalColorMapPresent()                 { return m_cID.m_bLocalColorTablePresent; }
    UINT32      GetImageWidth()                        { return m_cID.m_ulImageWidth;  }
    UINT32      GetImageHeight()                       { return m_cID.m_ulImageHeight; }
    UINT32      GetImageLeft()                         { return m_cID.m_ulImageLeft; }
    UINT32      GetImageTop()                          { return m_cID.m_ulImageTop;  }
    UINT32      GetLocalColorTableNumEntries()         { return m_cID.m_ulLocalColorTableNumEntries; }
    BYTE	*GetLocalColorTable()		       { return m_pucLocalColorMap; }
    BOOL        GCEPresent()                           { return m_bGCEPresent; }
    UINT32      GetDelayTime();
    UINT32      GetDisposalMethod()                    { return m_cGCE.m_ulDisposalMethod; }
    BOOL        Transparent()                          { return m_cGCE.m_bTransparentIndexGiven; }
    UINT32      GetTransparentIndex()                  { return m_cGCE.m_ulTransparentColorIndex; }
    BOOL        GetValid()                             { return m_bValid; }
    void        SetValid(BOOL bValid)                  { m_bValid = bValid; }

    static void ParseImageDescriptor(BYTE *pBuffer, ImageDescriptor &cID);
    static void ParseGraphicControlExtension(BYTE *pBuffer, GraphicControlExtension &cGCE);
};

inline UINT32 CGIFImage::GetDelayTime()
{
    UINT32 ulRet = m_cGCE.m_ulDelayTime;

    if (!ulRet)
    {
        ulRet = 1;
    }

    return ulRet;
}

#endif
