/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rpfileio.h,v 1.2.24.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _IMF_FILEIO_H
#define _IMF_FILEIO_H

// {5929D7B0-BE6C-11d1-A5A8-0000C0D3964C}
DEFINE_GUID(IID_IIMFFileIO, 0x5929d7b0, 
            0xbe6c, 0x11d1, 0xa5, 0xa8, 0x0, 0x0, 0xc0, 0xd3, 0x96, 0x4c);

#define CLSID_IIMFFileIO IID_IIMFFileIO

#undef  INTERFACE
#define INTERFACE       IIMFFileIO

typedef struct _IMFHEADERtag
{
    char m_cTitle[256]; /* Flawfinder: ignore */
    char m_cAuthor[256]; /* Flawfinder: ignore */
    char m_cCopyWrt[256]; /* Flawfinder: ignore */ /* 2 wrngs don't make a "Wrt" */
    UINT32 m_ulStartTime;
    UINT32 m_ulDuration;
    UINT32 m_ulPreroll;
    UINT32 m_ulBitrate;
    UINT32 m_ulDisplayWidth;
    UINT32 m_ulDisplayHeight;
    UINT32 m_ulMaxFPS;
    int   m_bAspectFlag;
    void  Clear()
    { 
        strcpy(m_cTitle,""); /* Flawfinder: ignore */
        strcpy(m_cAuthor,""); /* Flawfinder: ignore */
        strcpy(m_cCopyWrt,""); /* Flawfinder: ignore */
        m_ulStartTime=0;
        m_ulDuration=0;
        m_ulPreroll=0;
        m_ulBitrate=0;
        m_ulDisplayWidth=0;
        m_ulDisplayHeight=0;
        m_ulMaxFPS=0;
        m_bAspectFlag=0;
    };
}IMFHEADER;

typedef struct _IMFEFFECTtag
{
    // Common to All Types
    UINT32      m_ulType;
    UINT32      m_ulBinSize;
    UINT32      m_ulMaxFps;
    UINT32      m_ulStart;

	// Type Specific
    UINT32     m_ulTarget;
    char       m_cURL[256]; /* Flawfinder: ignore */
    UINT32     m_ulDirection;
    UINT32     m_ulDuration;
    unsigned char m_ucRed;
    unsigned char m_ucGreen;
    unsigned char m_ucBlue;
    BOOL       m_bAspect;
    BOOL       m_bDefaultAspect;    
    char       m_cPackage[256]; /* Flawfinder: ignore */
    char       m_cName[256];
    char       m_cData[256]; /* Flawfinder: ignore */
    char       m_cFile[256]; /* Flawfinder: ignore */

    int m_nDest_x;
    int m_nDest_y;
    int m_nDest_W;
    int m_nDest_H;
    
    int m_nSrc_x;
    int m_nSrc_y;
    int m_nSrc_W;
    int m_nSrc_H;
    void  Clear()
    { 
        strcpy(m_cPackage,""); /* Flawfinder: ignore */
        strcpy(m_cName,""); /* Flawfinder: ignore */
        strcpy(m_cFile,""); /* Flawfinder: ignore */
        strcpy(m_cData,""); /* Flawfinder: ignore */
        strcpy(m_cURL,""); /* Flawfinder: ignore */
        m_ulType    = 0xFF;
        m_ulBinSize = 0;
        m_ulMaxFps  = 0;
        m_ulStart   = 0;
        m_ulDuration = 0;        
        m_ulTarget    = 0;
        m_ulDirection = 0;
        m_bAspect = 0;
        m_bDefaultAspect = 0;    
        m_nDest_x =0;
        m_nDest_y =0;
        m_nDest_W =0;
        m_nDest_H =0;
        m_nSrc_x =0;
        m_nSrc_y =0;
        m_nSrc_W =0;
        m_nSrc_H =0;

    };    

}IMFEFFECT;

typedef struct _IMFIMAGEtag
{
    char m_ImageName[256]; /* Flawfinder: ignore */
    int  m_nHandle;
}IMFIMAGE;
////////////////////////////////////////////////////////////
// IMFFileIO
// Interface for reading/writing IMF Files
////////////////////////////////////////////////////////////
DECLARE_INTERFACE_(IIMFFileIO, IUnknown)
{
   // IUnknown Methods 
   STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void **ppvObj) PURE;
   STDMETHOD_(UINT32,AddRef) () PURE;
   STDMETHOD_(UINT32,Release) () PURE;

   // IMFFileIO Methods 
   STDMETHOD(AddHeader) (void * pBuffer,UINT32 ulBufferSize) PURE;
   STDMETHOD(GetHeader) (void * pBuffer,UINT32 ulBufferSize) PURE;

   STDMETHOD_(UINT32,AddImageTag) (void * pBuffer,UINT32 ulBufferSize) PURE;
   STDMETHOD_(UINT32,GetImageTag) (UINT32 nIdx,void * pBuffer,UINT32 ulBufferSize) PURE;
   STDMETHOD_(UINT32,GetImageTagCount) () PURE;
   STDMETHOD_(UINT32,RemoveImageTag) (UINT32 nIdx) PURE;

   STDMETHOD_(UINT32,AddEffectTag) (void * pBuffer,UINT32 ulBufferSize) PURE;
   STDMETHOD_(UINT32,GetEffectTag) (UINT32 nIdx,void * pBuffer,UINT32 ulBufferSize) PURE;
   STDMETHOD_(UINT32,GetEffectTagCount) () PURE;   
   STDMETHOD_(UINT32,RemoveEffectTag) (UINT32 nIdx) PURE;

   STDMETHOD(InitFromBuffer) (void * pBuffer,UINT32 ulBufferSize) PURE;
   STDMETHOD(GetIMFScript) (void * pBuffer,UINT32 ulBufferSize) PURE;
   STDMETHOD_(UINT32,GetIMFScriptBufferLength)() PURE;
   STDMETHOD_(UINT32,Validate) (void * pBuffer,UINT32 ulBufferSize) PURE;
   STDMETHOD_(UINT32,GetError) (void * pBuffer,UINT32 ulBufferSize) PURE;
   STDMETHOD(Clear) () PURE;
};
////////////////////////////////////////////////////////////
#endif
