/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: ogg_timestamp.cpp,v 1.1.4.1 2004/11/24 18:02:52 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#include "ogg_timestamp.h"
#include "hxassert.h"

COggTimestamp::COggTimestamp() :
    m_samples(0),
    m_uSampleRate(1),
    m_bLostPrecision(FALSE)
{}

COggTimestamp::COggTimestamp(ogg_int64_t samples, UINT32 uSampleRate) :
    m_samples(samples),
    m_uSampleRate(uSampleRate),
    m_bLostPrecision(FALSE)
{
    HX_ASSERT(m_uSampleRate > 0);
}

void COggTimestamp::SetSampleRate(UINT32 uSampleRate)
{
    HX_ASSERT(m_uSampleRate > 0);
    HX_ASSERT(uSampleRate > 0);

    ogg_int64_t llQ = m_samples / m_uSampleRate;
    ogg_int64_t llR = m_samples - llQ * m_uSampleRate;
    ogg_int64_t llTmp = llR * uSampleRate;
    ogg_int64_t llQ2 = llTmp / m_uSampleRate;
    ogg_int64_t llR2 = llTmp - llQ2 * m_uSampleRate;
   
    m_samples = (llQ * uSampleRate + llQ2);
    m_uSampleRate = uSampleRate;

    if (llR2)
    {
        m_bLostPrecision = TRUE;
    }
}

void COggTimestamp::SetSampleRateToHighest(const COggTimestamp& rhs)
{
    if (m_uSampleRate < rhs.m_uSampleRate)
    {
        SetSampleRate(rhs.m_uSampleRate);
    }
}

COggTimestamp COggTimestamp::operator+ (const COggTimestamp& rhs)
{
    HX_ASSERT(m_uSampleRate == rhs.m_uSampleRate);

    return COggTimestamp(m_samples + rhs.m_samples, m_uSampleRate);
}

COggTimestamp& COggTimestamp::operator+= (const COggTimestamp& rhs)
{
    HX_ASSERT(m_uSampleRate == rhs.m_uSampleRate);

    m_samples += rhs.m_samples;

    return *this;
}

bool COggTimestamp::operator <(const COggTimestamp& rhs)
{
    bool bRet = false;

    ogg_int64_t llLeftSec = m_samples / m_uSampleRate;
    ogg_int64_t llRightSec = rhs.m_samples / rhs.m_uSampleRate;
    
    if (llLeftSec < llRightSec)
    {
        bRet = true;
    }
    else if (llLeftSec == llRightSec)
    {
        ogg_int64_t llLeftFracSec = m_samples % m_uSampleRate;
        ogg_int64_t llRightFracSec = rhs.m_samples % rhs.m_uSampleRate;

        if (m_uSampleRate != rhs.m_uSampleRate)
        {
            llLeftFracSec *= rhs.m_uSampleRate;
            llRightFracSec *= m_uSampleRate;
        }
        
        bRet = (llLeftFracSec < llRightFracSec);
    }

    return bRet;
}
