/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: sm1parse.h,v 1.2.12.1 2004/07/09 01:57:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SM1PARSE_H_
#define _SM1PARSE_H_

#include "chxpckts.h"
#include "smil1typ.h" /* renamed for SHAZAM; used to be smiltype.h */

// forward declarations
_INTERFACE   IHXSystemRequired;

typedef enum
{
    SMILUnknown = 0,
    SMILSmil,
    SMILMeta,
    SMILHead,
    SMILBody,
    SMILBasicLayout,
    SMILRootLayout,
    SMILRegion,
    SMILSwitch,
    SMILText,
    SMILImg,
    SMILRef,
    SMILAudio,
    SMILVideo,
    SMILAnimation,
    SMILTextstream,
    SMILAnchor,
    SMILAAnchor,
    SMILEndAAnchor,
    SMILPar,
    SMILEndPar,
    SMILSeq,
    SMILEndSeq,
    SMILRNRendererList,
    SMILRendererPreFetch
} SMIL1NodeTag;

typedef enum
{
    SMILEventSourceNone,
    SMILEventSourceBegin,
    SMILEventSourceEnd,
    SMILEventSourceFirst,
    SMILEventSourceLast,
    SMILEventSourceID,
    SMILEventSourceClock
} SMILEventSourceTag;

typedef enum
{
    SMILSyncAttrNone,
    SMILSyncAttrBegin,
    SMILSyncAttrEnd,
    SMILSyncAttrDur,
    SMILSyncAttrEndsync,
    SMILSyncAttrClipBegin,
    SMILSyncAttrClipEnd
} SMILSyncAttributeTag;

typedef enum
{
    SMILErrorNone,
    SMILErrorGeneralError,
    SMILErrorBadXML,
    SMILErrorNotSMIL,
    SMILErrorDuplicateID,
    SMILErrorNonexistentID,
    SMILErrorNoBodyTag,
    SMILErrorNoBodyElements,
    SMILErrorUnrecognizedTag,
    SMILErrorUnrecognizedAttribute,
    SMILErrorUnexpectedTag,
    SMILErrorBadDuration,
    SMILErrorBadAttribute,
    SMILErrorBadFragment,
    SMILErrorRequiredAttributeMissing,
    SMILErrorSyncAttributeMissing,
    SMILErrorUnexpectedContent,
    SMILErrorSMIL10Document,
    SMILErrorIndefiniteNotSupported,
    SMILErrorMetaDatatype,
    SMILErrorRootLayoutHeightWidthRequired,
    SMILErrorBadID,
    SMILErrorNoSources,
    SMILXMLUnknownError		    = HXR_XML_GENERALERROR,
    SMILXMLErrorNoClose		    = HXR_XML_NOCLOSE,
    SMILXMLErrorBadAttribute	    = HXR_XML_BADATTRIBUTE,
    SMILXMLErrorNoValue		    = HXR_XML_NOVALUE,
    SMILXMLErrorMissingQuote	    = HXR_XML_MISSINGQUOTE,
    SMILXMLErrorBadEndTag	    = HXR_XML_BADENDTAG,
    SMILXMLErrorNoTagType	    = HXR_XML_NOTAGTYPE,
    SMILXMLErrorIllegalID	    = HXR_XML_ILLEGALID
} SMILErrorTag;

class SMIL1NodeList;
class CSmil1Element;

class SMIL1Namespace
{
public:
    SMIL1Namespace(SMIL1Namespace* pNS)
    {
	m_name = new_string(pNS->m_name);
	m_pValue = pNS->m_pValue;
	m_pValue->AddRef();
    }

    SMIL1Namespace(const char* name, IHXBuffer* pVal)
    {
	m_name = new_string(name);
	m_pValue = pVal;
	m_pValue->AddRef();
    }
    ~SMIL1Namespace()
    {
	HX_VECTOR_DELETE(m_name);
	HX_RELEASE(m_pValue);
    }
    char* m_name;
    IHXBuffer* m_pValue;
};

class CSmil1Parser;

class SMIL1Node
{
public:
    SMIL1Node	();
    ~SMIL1Node	();
    SMIL1Node	(const SMIL1Node&, BOOL bKeepId=FALSE, CSmil1Parser* pParser=NULL);

    SMIL1Node*	getFirstChild();
    SMIL1Node*	getNextChild();

    CHXString		m_repeatid;
    CHXString		m_id;
    CHXString		m_name;
    UINT32		m_num;    
    SMIL1NodeTag		m_tag;
    SMIL1Node*		m_pParent;
    SMIL1Node*		m_pDependency;
    SMIL1NodeList*	m_pNodeList;
    IHXValues*		m_pValues;
    CSmil1Element*	m_pElement;
    UINT16		m_nGroup;
    BOOL 		m_bLastInGroup;
    BOOL		m_bDelete;
    BOOL		m_bSkipContent;
    BOOL		m_bRepeatHandled;
    RepeatTag		m_repeatTag;
    CHXString		m_trackHint;
    UINT32		m_ulTagStartLine;
    UINT32		m_ulTagStartColumn;

    CHXSimpleList*	m_pNamespaceList;
private:
    LISTPOSITION	m_curPosition;
};

class SMIL1NodeList: public CHXSimpleList
{
public:
    SMIL1NodeList	();
    ~SMIL1NodeList	();
    SMIL1NodeList* copy	(SMIL1Node* pParent, BOOL bKeepId=FALSE, CSmil1Parser* pParser = NULL);
    SMIL1Node* 	m_pParentNode;
};

//
// Parser class
//

class CSmil1Region;
class CSmil1RootLayout;
class CSmil1Source;
class CSmil1AAnchorElement;
class CSmil1AnchorElement;
class CSmil1SeqElement;
class CSmil1ParElement;
class CSmil1Meta;
class CSmil1RendererPreFetch;
class CSmil1MetaValues;
class CSmil1EndLayout;
class CSmil1ElementHandler;
class CSmil1Parser;
class XMLError;
class CSmil1TimelineElementManager;

class CSmil1ParserResponse: public IHXXMLParserResponse,
			   public ErrorNotifier
{
private:
    CSmil1Parser*		m_pParser;
    INT32			m_lRefCount;
    SMIL1Node*			m_pCurrentNode;

public:
    CSmil1ParserResponse		(CSmil1Parser* pParser);
    ~CSmil1ParserResponse	();

    STDMETHOD(QueryInterface)	(REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	();

    STDMETHOD_(ULONG32,Release)	();

    STDMETHOD(HandleStartElement)	(const char*	/*IN*/	pName,
					IHXValues*	/*IN*/	pAttributes,
					UINT32		/*IN*/	ulLineNumber,
					UINT32		/*IN*/	ulColumNumber);

    STDMETHOD(HandleEndElement)		(const char*	/*IN*/	pName,
					UINT32		/*IN*/	ulLineNumber,
					UINT32		/*IN*/	ulColumNumber);

    STDMETHOD(HandleCharacterData)	(IHXBuffer*	/*IN*/	pBuffer,
					UINT32		/*IN*/	ulLineNumber,
					UINT32		/*IN*/	ulColumNumber);

    STDMETHOD(HandleProcessingInstruction)  (const char* /*IN*/  pTarget,
					    IHXValues* /*IN*/  pAttributes,
					    UINT32		/*IN*/	ulLineNumber,
					    UINT32		/*IN*/	ulColumNumber);

    STDMETHOD(HandleUnparsedEntityDecl)	    (const char* /*IN*/  pEntityName,
					    const char* /*IN*/  pSystemID,
					    const char* /*IN*/  pPublicID,
					    const char* /*IN*/  pNotationName,
					    UINT32	/*IN*/	ulLineNumber,
					    UINT32	/*IN*/	ulColumNumber);

    STDMETHOD(HandleNotationDecl)	    (const char* /*IN*/  pNotationName,
					    const char* /*IN*/  pSystemID,
					    const char* /*IN*/  pPublicID,
					    UINT32	/*IN*/	ulLineNumber,
					    UINT32	/*IN*/	ulColumNumber);

    STDMETHOD(HandleComment)		    (const char* /*IN*/  pComment,
					    UINT32	 /*IN*/	ulLineNumber,
					    UINT32	 /*IN*/	ulColumNumber);

    STDMETHOD(HandleUnparsedDoctypeDecl)    (const char*  /*IN*/ pName, 
					    const char*  /*IN*/ pSystemID,
					    const char*  /*IN*/ pPublicID, 
					    UINT32	 /*IN*/	ulLineNumber,
					    UINT32	 /*IN*/	ulColumNumber);

    STDMETHOD(HandleDefault)		    (IHXBuffer*	/*IN*/	pBuffer,
					    UINT32		/*IN*/	ulLineNumber,
					    UINT32		/*IN*/	ulColumNumber);
    
    HX_RESULT ErrorInLastTag		    (HX_RESULT Error, 
					    const char* pErrorString,
					    const char* pFrameString, 
					    UINT32 ulLineNumber,
					    UINT32 ulLinePosition);
};

class CSmil1Parser
{
public:
    CSmil1Parser					(IUnknown* pContext);
    ~CSmil1Parser				();

    HX_RESULT init				(BOOL bStoreErrors = FALSE);
    HX_RESULT parse				(IHXBuffer* pBuffer,
						BOOL bIsFinal);
    HX_RESULT parse				(const char* pSmilText);
    HX_RESULT createElements			();
    HX_RESULT durationResolved			(const char* pID,
    						UINT32 ulDuration);
    void insertTimelineElement			(const char* pID, 
						UINT32 ulDelay);
    void resetTimelineElementDuration		(const char* pID,
						UINT32 ulDuration);
    void resetTimeline				();
    UINT16 getFragmentGroup			(const char* pFragment);
    UINT32 getFragmentOffset			(const char* pFragment,
						BOOL& bFragFoundAndResolved);
    HX_RESULT handleNextElement			(CSmil1ElementHandler* pHandler);
    SMIL1Node* findFirstNode			(SMIL1NodeTag tag);
    SMIL1Node* getFirstNodeChild			(SMIL1Node* pNode);
    CSmil1Element* findElement			(const char* pID);
    SMIL1Node* getNextNodeChild			();
    void getPacketPending			(UINT16 unStreamNumber);
    
    HX_RESULT addGlobalNamespace		(const char* pNamespace,
						const char* pPrefix);
    
    HX_RESULT storeNamespaces			(SMIL1Node* pNode);
    
    HX_RESULT addToNamespaceScope		(SMIL1Node* pNode);
    HX_RESULT removeFromNamespaceScope		(SMIL1Node* pNode);

    // note -- the pErr array returned has the same scope as the SMILParser 
    // object
    HX_RESULT getErrors				(CHXPtrArray** pErrs);

    BOOL IsSMIL10FullyCompliant			() {return
						m_bSMIL10FullCompliance;}
    UINT32 GetUniqueNumber()                    { return m_ulNextVar++; }

    ElementWithinTag	GetElementWithin(const char* pID);
    void		InitPersistent(UINT32 ulPersistentComponentID, ElementWithinTag elementWithinTag);
    
    CHXStack* 					m_pNodeListStack;
    SMIL1NodeList* 				m_pNodeList;
    BOOL 					m_bTimestampsResolved;
    UINT32					m_ulErrorLineNumber;
    UINT32					m_ulErrorColumnNumber;
    IHXBuffer*					m_pErrorText;
    CSmil1TimelineElementManager*               m_pTimelineElementManager;

    friend class CSmil1ParserResponse;

private:
    void close					();
    void initRequireTags			();
    void getPreferences				();
    HX_RESULT createHeadElements		(SMIL1NodeList* pNodeList);
    HX_RESULT createSeqWrapper			(SMIL1NodeList* pNodeList);
    HX_RESULT createBodyElements		(SMIL1NodeList* pNodeList);
    HX_RESULT assignGroupIndexes		(SMIL1NodeList* pNodeList);
    HX_RESULT assignGroupIndexOnPar		(SMIL1Node* pNode,
						 UINT16 nGroup);
    HX_RESULT assignGroupIndexOnSeq		(SMIL1Node* pNode,
						 UINT16& nGroup);
    HX_RESULT constructTimelineElements		(SMIL1NodeList* pNodeList);
    HX_RESULT setInitialDelays			(SMIL1NodeList* pNodeList);
    void setInitialDelay			(SMIL1Node* pNode);
    void setInitialDelayOnSeq			(SMIL1Node* pNode);
    HX_RESULT expandRepeatElements		(SMIL1NodeList* pNodeList);
    HX_RESULT printBodyElements			(SMIL1NodeList* pNodeList);
    HX_RESULT updateEventElements		(SMIL1NodeList* pNodeList);
    HX_RESULT insertElementByTimestamp		(CSmil1Element* pElement);
    HX_RESULT addGroup				(SMIL1Node* pNode);
    HX_RESULT insertGroups			();
    HX_RESULT mapID				(SMIL1Node* pNode, BOOL bOverWrite=FALSE);
    HX_RESULT mapChildrenIDs			(SMIL1NodeList* pNodeList, BOOL bOverWrite=FALSE);
    HX_RESULT markRepeatReplica  		(SMIL1NodeList* pNodeList, RepeatTag repeatTag);
    BOOL testAttributeFailed			(SMIL1Node* pNode);
    BOOL systemComponentFailed			(IHXBuffer* pRequiredValue);
    HX_RESULT markTestAttributeNodes		(SMIL1NodeList* pNodeList);
    HX_RESULT selectSwitchNodes			(SMIL1Node* pNode);
    BOOL hasParParent				(SMIL1Node* pNode);
    BOOL inSeq					(SMIL1Node* pNode);
    HX_RESULT createParent			(SMIL1Node* pChildNode, SMIL1NodeTag tag,
						 SMIL1Node*& pParent, SMIL1Node*& pParentEnd);
    SMIL1Node* getSyncParent			(SMIL1Node* pNode);
    void resolveTimestamps			();
    void resolveTimestamps			(SMIL1NodeList* pNodeList);
    UINT32 getStartTime				(SMIL1Node* pNode);
    CSmil1Region* makeRegion			(SMIL1Node* pNode);
    CSmil1RootLayout* makeRootLayout		(SMIL1Node* pNode);
    CSmil1Meta* makeMeta				(SMIL1Node* pNode);
    CSmil1RendererPreFetch* makeRendererPreFetch	(SMIL1Node* pNode);
    CSmil1Source* makeSource			(SMIL1Node* pNode);
    CSmil1AAnchorElement* makeAAnchorElement	(SMIL1Node* pNode);
    CSmil1AnchorElement* makeAnchorElement	(SMIL1Node* pNode);
    CSmil1SeqElement* makeSeqElement		(SMIL1Node* pNode);
    CSmil1ParElement* makeParElement		(SMIL1Node* pNode);
    BOOL firstDependentChild			(SMIL1Node* pNode);
    SMIL1Node* findFirstNode			(SMIL1NodeList* pNodelist, 
    						SMIL1NodeTag tag);
    SMIL1Node* getTimelineDescendent		(SMIL1Node* pParentNode, 
						SMIL1Node* pSiblingNode);
    SMIL1Node* getTimelineDescendent		(SMIL1Node* pParentNode);
    const char*	assignID			(const char* pPrefix);
    HX_RESULT parseDuration			(const char* pDuration,
    						CSmil1Element* pElement,
						SMILSyncAttributeTag nTag);
    HX_RESULT adjustDuration			(CSmil1Element* pElement);
    HX_RESULT parseClockValue			(const char* pValue,
						UINT32& ulClockValue);
    HX_RESULT parseAnchorCoords			(const char* pCoords, 
						CSmil1AnchorElement* pAnchor);
    BOOL inLanguagePreference			(const char* pLang);
    BOOL isRelativeURL				(const char* pURL);
    UINT8 getColorElement			(const char* pColorFragment,
    						int len);
    HXxColor parseColor				(const char* pColorString);
    void handleXMLParserError			(XMLError* pError);
    void badAttributeError			(SMIL1NodeTag tag,
						const char* pNodeName,
						UINT32 ulLineNumber,
						BOOL bJustStore);
    void initTagAttributes			();
    void deleteTagAttributes			();
    BOOL isLegalAttribute			(SMIL1NodeTag tag,
						const char* pAttrName);
    SMIL1NodeTag getSyncTag			(SMIL1Node* pNode);

    HX_RESULT storeError			(HX_RESULT errCode, 
						 const char* pErrorString, 
						 const char* pFrameString,
						 UINT32 ulLineNumber, 
						 UINT32 ulLinePosition,
						 BOOL bXml = TRUE);
    BOOL isMediaObject				(SMIL1Node* pNode);

    IUnknown* 		    m_pContext;
    IHXCommonClassFactory*  m_pClassFactory;
    IHXSystemRequired*	    m_pISystemRequired;
    IHXXMLParser*	    m_pParser;
    CSmil1ParserResponse*    m_pResponse;
    SMIL1Node* 		    m_pCurNode;

    CHXStack*		    m_pNodeDependencies;
    SMIL1Node*		    m_pCurrentDependentNode;

    CHXStack*		    m_pAnchorStack;
    CSmil1AAnchorElement*    m_pCurrentAnchor;

    UINT32 		    m_ulCurEndTime;
    CSmil1EndLayout*	    m_pEndLayout;
    CHXSimpleList* 	    m_pPacketQueue;
    CHXSimpleList*	    m_pSourceUpdateList;
    CHXMapLongToObj*	    m_pAddGroupMap;
    CHXMapLongToObj*	    m_pTagAttributeMap;
    CHXMapStringToOb* 	    m_pIDMap;
    CHXMapStringToOb*	    m_pRequireTagsMap;
    
    CHXMapStringToOb*	    m_pActiveNamespaceMap;
    CHXSimpleList*	    m_pNSConflictList;
    
    char*		    m_pBasePath;

    CHXSimpleList*	    m_pTrackHintList;

    BOOL		    m_bIgnoreUnrecognizedElements;
    BOOL		    m_bNoNamespaces;
    BOOL		    m_bRNNamespace;
    BOOL		    m_bSMILRootLayoutAlreadyFound;
    //This flag is always FALSE until we enable it in a future
    // release at which point we will initialize it to TRUE
    // and only set it to FALSE when an author or server admin
    // specifically specifies that he/she wants our old
    // SMIL parser to handle the (presumably poorly-authored) file.
    // NOTE: as of 1/20/2000, the code to allow authors to
    // force the old parser to be used is not yet written.
    // In addition, pncont/xmlparse.h/.cpp has a similar flag and
    // the two need to be linked to the same value when that code
    // gets written:
    BOOL		    m_bSMIL10FullCompliance;

    UINT32 		    m_ulBandwidthPreference;
    UINT32		    m_ulScreenHeightPreference;
    UINT32		    m_ulScreenWidthPreference;
    UINT32		    m_ulScreenDepthPreference;
    BOOL		    m_bCaptionsPreference;
    BOOL		    m_bContainsSource;
    char*		    m_pOverdubOrCaptionPreference;
    char*		    m_pEncoding;
    CHXSimpleList*	    m_pLanguagePreferenceList;

    BOOL		    m_bStoreErrors;
    CHXPtrArray*	    m_pErrors;

    UINT32		    m_ulPersistentComponentID;
    ElementWithinTag	    m_elementWithinTag;
    char*                   m_pVarName;
    UINT32                  m_ulNextVar;
};

#endif	/* _SM1PARSE_H_ */
