/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxstatuscongestion.cpp,v 1.4.4.4 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxstatuscongestion.h"

#include <string.h>

#include "hxplayer.h"
#include "hxstatisticsobserver.h"
#include "hxplayer-i18n.h"
#include "commonapp.h"

/* Define congestion loss as losing 25% of packets */
#define CONGESTION_LOSS_PERCENTAGE 25

static void hxstatus_display_congestion_class_init (HXStatusDisplayCongestionClass* klass);
static void hxstatus_display_congestion_init       (HXStatusDisplayCongestion*      status,
                                                    HXStatusDisplayCongestionClass* klass);

static void hxstatus_display_congestion_set_player (HXStatusDisplay* status,
                                                    HXPlayer*     player);

static HXStatusDisplayClass* g_parent_class = NULL;

GType
hxstatus_display_congestion_get_type (void)
{
    static GType hxstatus_display_congestion_type = 0;

    if (!hxstatus_display_congestion_type)
    {
	static const GTypeInfo hxstatus_display_congestion_info =
	    {
		sizeof (HXStatusDisplayCongestionClass),
		NULL,		/* base_init */
		NULL,		/* base_finalize */
		(GClassInitFunc) hxstatus_display_congestion_class_init,
		NULL,		/* class_finalize */
		NULL,		/* class_data */
		sizeof (HXStatusDisplayCongestion),
		0,		/* n_preallocs */
		(GInstanceInitFunc) hxstatus_display_congestion_init,
		NULL,           /* value_table */
	    };

	hxstatus_display_congestion_type = g_type_register_static (HX_TYPE_STATUS_DISPLAY, "HXStatusDisplayCongestion",
                                                                     &hxstatus_display_congestion_info, (GTypeFlags)0);
    }

    return hxstatus_display_congestion_type;
}


static void
hxstatus_display_congestion_class_init (HXStatusDisplayCongestionClass *klass)
{
    HXStatusDisplayClass* status_class = HX_STATUS_DISPLAY_CLASS(klass);
    g_parent_class = (HXStatusDisplayClass*)g_type_class_peek_parent (klass);
    
    status_class->set_player = hxstatus_display_congestion_set_player;
}

static void
hxstatus_display_congestion_init(HXStatusDisplayCongestion* status, HXStatusDisplayCongestionClass* /* klass */)
{
    status->congestion_led = NULL;
}

GtkWidget*
hxstatus_display_congestion_new(void)
{
    HXStatusDisplayCongestion* status = (HXStatusDisplayCongestion*)g_object_new(HX_TYPE_STATUS_DISPLAY_CONGESTION, NULL);
    gchar* filename;
    filename = hxcommon_locate_file("congestion.png");
    status->congestion_led = gtk_image_new_from_file(filename);
    g_free(filename);
    
    gtk_widget_show(status->congestion_led);

    gtk_container_add(GTK_CONTAINER(status), status->congestion_led);
    
    return GTK_WIDGET(status);
}

static void
sc_lost30_modified(GObject* /* object */, const gchar* name, GValue* lost30, HXStatusDisplayCongestion* congestion)
{
    HXStatusDisplay* status;
    GValue total30;
    const gdouble min_congestion_factor = (100.0 - CONGESTION_LOSS_PERCENTAGE) / 100.0;
    gdouble congestion_factor = 100.0;
    guint total30_int, lost30_int;
    
    g_return_if_fail(congestion != NULL);
    
    status = HX_STATUS_DISPLAY(congestion);

    memset(&total30, 0, sizeof(total30));
    hx_player_get_statistic(status->player, name, &total30);
    
    total30_int = g_value_get_int(&total30);
    lost30_int = g_value_get_int(lost30);

    if(total30_int > 0)
    {
        congestion_factor = (gdouble)lost30_int / (gdouble)total30_int;
    }

    if(congestion_factor < min_congestion_factor)
    {
        gtk_widget_hide(congestion->congestion_led);
    }
    else
    {
        gtk_widget_show(congestion->congestion_led);
    }
}


static void
hxstatus_display_congestion_set_player(HXStatusDisplay* status, HXPlayer* player)
{ 
    HXStatusDisplayCongestion* congestion = HX_STATUS_DISPLAY_CONGESTION(status);
    g_return_if_fail(congestion != NULL);

    if(congestion->lost30_observer)
    {
        g_object_unref(congestion->lost30_observer);
        congestion->lost30_observer = NULL;
    }

    if(player)
    {
        congestion->lost30_observer = hx_statistics_observer_new(player,
                                                                  "Source#.Stream#.Lost30");
    
        /* Hook up to the player */
        g_signal_connect(G_OBJECT(congestion->lost30_observer),
                         "statistic_modified",
                         G_CALLBACK(sc_lost30_modified),
                         status);
    }

    HX_STATUS_DISPLAY_CLASS(g_parent_class)->set_player(status, player);
}
