/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: vidctrls.cpp,v 1.2.2.1 2004/07/19 21:04:31 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "vidctrls.h"
#include "commonapp.h"

extern "C" 
{
void hvcd_brightness_scale_value_changed    (GtkRange* range,
                                             HXPlayer* player);
void hvcd_contrast_scale_value_changed      (GtkRange* range,
                                             HXPlayer* player);
void hvcd_saturation_scale_value_changed    (GtkRange* range,
                                             HXPlayer* player);
void hvcd_hue_scale_value_changed           (GtkRange* range,
                                             HXPlayer* player);
void hvcd_sharpness_scale_value_changed     (GtkRange* range,
                                             HXPlayer* player);
}

typedef struct
{
    GladeXML* xml;
    HXPlayer* player;
} HXVideoControlsDialog;

static void
hvcd_destroy(GtkWidget* widget,
             HXVideoControlsDialog* info)
{
    glade_xml_destroy (info->xml);
    g_free(info);
}


GtkDialog* 
hxplay_video_controls_new (HXPlayer* player)
{
    GtkWidget* dialog;
    GtkWidget* brightness_scale;
    GtkWidget* contrast_scale;
    GtkWidget* saturation_scale;
    GtkWidget* hue_scale;
    GtkWidget* sharpness_scale;
    HXVideoControlsDialog* info;
    gchar* filename;
    GladeXML* xml;

    filename = hxcommon_locate_file("vidctrls.glade");
    xml = glade_xml_new (filename, NULL, NULL);
    g_free(filename);
    g_return_val_if_fail(xml != NULL, NULL);

    dialog = glade_xml_get_widget(xml, "hxplayer_video_controls_dialog");
    g_return_val_if_fail(dialog != NULL, NULL);

    brightness_scale = glade_xml_get_widget(xml, "hvcd_brightness_scale");
    contrast_scale = glade_xml_get_widget(xml, "hvcd_contrast_scale");
    saturation_scale = glade_xml_get_widget(xml, "hvcd_saturation_scale");
    hue_scale = glade_xml_get_widget(xml, "hvcd_hue_scale");
    sharpness_scale = glade_xml_get_widget(xml, "hvcd_sharpness_scale");

    g_return_val_if_fail(brightness_scale != NULL &&
                         contrast_scale != NULL &&
                         saturation_scale != NULL &&
                         hue_scale != NULL &&
                         sharpness_scale != NULL, NULL);

    g_signal_connect(G_OBJECT(brightness_scale), 
                     "value_changed",
                     G_CALLBACK(hvcd_brightness_scale_value_changed),
                     player);

    g_signal_connect(G_OBJECT(contrast_scale), 
                     "value_changed",
                     G_CALLBACK(hvcd_contrast_scale_value_changed),
                     player);

    g_signal_connect(G_OBJECT(saturation_scale), 
                     "value_changed",
                     G_CALLBACK(hvcd_saturation_scale_value_changed),
                     player);

    g_signal_connect(G_OBJECT(hue_scale), 
                     "value_changed",
                     G_CALLBACK(hvcd_hue_scale_value_changed),
                     player);

    g_signal_connect(G_OBJECT(sharpness_scale), 
                     "value_changed",
                     G_CALLBACK(hvcd_sharpness_scale_value_changed),
                     player);

    g_object_set_data(G_OBJECT(dialog), "player", player);

    info = g_new0(HXVideoControlsDialog, 1);
    info->xml = xml;

    g_signal_connect (G_OBJECT (dialog), "destroy",
                      G_CALLBACK (hvcd_destroy),
                      info);

    return GTK_DIALOG(dialog);
}

void
hvcd_brightness_scale_value_changed (GtkRange* range, HXPlayer* player)
{
    gdouble brightness;
    brightness = gtk_range_get_value(range);
    hx_player_set_brightness(player, brightness);
}

void
hvcd_contrast_scale_value_changed (GtkRange* range, HXPlayer* player)
{
    gdouble contrast;
    contrast = gtk_range_get_value(range);
    hx_player_set_contrast(player, contrast);
}

void
hvcd_saturation_scale_value_changed (GtkRange* range, HXPlayer* player)
{
    gdouble saturation;
    saturation = gtk_range_get_value(range);
    hx_player_set_saturation(player, saturation);
}

void
hvcd_hue_scale_value_changed (GtkRange* range, HXPlayer* player)
{
    gdouble hue;
    hue = gtk_range_get_value(range);
    hx_player_set_hue(player, hue);
}

void
hvcd_sharpness_scale_value_changed (GtkRange* range, HXPlayer* player)
{
    gdouble sharpness;
    sharpness = gtk_range_get_value(range);
    hx_player_set_sharpness(player, sharpness);
}
