/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_DOWNLOAD_BOX_H__
#define __KZ_DOWNLOAD_BOX_H__

#include "kz-window.h"
#include "kz-downloader.h"
#include "kz-downloader-group.h"

G_BEGIN_DECLS

#define KZ_TYPE_DOWNLOAD_BOX		(kz_download_box_get_type ())
#define KZ_DOWNLOAD_BOX(obj)		(GTK_CHECK_CAST ((obj), KZ_TYPE_DOWNLOAD_BOX, KzDownloadBox))
#define KZ_DOWNLOAD_BOX_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), KZ_TYPE_DOWNLOAD_BOX, KzDownloadBoxClass))
#define KZ_IS_DOWNLOAD_BOX(obj)		(GTK_CHECK_TYPE ((obj), KZ_TYPE_DOWNLOAD_BOX))
#define KZ_IS_DOWNLOAD_BOX_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), KZ_TYPE_DOWNLOAD_BOX))
#define KZ_DOWNLOAD_BOX_GET_CLASS(obj)	(GTK_CHECK_GET_CLASS ((obj), KZ_TYPE_DOWNLOAD_BOX, KzDownloadBoxClass))

typedef struct _KzDownloadBox      KzDownloadBox;
typedef struct _KzDownloadBoxClass KzDownloadBoxClass;

typedef struct _KzDownloaderIcon KzDownloaderIcon;

struct _KzDownloadBox
{
	GtkStatusbar parent;

	/* Kazehakase */
	KzWindow *kz;
	
	/* downloader item list */
	KzDownloaderGroup *dlgrp;
	
	/* downloader icon list */
	GSList *icon_list;
};

struct _KzDownloadBoxClass
{
	GtkStatusbarClass parent_class;
};

struct _KzDownloaderIcon
{
	KzDownloader *dl;
	
	GtkWidget *image;
	GtkWidget *event_box;
	GtkTooltips *tips;
	gint fraction;
};

GType      kz_download_box_get_type (void) G_GNUC_CONST;
GtkWidget *kz_download_box_new      (KzWindow *kz);

G_END_DECLS

#endif /* __KZ_DOWNLOAD_BOX_H__ */
