/***************************************************************************
                          html_widget.cpp  -  description
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

//#include <KHTMLView>

#include "html_widget.h"
#include "utils.h"
//#include "qtrans.h"

//Html_Widget::Html_Widget(QWidget *parentWidget, QObject *parent, GUIProfile prof)
//	: KHTMLPart(parentWidget, parent, prof)
Html_Widget::Html_Widget(QWidget *parent)
	: QWebView(parent)	//ooo
{
	//m_page = new Html_Widget_2(this);	//ooo
	//Par = parentWidget;
	Par = parent;	//ooo
	//view()->setMinimumSize(60,60);
	clear();

/*	popMenu = new KMenu(view());
	//connect(this,SIGNAL(popupMenu(const QString&, const QPoint &)),
	//		this, SLOT(slot_PopupMenu(const QString& , const QPoint &)));
	KAction *outAct  = new KAction( KIcon("view-refresh"), i18n("&Translate"),this );
	popMenu->addAction(outAct);
	connect(popMenu, SIGNAL(triggered (QAction *) ),
			this, SLOT(slot_PopupMenu(QAction *)));
*/

}

//Html_Widget::~Html_Widget()
Html_Widget::~Html_Widget()	//ooo
{
}

/*
void Html_Widget_2::mousePressEvent(QMouseEvent *event)
{
        //m_page->setKeys(event->buttons(), event->modifiers());
        QWebView::mousePressEvent(event);
}
*/


void Html_Widget::contextMenuEvent(QContextMenuEvent *event)
{

	//if ( QContextMenuEvent::Mouse) {
	//	KMessageBox::sorry(this, i18n("mousePressEvent!"));	
	//}

/*	languageGroup = new QActionGroup(this);

	for (int i = 0; i < Par->actionsList.size(); ++i) {
		languageMenu->addAction(actionsList.at(i));
		languageGroup->addAction(actionsList.at(i));
	}

	connect(languageGroup, SIGNAL(triggered(QAction *)), this, SLOT(Par->chooseLibrary(QAction *)));

	//languageMenu->addSeparator();
	//languageMenu->addAction(copyAct);
	languageMenu->addSeparator();
	if (compactMode)
		languageMenu->addAction(normalModeAct);
	else
		languageMenu->addAction(compactModeAct);
	languageMenu->addAction(stayOnTopAct);
	languageMenu->addSeparator();
	if (enabled)
		languageMenu->addAction(Dock->disableAct);
	else
		languageMenu->addAction(Dock->enableAct);

	//languageMenu->exec(event->globalPos());
	languageMenu->exec(mapToGlobal(event->pos()));

	delete languageGroup;
*/

	if ( QContextMenuEvent::Mouse) {

		QMouseEvent *event;
	}

	findAct = new QAction(i18n("Find"), this);
	findAct->setShortcut(tr("Ctrl+F"));
	connect(findAct, SIGNAL(triggered()), this, SLOT(slot_findMenu()));

	menu = new QMenu(this);
	//menu.addAction(pageAction(QWebPage::Back));
	//menu.addAction(pageAction(QWebPage::Forward));
	//menu.addAction(pageAction(QWebPage::Reload));
	menu->addAction(pageAction(QWebPage::Copy));
	menu->addAction(findAct);
	menu->addAction(pageAction(QWebPage::CopyLinkToClipboard));
	menu->exec(mapToGlobal(event->pos()));

}


void Html_Widget::slot_findMenu()
{
	FindWidget *wdgFind = new FindWidget(this);
	//wdgFind->exec();
	//delete wdgFind;
	wdgFind->show();
	//this->findText("a");
}


//void Html_Widget::buildMenu()
void Html_Widget::buildMenu()	//ooo
{
	//popMenu->insertSeparator();
	//popMenu->insertItem(SmallIcon("window_nofullscreen.png"),i18n("&Compact Mode"),
	//			/*Par,SLOT(toggleMode()),*/0);	
	//popMenu->insertItem(i18n("&Stay on Top"),/*Par,SLOT(slot_OnTop()),*/1);
	//popMenu->insertSeparator();
	//popMenu->insertItem(i18n("&Disable"),/*Par,SLOT(slot_Enable()),*/2);

	//popMenu->insertSeparator();
	//popMenu->insertItem(SmallIcon("window_nofullscreen.png"),i18n("&Compact Mode"),
	//			/*Par,SLOT(toggleMode()),*/0);	
	//popMenu->insertItem(i18n("&Stay on Top"),/*Par,SLOT(slot_OnTop()),*/1);
	//popMenu->insertSeparator();
	//popMenu->insertItem(i18n("&Disable"),/*Par,SLOT(slot_Enable()),*/2);
}

/*-- Write the result of translation in the widget --*/
//void Html_Widget::setOut(QString S)
void Html_Widget::setOut(QString S)	//ooo
{

#ifdef DEBUG_1   //ooo
	QString S3 = "";

/*	S3 += QChar(0xA4); S3 += QChar(0xA1); S3 += QChar(0xA4); S3 += QChar(0xA5);

	S3 += QChar(0xA5); S3 += QChar(0xC2); S3 += QChar(0xA5); S3 += QChar(0xC5);
	S3 += QChar(0xA5); S3 += QChar(0xFE); S3 += QChar(0xA5); S3 += QChar(0xF4);
	S3 += QChar(0xA5); S3 += QChar(0xF5); S3 += QChar(0xA5); S3 += QChar(0xF6);
	S3 += QChar(0xA5); S3 += QChar(0xF7); S3 += QChar(0xA5); S3 += QChar(0xF8);
	S3 += QChar(0xA5); S3 += QChar(0xF9); S3 += QChar(0xA5); S3 += QChar(0xFA);
	S3 += QChar(0xA5); S3 += QChar(0xFB); S3 += QChar(0xA5); S3 += QChar(0xFC);
	S3 += QChar(0xA5); S3 += QChar(0xFD); S3 += QChar(0xA5); S3 += QChar(0xFE);
	S3 += QChar(0xA5); S3 += QChar(0xFF); S3 += QChar(0xA4); S3 += QChar(0xEE);
	S3 += QChar(0xA4); S3 += QChar(0xF0); S3 += QChar(0xA4); S3 += QChar(0xF1);
	S3 += QChar(0xA4); S3 += QChar(0xF4); S3 += QChar(0xA4); S3 += QChar(0xF5);
	S3 += QChar(0xA4); S3 += QChar(0xF6); S3 += QChar(0xA5); S3 += QChar(0xF6);
	S3 += QChar(0xA1); S3 += QChar(0xB3); S3 += QChar(0xA1); S3 += QChar(0xB4);
	S3 += QChar(0xB1); S3 += QChar(0xA0); S3 += QChar(0xA5); S3 += QChar(0xA3);*/
/*	S3 += QChar(0xD1); S3 += QChar(0xB0); S3 += QChar(0xD2); S3 += QChar(0xB0);
	S3 += QChar(0xD1); S3 += QChar(0xB1); S3 += QChar(0xD2); S3 += QChar(0xB1);
	S3 += QChar(0xD1); S3 += QChar(0xB2); S3 += QChar(0xD2); S3 += QChar(0xB2);
	S3 += QChar(0xD1); S3 += QChar(0xB3); S3 += QChar(0xD2); S3 += QChar(0xB3);
	S3 += QChar(0xD1); S3 += QChar(0xB4); S3 += QChar(0xD2); S3 += QChar(0xB4);
	S3 += QChar(0xD1); S3 += QChar(0xB5); S3 += QChar(0xD2); S3 += QChar(0xB5);
	S3 += QChar(0xD1); S3 += QChar(0xB6); S3 += QChar(0xD2); S3 += QChar(0xB6);
	S3 += QChar(0xD1); S3 += QChar(0xB7); S3 += QChar(0xD2); S3 += QChar(0xB7);
	S3 += QChar(0xD1); S3 += QChar(0xB8); S3 += QChar(0xD2); S3 += QChar(0xB8);
	S3 += QChar(0xD1); S3 += QChar(0xB9); S3 += QChar(0xD2); S3 += QChar(0xB9);
	S3 += QChar(0xD1); S3 += QChar(0xBA); S3 += QChar(0xD2); S3 += QChar(0xBA);
	S3 += QChar(0xD1); S3 += QChar(0xBB); S3 += QChar(0xD2); S3 += QChar(0xBB);
	S3 += QChar(0xD1); S3 += QChar(0xBC); S3 += QChar(0xD2); S3 += QChar(0xBC);
	S3 += QChar(0xD1); S3 += QChar(0xBD); S3 += QChar(0xD2); S3 += QChar(0xBD);
	S3 += QChar(0xD1); S3 += QChar(0xBE); S3 += QChar(0xD2); S3 += QChar(0xBE);
	S3 += QChar(0xD1); S3 += QChar(0xBF); S3 += QChar(0xD2); S3 += QChar(0xBF);
	S3 += QChar(0xD1); S3 += QChar(0xC0); S3 += QChar(0xD2); S3 += QChar(0xC0);
	S3 += QChar(0xD1); S3 += QChar(0xC1); S3 += QChar(0xD2); S3 += QChar(0xC1);
	S3 += QChar(0xD1); S3 += QChar(0xC2); S3 += QChar(0xD2); S3 += QChar(0xC2);
	S3 += QChar(0xD1); S3 += QChar(0xC3); S3 += QChar(0xD2); S3 += QChar(0xC3);
	S3 += QChar(0xD1); S3 += QChar(0xC4); S3 += QChar(0xD2); S3 += QChar(0xC4);
	S3 += QChar(0xD1); S3 += QChar(0xC5); S3 += QChar(0xD2); S3 += QChar(0xC5);
	S3 += QChar(0xD1); S3 += QChar(0xC6); S3 += QChar(0xD2); S3 += QChar(0xC6);
	S3 += QChar(0xD1); S3 += QChar(0xC7); S3 += QChar(0xD2); S3 += QChar(0xC7);
	S3 += QChar(0xD1); S3 += QChar(0xC8); S3 += QChar(0xD2); S3 += QChar(0xC8);
	S3 += QChar(0xD1); S3 += QChar(0xC9); S3 += QChar(0xD2); S3 += QChar(0xC9);
	S3 += QChar(0xD1); S3 += QChar(0xCA); S3 += QChar(0xD2); S3 += QChar(0xCA);
	S3 += QChar(0xD1); S3 += QChar(0xCB); S3 += QChar(0xD2); S3 += QChar(0xCB);
	S3 += QChar(0xD1); S3 += QChar(0xCC); S3 += QChar(0xD2); S3 += QChar(0xCC);
	S3 += QChar(0xD1); S3 += QChar(0xCD); S3 += QChar(0xD2); S3 += QChar(0xCD);
	S3 += QChar(0xD1); S3 += QChar(0xCE); S3 += QChar(0xD2); S3 += QChar(0xCE);
	S3 += QChar(0xD1); S3 += QChar(0xCF); S3 += QChar(0xD2); S3 += QChar(0xCF);
	S3 += QChar(0xD1); S3 += QChar(0xD0); S3 += QChar(0xD2); S3 += QChar(0xD0);
	S3 += QChar(0xD1); S3 += QChar(0xD1); S3 += QChar(0xD2); S3 += QChar(0xD1);
	S3 += QChar(0xD1); S3 += QChar(0xD2); S3 += QChar(0xD2); S3 += QChar(0xD2);
	S3 += QChar(0xD1); S3 += QChar(0xD3); S3 += QChar(0xD2); S3 += QChar(0xD3);
	S3 += QChar(0xD1); S3 += QChar(0xD4); S3 += QChar(0xD2); S3 += QChar(0xD4);
	S3 += QChar(0xD1); S3 += QChar(0xD5); S3 += QChar(0xD2); S3 += QChar(0xD5);
	S3 += QChar(0xD1); S3 += QChar(0xD6); S3 += QChar(0xD2); S3 += QChar(0xD6);
	S3 += QChar(0xD1); S3 += QChar(0xD7); S3 += QChar(0xD2); S3 += QChar(0xD7);
	S3 += QChar(0xD1); S3 += QChar(0xD8); S3 += QChar(0xD2); S3 += QChar(0xD8);
	S3 += QChar(0xD1); S3 += QChar(0xD9); S3 += QChar(0xD2); S3 += QChar(0xD9);
	S3 += QChar(0xD1); S3 += QChar(0xDA); S3 += QChar(0xD2); S3 += QChar(0xDA);
	S3 += QChar(0xD1); S3 += QChar(0xDB); S3 += QChar(0xD2); S3 += QChar(0xDB);
	S3 += QChar(0xD1); S3 += QChar(0xDC); S3 += QChar(0xD2); S3 += QChar(0xDC);
	S3 += QChar(0xD1); S3 += QChar(0xDD); S3 += QChar(0xD2); S3 += QChar(0xDD);
	S3 += QChar(0xD1); S3 += QChar(0xDE); S3 += QChar(0xD2); S3 += QChar(0xDE);
	S3 += QChar(0xD1); S3 += QChar(0xDF); S3 += QChar(0xD2); S3 += QChar(0xDF);*/

	S3 += QChar(0xF5); S3 += QChar(0xDF); S3 += QChar(0xF6); S3 += QChar(0xDF);

	QTextCodec *japanCodec = QTextCodec::codecForName("eucJP");   //ooo
	QString locallyEncoded3 = S3;   //ooo
	QString unicodeString3 = japanCodec->toUnicode( locallyEncoded3 );   //ooo
	S3 = "<p >"+S3+"</p>";
	unicodeString3 = "<p >"+unicodeString3+"</p>";
#endif

	if (S=="") {
		clear();
		return;
	}
	//S = "<html>\n<style type=""text/css""><!-- i {color: blue} "
	S = "<html>\n<style type=""text/css""><!-- i {color: "+sentencePartTxtColor+"} "	//ooo
		//"l {color: black} "	//ooo
		"l {color: "+expressionTxtColor+"} "	//ooo
		"body {font-family: "+fontName+";background: "+bgColor+"; color: "+txtColor+";"
		"font-size: "+QString::number(Size)+"pt}"
		"p {margin: 0 0 0 0}"
		"p.text {margin: 0 0 0 1.2em; text-indent: -1.2em}"
		"hr {width: 25%}"
		//"a:link {color: black}"
		"a:link {color: "+expressionTxtColor+"}"	//ooo
		//"a:visited {color: black}--></style>\n"
		"a:visited {color: "+expressionTxtColor+"}--></style>\n"	//ooo
		"<meta http-equiv=""Content-Type"" content=""text/html; charset="+Charset+""">"
		"<body>"
		+S+

	#ifdef DEBUG_1   //ooo
		/*S3+*/unicodeString3+   //ooo
	#endif

		"</body></html>";
	//setEncoding(Charset);

		//setCharset(Charset);
		//setCharset(Charset,true);
	//begin();
	//write(S);
	setHtml(S);	//ooo
	//end();
#ifdef DEBUG_1
	ofstream file;
	//file.open("/home/mat/qtrans.html",ios::out);
	file.open("/home/gons/qtrans.html",ios_base::app);   //ooo
	//file << S;
	file << "S = " << S;
	file << "Charset = " << Charset << endl;
	file.close();
#endif
}

//void Html_Widget::clear()
void Html_Widget::clear()	//ooo
{
	//begin();
	//write("<html><body bgcolor="""+bgColor+"""></body></html>");
	setHtml("<html><body bgcolor="""+bgColor+"""></body></html>");	//ooo
	//setHtml("<html><body bgcolor=blue></body></html>");	//ooo
	//end();
}

//void Html_Widget::slot_PopupMenu(const QString& , const QPoint &p)
//void Html_Widget::slot_PopupMenu(QAction *)
void Html_Widget::slot_PopupMenu(QAction *)	//ooo
{
	//int result = popMenu->exec(p);
	//emit menuClicked(result);

	QMessageBox::about(Par, i18n("About Menu"), QString("%1").arg("Out"));

}

//void Html_Widget::setFont(QString family, int pointSize, QString CS)
void Html_Widget::setFont(QString family, int pointSize, QString CS)	//ooo
{
	fontName = family;
	Size = pointSize;
	Charset = CS;
	//setEncoding(Charset);
		//setCharset(Charset);
		//setCharset(Charset,true);
	
	/*QValueList<int>	sizes;
	sizes = fontSizes();
	QValueList<int>::Iterator it;
	it = sizes.begin();
	(*it) = pointSize;
	setFontSizes(sizes);*/
}


FindWidget::FindWidget(Html_Widget *parent) : QWidget(parent, Qt::Dialog)
{
	Par2 = parent;

	setWindowModality(Qt::WindowModal);
	setWindowTitle(i18n("Find Text"));

	setMinimumSize(300, 150);
	resize(240, 150);

	mainLayout = new QVBoxLayout(this);
	Box1 = new QHBoxLayout(this);
	Label1 = new QLabel(i18n("Text to find:"),this);
	wordName = new QLineEdit(this);

	Box1->setSpacing(5);
	Box1->addWidget(Label1);
	Box1->addWidget(wordName);

	Box4 = new QHBoxLayout(this);
	bOk = new QPushButton(i18n("&OK"),this);
	bOk->setDefault(true);
	bCancel = new QPushButton(i18n("&Cancel"),this);
	Box4->setSpacing(5);
	Box4->addStretch();
	Box4->addWidget(bOk);
	Box4->addWidget(bCancel);

	wordName->setText(Par2->selectedText());

	//mainLayout->addLayout(Box1);
	mainLayout->addWidget(Label1);
	//mainLayout->setSpacing(1);
	mainLayout->addWidget(wordName);
	mainLayout->addLayout(Box4);

	connect(bCancel,SIGNAL(clicked()),this,SLOT(slot_Close()));
	connect(bOk,SIGNAL(clicked()),this,SLOT(slot_Ok()));

}


FindWidget::~FindWidget()
{
}


void FindWidget::slot_Close()
{
	close();
}


void FindWidget::slot_Ok()
{
	Par2->findText(wordName->text());
	close();
}

#include "html_widget.moc"
