/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _MAG_OPTIONS_H
#define _MAG_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    MagDisplayOptionInitiate,
    MagDisplayOptionZoomInButton,
    MagDisplayOptionZoomOutButton,
    MagDisplayOptionNum
} MagDisplayOptions;

typedef void (*magDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, MagDisplayOptions num);

CompOption *magGetDisplayOption (CompDisplay *d, MagDisplayOptions num);

typedef enum
{
    MagScreenOptionMode,
    MagScreenOptionZoomFactor,
    MagScreenOptionSpeed,
    MagScreenOptionTimestep,
    MagScreenOptionKeepScreen,
    MagScreenOptionBoxWidth,
    MagScreenOptionBoxHeight,
    MagScreenOptionBorder,
    MagScreenOptionBoxColor,
    MagScreenOptionOverlay,
    MagScreenOptionMask,
    MagScreenOptionXOffset,
    MagScreenOptionYOffset,
    MagScreenOptionRadius,
    MagScreenOptionNum
} MagScreenOptions;

typedef void (*magScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, MagScreenOptions num);

CompOption *magGetScreenOption (CompScreen *s, MagScreenOptions num);

typedef enum
{
    ModeSimple = 0,
    ModeImageOverlay = 1,
    ModeFisheye = 2,
} MagModeEnum;

CompAction *     magGetInitiate (CompDisplay *d);
void             magSetInitiateInitiate (CompDisplay *d, CompActionCallBackProc init);
void             magSetInitiateTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     magGetInitiateOption (CompDisplay *d);
void             magSetInitiateNotify (CompDisplay *d, magDisplayOptionChangeNotifyProc notify);

CompAction *     magGetZoomInButton (CompDisplay *d);
void             magSetZoomInButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             magSetZoomInButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     magGetZoomInButtonOption (CompDisplay *d);
void             magSetZoomInButtonNotify (CompDisplay *d, magDisplayOptionChangeNotifyProc notify);

CompAction *     magGetZoomOutButton (CompDisplay *d);
void             magSetZoomOutButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             magSetZoomOutButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     magGetZoomOutButtonOption (CompDisplay *d);
void             magSetZoomOutButtonNotify (CompDisplay *d, magDisplayOptionChangeNotifyProc notify);

int              magGetMode (CompScreen *s);
CompOption *     magGetModeOption (CompScreen *s);
void             magSetModeNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

float            magGetZoomFactor (CompScreen *s);
CompOption *     magGetZoomFactorOption (CompScreen *s);
void             magSetZoomFactorNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

float            magGetSpeed (CompScreen *s);
CompOption *     magGetSpeedOption (CompScreen *s);
void             magSetSpeedNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

float            magGetTimestep (CompScreen *s);
CompOption *     magGetTimestepOption (CompScreen *s);
void             magSetTimestepNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

Bool             magGetKeepScreen (CompScreen *s);
CompOption *     magGetKeepScreenOption (CompScreen *s);
void             magSetKeepScreenNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

int              magGetBoxWidth (CompScreen *s);
CompOption *     magGetBoxWidthOption (CompScreen *s);
void             magSetBoxWidthNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

int              magGetBoxHeight (CompScreen *s);
CompOption *     magGetBoxHeightOption (CompScreen *s);
void             magSetBoxHeightNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

int              magGetBorder (CompScreen *s);
CompOption *     magGetBorderOption (CompScreen *s);
void             magSetBorderNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

unsigned short * magGetBoxColor (CompScreen *s);
unsigned short   magGetBoxColorRed (CompScreen *s);
unsigned short   magGetBoxColorGreen (CompScreen *s);
unsigned short   magGetBoxColorBlue (CompScreen *s);
unsigned short   magGetBoxColorAlpha (CompScreen *s);
CompOption *     magGetBoxColorOption (CompScreen *s);
void             magSetBoxColorNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

char *           magGetOverlay (CompScreen *s);
CompOption *     magGetOverlayOption (CompScreen *s);
void             magSetOverlayNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

char *           magGetMask (CompScreen *s);
CompOption *     magGetMaskOption (CompScreen *s);
void             magSetMaskNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

int              magGetXOffset (CompScreen *s);
CompOption *     magGetXOffsetOption (CompScreen *s);
void             magSetXOffsetNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

int              magGetYOffset (CompScreen *s);
CompOption *     magGetYOffsetOption (CompScreen *s);
void             magSetYOffsetNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

int              magGetRadius (CompScreen *s);
CompOption *     magGetRadiusOption (CompScreen *s);
void             magSetRadiusNotify (CompScreen *s, magScreenOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
