/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "opacify_options.h"

static int OpacifyOptionsDisplayPrivateIndex;

static CompMetadata opacifyOptionsMetadata;

static CompPluginVTable *opacifyPluginVTable = NULL;
CompPluginVTable opacifyOptionsVTable;

#define OPACIFY_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, OpacifyOptions, o)
#define OPACIFY_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, OpacifyOptions, o)

typedef struct _OpacifyOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[OpacifyDisplayOptionNum];
    opacifyDisplayOptionChangeNotifyProc notify[OpacifyDisplayOptionNum];
} OpacifyOptionsDisplay;

typedef struct _OpacifyOptionsScreen
{
    CompOption opt[OpacifyScreenOptionNum];
    opacifyScreenOptionChangeNotifyProc notify[OpacifyScreenOptionNum];
} OpacifyOptionsScreen;

CompAction * opacifyGetToggleKey (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[OpacifyDisplayOptionToggleKey].value.action;
}

void opacifySetToggleKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->opt[OpacifyDisplayOptionToggleKey].value.action.initiate = init;
}

void opacifySetToggleKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->opt[OpacifyDisplayOptionToggleKey].value.action.terminate = term;
}

CompOption * opacifyGetToggleKeyOption (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[OpacifyDisplayOptionToggleKey];
}

void opacifySetToggleKeyNotify (CompDisplay *d, opacifyDisplayOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->notify[OpacifyDisplayOptionToggleKey] = notify;
}

Bool opacifyGetToggleReset (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return od->opt[OpacifyDisplayOptionToggleReset].value.b;
}

CompOption * opacifyGetToggleResetOption (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[OpacifyDisplayOptionToggleReset];
}

void opacifySetToggleResetNotify (CompDisplay *d, opacifyDisplayOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->notify[OpacifyDisplayOptionToggleReset] = notify;
}

int opacifyGetTimeout (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return od->opt[OpacifyDisplayOptionTimeout].value.i;
}

CompOption * opacifyGetTimeoutOption (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[OpacifyDisplayOptionTimeout];
}

void opacifySetTimeoutNotify (CompDisplay *d, opacifyDisplayOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->notify[OpacifyDisplayOptionTimeout] = notify;
}

Bool opacifyGetInitToggle (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return od->opt[OpacifyDisplayOptionInitToggle].value.b;
}

CompOption * opacifyGetInitToggleOption (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[OpacifyDisplayOptionInitToggle];
}

void opacifySetInitToggleNotify (CompDisplay *d, opacifyDisplayOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->notify[OpacifyDisplayOptionInitToggle] = notify;
}

Bool opacifyGetOnlyIfBlock (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return os->opt[OpacifyScreenOptionOnlyIfBlock].value.b;
}

CompOption * opacifyGetOnlyIfBlockOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionOnlyIfBlock];
}

void opacifySetOnlyIfBlockNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionOnlyIfBlock] = notify;
}

Bool opacifyGetFocusInstant (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return os->opt[OpacifyScreenOptionFocusInstant].value.b;
}

CompOption * opacifyGetFocusInstantOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionFocusInstant];
}

void opacifySetFocusInstantNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionFocusInstant] = notify;
}

Bool opacifyGetNoDelayChange (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return os->opt[OpacifyScreenOptionNoDelayChange].value.b;
}

CompOption * opacifyGetNoDelayChangeOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionNoDelayChange];
}

void opacifySetNoDelayChangeNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionNoDelayChange] = notify;
}

CompMatch * opacifyGetWindowMatch (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionWindowMatch].value.match;
}

CompOption * opacifyGetWindowMatchOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionWindowMatch];
}

void opacifySetWindowMatchNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionWindowMatch] = notify;
}

int opacifyGetActiveOpacity (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return os->opt[OpacifyScreenOptionActiveOpacity].value.i;
}

CompOption * opacifyGetActiveOpacityOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionActiveOpacity];
}

void opacifySetActiveOpacityNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionActiveOpacity] = notify;
}

int opacifyGetPassiveOpacity (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return os->opt[OpacifyScreenOptionPassiveOpacity].value.i;
}

CompOption * opacifyGetPassiveOpacityOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionPassiveOpacity];
}

void opacifySetPassiveOpacityNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionPassiveOpacity] = notify;
}

CompOption * opacifyGetDisplayOption (CompDisplay *d, OpacifyDisplayOptions num)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * opacifyGetScreenOption (CompScreen *s, OpacifyScreenOptions num)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo opacifyOptionsDisplayOptionInfo[] = {
    { "toggle_key", "key", 0, 0, 0 },
    { "toggle_reset", "bool", 0, 0, 0 },
    { "timeout", "int", "<min>0</min><max>10000</max>", 0, 0 },
    { "init_toggle", "bool", 0, 0, 0 },
};

static Bool opacifyOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, OpacifyDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case OpacifyDisplayOptionToggleKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[OpacifyDisplayOptionToggleKey])
                (*od->notify[OpacifyDisplayOptionToggleKey]) (d, o, OpacifyDisplayOptionToggleKey);
            return TRUE;
        }
        break;
     case OpacifyDisplayOptionToggleReset:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[OpacifyDisplayOptionToggleReset])
                (*od->notify[OpacifyDisplayOptionToggleReset]) (d, o, OpacifyDisplayOptionToggleReset);
            return TRUE;
        }
        break;
     case OpacifyDisplayOptionTimeout:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[OpacifyDisplayOptionTimeout])
                (*od->notify[OpacifyDisplayOptionTimeout]) (d, o, OpacifyDisplayOptionTimeout);
            return TRUE;
        }
        break;
     case OpacifyDisplayOptionInitToggle:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[OpacifyDisplayOptionInitToggle])
                (*od->notify[OpacifyDisplayOptionInitToggle]) (d, o, OpacifyDisplayOptionInitToggle);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * opacifyOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    *count = OpacifyDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo opacifyOptionsScreenOptionInfo[] = {
    { "only_if_block", "bool", 0, 0, 0 },
    { "focus_instant", "bool", 0, 0, 0 },
    { "no_delay_change", "bool", 0, 0, 0 },
    { "window_match", "match", 0, 0, 0 },
    { "active_opacity", "int", "<min>1</min><max>100</max>", 0, 0 },
    { "passive_opacity", "int", "<min>1</min><max>100</max>", 0, 0 },
};

static Bool opacifyOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    OPACIFY_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, OpacifyScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case OpacifyScreenOptionOnlyIfBlock:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionOnlyIfBlock])
                (*os->notify[OpacifyScreenOptionOnlyIfBlock]) (s, o, OpacifyScreenOptionOnlyIfBlock);
            return TRUE;
        }
        break;
     case OpacifyScreenOptionFocusInstant:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionFocusInstant])
                (*os->notify[OpacifyScreenOptionFocusInstant]) (s, o, OpacifyScreenOptionFocusInstant);
            return TRUE;
        }
        break;
     case OpacifyScreenOptionNoDelayChange:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionNoDelayChange])
                (*os->notify[OpacifyScreenOptionNoDelayChange]) (s, o, OpacifyScreenOptionNoDelayChange);
            return TRUE;
        }
        break;
     case OpacifyScreenOptionWindowMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionWindowMatch])
                (*os->notify[OpacifyScreenOptionWindowMatch]) (s, o, OpacifyScreenOptionWindowMatch);
            return TRUE;
        }
        break;
     case OpacifyScreenOptionActiveOpacity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionActiveOpacity])
                (*os->notify[OpacifyScreenOptionActiveOpacity]) (s, o, OpacifyScreenOptionActiveOpacity);
            return TRUE;
        }
        break;
     case OpacifyScreenOptionPassiveOpacity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionPassiveOpacity])
                (*os->notify[OpacifyScreenOptionPassiveOpacity]) (s, o, OpacifyScreenOptionPassiveOpacity);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * opacifyOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    OPACIFY_OPTIONS_SCREEN(s);
    *count = OpacifyScreenOptionNum;
    return os->opt;
}

static Bool opacifyOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    OpacifyOptionsScreen *os;
    
    OPACIFY_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(OpacifyOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &opacifyOptionsMetadata, opacifyOptionsScreenOptionInfo, os->opt, OpacifyScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void opacifyOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, OpacifyScreenOptionNum);

    free (os);
}

static Bool opacifyOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    OpacifyOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(OpacifyOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[OpacifyOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &opacifyOptionsMetadata, opacifyOptionsDisplayOptionInfo, od->opt, OpacifyDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void opacifyOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, OpacifyDisplayOptionNum);

    free (od);
}

static Bool opacifyOptionsInit (CompPlugin *p)
{
    OpacifyOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (OpacifyOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&opacifyOptionsMetadata, "opacify",opacifyOptionsDisplayOptionInfo, OpacifyDisplayOptionNum, opacifyOptionsScreenOptionInfo, OpacifyScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&opacifyOptionsMetadata, "opacify");
    if (opacifyPluginVTable && opacifyPluginVTable->init)
        return opacifyPluginVTable->init (p);
    return TRUE;
}

static void opacifyOptionsFini (CompPlugin *p)
{
    if (opacifyPluginVTable && opacifyPluginVTable->fini)
        opacifyPluginVTable->fini (p);

    if (OpacifyOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (OpacifyOptionsDisplayPrivateIndex);

    compFiniMetadata (&opacifyOptionsMetadata);
}

static CompBool opacifyOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) opacifyOptionsInitDisplay,
        (InitPluginObjectProc) opacifyOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void opacifyOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) opacifyOptionsFiniDisplay,
        (FiniPluginObjectProc) opacifyOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool opacifyOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = opacifyOptionsInitObject (p, o);
    if (opacifyPluginVTable->initObject)
        rv &= opacifyPluginVTable->initObject (p, o);
    return rv;
}

static void opacifyOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (opacifyPluginVTable->finiObject)
        opacifyPluginVTable->finiObject (p, o);
    opacifyOptionsFiniObject (p, o);
}

static CompOption * opacifyOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) opacifyOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) opacifyOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool opacifyOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) opacifyOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) opacifyOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
opacifyOptionsGetMetadata (CompPlugin *plugin)
{
    return &opacifyOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!opacifyPluginVTable)
    {
        opacifyPluginVTable = getCompPluginInfo ();
        memcpy(&opacifyOptionsVTable, opacifyPluginVTable, sizeof(CompPluginVTable));
        opacifyOptionsVTable.getMetadata = opacifyOptionsGetMetadata;
        opacifyOptionsVTable.init = opacifyOptionsInit;
        opacifyOptionsVTable.fini = opacifyOptionsFini;
        opacifyOptionsVTable.initObject = opacifyOptionsInitObjectWrapper;
        opacifyOptionsVTable.finiObject = opacifyOptionsFiniObjectWrapper;
        opacifyOptionsVTable.getObjectOptions = opacifyOptionsGetObjectOptions;
	opacifyOptionsVTable.setObjectOption = opacifyOptionsSetObjectOption;
	
    }
    return &opacifyOptionsVTable;
}

