/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _RING_OPTIONS_H
#define _RING_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    RingDisplayOptionNextKey,
    RingDisplayOptionNextButton,
    RingDisplayOptionPrevKey,
    RingDisplayOptionPrevButton,
    RingDisplayOptionNextAllKey,
    RingDisplayOptionNextAllButton,
    RingDisplayOptionPrevAllKey,
    RingDisplayOptionPrevAllButton,
    RingDisplayOptionNextGroupKey,
    RingDisplayOptionNextGroupButton,
    RingDisplayOptionPrevGroupKey,
    RingDisplayOptionPrevGroupButton,
    RingDisplayOptionNum
} RingDisplayOptions;

typedef void (*ringDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, RingDisplayOptions num);

CompOption *ringGetDisplayOption (CompDisplay *d, RingDisplayOptions num);

typedef enum
{
    RingScreenOptionSpeed,
    RingScreenOptionTimestep,
    RingScreenOptionInactiveOpacity,
    RingScreenOptionWindowMatch,
    RingScreenOptionOverlayIcon,
    RingScreenOptionDarkenBack,
    RingScreenOptionMinimized,
    RingScreenOptionSelectWithMouse,
    RingScreenOptionRingClockwise,
    RingScreenOptionRingWidth,
    RingScreenOptionRingHeight,
    RingScreenOptionThumbWidth,
    RingScreenOptionThumbHeight,
    RingScreenOptionMinBrightness,
    RingScreenOptionMinScale,
    RingScreenOptionWindowTitle,
    RingScreenOptionTitleFontBold,
    RingScreenOptionTitleFontSize,
    RingScreenOptionTitleBackColor,
    RingScreenOptionTitleFontColor,
    RingScreenOptionTitleTextPlacement,
    RingScreenOptionNum
} RingScreenOptions;

typedef void (*ringScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, RingScreenOptions num);

CompOption *ringGetScreenOption (CompScreen *s, RingScreenOptions num);

typedef enum
{
    OverlayIconNone = 0,
    OverlayIconEmblem = 1,
    OverlayIconBig = 2,
} RingOverlayIconEnum;

typedef enum
{
    TitleTextPlacementCenteredOnScreen = 0,
    TitleTextPlacementAboveRing = 1,
    TitleTextPlacementBelowRing = 2,
} RingTitleTextPlacementEnum;

CompAction *     ringGetNextKey (CompDisplay *d);
void             ringSetNextKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetNextKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetNextKeyOption (CompDisplay *d);
void             ringSetNextKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetNextButton (CompDisplay *d);
void             ringSetNextButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetNextButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetNextButtonOption (CompDisplay *d);
void             ringSetNextButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetPrevKey (CompDisplay *d);
void             ringSetPrevKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetPrevKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetPrevKeyOption (CompDisplay *d);
void             ringSetPrevKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetPrevButton (CompDisplay *d);
void             ringSetPrevButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetPrevButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetPrevButtonOption (CompDisplay *d);
void             ringSetPrevButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetNextAllKey (CompDisplay *d);
void             ringSetNextAllKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetNextAllKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetNextAllKeyOption (CompDisplay *d);
void             ringSetNextAllKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetNextAllButton (CompDisplay *d);
void             ringSetNextAllButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetNextAllButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetNextAllButtonOption (CompDisplay *d);
void             ringSetNextAllButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetPrevAllKey (CompDisplay *d);
void             ringSetPrevAllKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetPrevAllKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetPrevAllKeyOption (CompDisplay *d);
void             ringSetPrevAllKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetPrevAllButton (CompDisplay *d);
void             ringSetPrevAllButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetPrevAllButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetPrevAllButtonOption (CompDisplay *d);
void             ringSetPrevAllButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetNextGroupKey (CompDisplay *d);
void             ringSetNextGroupKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetNextGroupKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetNextGroupKeyOption (CompDisplay *d);
void             ringSetNextGroupKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetNextGroupButton (CompDisplay *d);
void             ringSetNextGroupButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetNextGroupButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetNextGroupButtonOption (CompDisplay *d);
void             ringSetNextGroupButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetPrevGroupKey (CompDisplay *d);
void             ringSetPrevGroupKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetPrevGroupKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetPrevGroupKeyOption (CompDisplay *d);
void             ringSetPrevGroupKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

CompAction *     ringGetPrevGroupButton (CompDisplay *d);
void             ringSetPrevGroupButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             ringSetPrevGroupButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     ringGetPrevGroupButtonOption (CompDisplay *d);
void             ringSetPrevGroupButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify);

float            ringGetSpeed (CompScreen *s);
CompOption *     ringGetSpeedOption (CompScreen *s);
void             ringSetSpeedNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

float            ringGetTimestep (CompScreen *s);
CompOption *     ringGetTimestepOption (CompScreen *s);
void             ringSetTimestepNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

int              ringGetInactiveOpacity (CompScreen *s);
CompOption *     ringGetInactiveOpacityOption (CompScreen *s);
void             ringSetInactiveOpacityNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

CompMatch *      ringGetWindowMatch (CompScreen *s);
CompOption *     ringGetWindowMatchOption (CompScreen *s);
void             ringSetWindowMatchNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

int              ringGetOverlayIcon (CompScreen *s);
CompOption *     ringGetOverlayIconOption (CompScreen *s);
void             ringSetOverlayIconNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

Bool             ringGetDarkenBack (CompScreen *s);
CompOption *     ringGetDarkenBackOption (CompScreen *s);
void             ringSetDarkenBackNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

Bool             ringGetMinimized (CompScreen *s);
CompOption *     ringGetMinimizedOption (CompScreen *s);
void             ringSetMinimizedNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

Bool             ringGetSelectWithMouse (CompScreen *s);
CompOption *     ringGetSelectWithMouseOption (CompScreen *s);
void             ringSetSelectWithMouseNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

Bool             ringGetRingClockwise (CompScreen *s);
CompOption *     ringGetRingClockwiseOption (CompScreen *s);
void             ringSetRingClockwiseNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

int              ringGetRingWidth (CompScreen *s);
CompOption *     ringGetRingWidthOption (CompScreen *s);
void             ringSetRingWidthNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

int              ringGetRingHeight (CompScreen *s);
CompOption *     ringGetRingHeightOption (CompScreen *s);
void             ringSetRingHeightNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

int              ringGetThumbWidth (CompScreen *s);
CompOption *     ringGetThumbWidthOption (CompScreen *s);
void             ringSetThumbWidthNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

int              ringGetThumbHeight (CompScreen *s);
CompOption *     ringGetThumbHeightOption (CompScreen *s);
void             ringSetThumbHeightNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

float            ringGetMinBrightness (CompScreen *s);
CompOption *     ringGetMinBrightnessOption (CompScreen *s);
void             ringSetMinBrightnessNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

float            ringGetMinScale (CompScreen *s);
CompOption *     ringGetMinScaleOption (CompScreen *s);
void             ringSetMinScaleNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

Bool             ringGetWindowTitle (CompScreen *s);
CompOption *     ringGetWindowTitleOption (CompScreen *s);
void             ringSetWindowTitleNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

Bool             ringGetTitleFontBold (CompScreen *s);
CompOption *     ringGetTitleFontBoldOption (CompScreen *s);
void             ringSetTitleFontBoldNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

int              ringGetTitleFontSize (CompScreen *s);
CompOption *     ringGetTitleFontSizeOption (CompScreen *s);
void             ringSetTitleFontSizeNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

unsigned short * ringGetTitleBackColor (CompScreen *s);
unsigned short   ringGetTitleBackColorRed (CompScreen *s);
unsigned short   ringGetTitleBackColorGreen (CompScreen *s);
unsigned short   ringGetTitleBackColorBlue (CompScreen *s);
unsigned short   ringGetTitleBackColorAlpha (CompScreen *s);
CompOption *     ringGetTitleBackColorOption (CompScreen *s);
void             ringSetTitleBackColorNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

unsigned short * ringGetTitleFontColor (CompScreen *s);
unsigned short   ringGetTitleFontColorRed (CompScreen *s);
unsigned short   ringGetTitleFontColorGreen (CompScreen *s);
unsigned short   ringGetTitleFontColorBlue (CompScreen *s);
unsigned short   ringGetTitleFontColorAlpha (CompScreen *s);
CompOption *     ringGetTitleFontColorOption (CompScreen *s);
void             ringSetTitleFontColorNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

int              ringGetTitleTextPlacement (CompScreen *s);
CompOption *     ringGetTitleTextPlacementOption (CompScreen *s);
void             ringSetTitleTextPlacementNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
