/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "scaleaddon_options.h"

static int ScaleaddonOptionsDisplayPrivateIndex;

static CompMetadata scaleaddonOptionsMetadata;

static CompPluginVTable *scaleaddonPluginVTable = NULL;
CompPluginVTable scaleaddonOptionsVTable;

#define SCALEADDON_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, ScaleaddonOptions, o)
#define SCALEADDON_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, ScaleaddonOptions, o)

typedef struct _ScaleaddonOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[ScaleaddonDisplayOptionNum];
    scaleaddonDisplayOptionChangeNotifyProc notify[ScaleaddonDisplayOptionNum];
} ScaleaddonOptionsDisplay;

typedef struct _ScaleaddonOptionsScreen
{
    CompOption opt[ScaleaddonScreenOptionNum];
    scaleaddonScreenOptionChangeNotifyProc notify[ScaleaddonScreenOptionNum];
} ScaleaddonOptionsScreen;

CompAction * scaleaddonGetCloseKey (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionCloseKey].value.action;
}

void scaleaddonSetCloseKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionCloseKey].value.action.initiate = init;
}

void scaleaddonSetCloseKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionCloseKey].value.action.terminate = term;
}

CompOption * scaleaddonGetCloseKeyOption (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionCloseKey];
}

void scaleaddonSetCloseKeyNotify (CompDisplay *d, scaleaddonDisplayOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->notify[ScaleaddonDisplayOptionCloseKey] = notify;
}

CompAction * scaleaddonGetCloseButton (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionCloseButton].value.action;
}

void scaleaddonSetCloseButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionCloseButton].value.action.initiate = init;
}

void scaleaddonSetCloseButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionCloseButton].value.action.terminate = term;
}

CompOption * scaleaddonGetCloseButtonOption (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionCloseButton];
}

void scaleaddonSetCloseButtonNotify (CompDisplay *d, scaleaddonDisplayOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->notify[ScaleaddonDisplayOptionCloseButton] = notify;
}

CompAction * scaleaddonGetPullKey (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionPullKey].value.action;
}

void scaleaddonSetPullKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionPullKey].value.action.initiate = init;
}

void scaleaddonSetPullKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionPullKey].value.action.terminate = term;
}

CompOption * scaleaddonGetPullKeyOption (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionPullKey];
}

void scaleaddonSetPullKeyNotify (CompDisplay *d, scaleaddonDisplayOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->notify[ScaleaddonDisplayOptionPullKey] = notify;
}

CompAction * scaleaddonGetPullButton (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionPullButton].value.action;
}

void scaleaddonSetPullButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionPullButton].value.action.initiate = init;
}

void scaleaddonSetPullButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionPullButton].value.action.terminate = term;
}

CompOption * scaleaddonGetPullButtonOption (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionPullButton];
}

void scaleaddonSetPullButtonNotify (CompDisplay *d, scaleaddonDisplayOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->notify[ScaleaddonDisplayOptionPullButton] = notify;
}

CompAction * scaleaddonGetZoomKey (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionZoomKey].value.action;
}

void scaleaddonSetZoomKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionZoomKey].value.action.initiate = init;
}

void scaleaddonSetZoomKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionZoomKey].value.action.terminate = term;
}

CompOption * scaleaddonGetZoomKeyOption (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionZoomKey];
}

void scaleaddonSetZoomKeyNotify (CompDisplay *d, scaleaddonDisplayOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->notify[ScaleaddonDisplayOptionZoomKey] = notify;
}

CompAction * scaleaddonGetZoomButton (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionZoomButton].value.action;
}

void scaleaddonSetZoomButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionZoomButton].value.action.initiate = init;
}

void scaleaddonSetZoomButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->opt[ScaleaddonDisplayOptionZoomButton].value.action.terminate = term;
}

CompOption * scaleaddonGetZoomButtonOption (CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[ScaleaddonDisplayOptionZoomButton];
}

void scaleaddonSetZoomButtonNotify (CompDisplay *d, scaleaddonDisplayOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    od->notify[ScaleaddonDisplayOptionZoomButton] = notify;
}

int scaleaddonGetWindowTitle (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionWindowTitle].value.i;
}

CompOption * scaleaddonGetWindowTitleOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionWindowTitle];
}

void scaleaddonSetWindowTitleNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionWindowTitle] = notify;
}

Bool scaleaddonGetTitleBold (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionTitleBold].value.b;
}

CompOption * scaleaddonGetTitleBoldOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionTitleBold];
}

void scaleaddonSetTitleBoldNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionTitleBold] = notify;
}

int scaleaddonGetTitleSize (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionTitleSize].value.i;
}

CompOption * scaleaddonGetTitleSizeOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionTitleSize];
}

void scaleaddonSetTitleSizeNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionTitleSize] = notify;
}

int scaleaddonGetBorderSize (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionBorderSize].value.i;
}

CompOption * scaleaddonGetBorderSizeOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionBorderSize];
}

void scaleaddonSetBorderSizeNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionBorderSize] = notify;
}

unsigned short * scaleaddonGetFontColor (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionFontColor].value.c;
}

unsigned short scaleaddonGetFontColorRed (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionFontColor].value.c[0];
}

unsigned short scaleaddonGetFontColorGreen (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionFontColor].value.c[1];
}

unsigned short scaleaddonGetFontColorBlue (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionFontColor].value.c[2];
}

unsigned short scaleaddonGetFontColorAlpha (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionFontColor].value.c[3];
}

CompOption * scaleaddonGetFontColorOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionFontColor];
}

void scaleaddonSetFontColorNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionFontColor] = notify;
}

unsigned short * scaleaddonGetBackColor (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionBackColor].value.c;
}

unsigned short scaleaddonGetBackColorRed (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionBackColor].value.c[0];
}

unsigned short scaleaddonGetBackColorGreen (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionBackColor].value.c[1];
}

unsigned short scaleaddonGetBackColorBlue (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionBackColor].value.c[2];
}

unsigned short scaleaddonGetBackColorAlpha (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionBackColor].value.c[3];
}

CompOption * scaleaddonGetBackColorOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionBackColor];
}

void scaleaddonSetBackColorNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionBackColor] = notify;
}

Bool scaleaddonGetWindowHighlight (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionWindowHighlight].value.b;
}

CompOption * scaleaddonGetWindowHighlightOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionWindowHighlight];
}

void scaleaddonSetWindowHighlightNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionWindowHighlight] = notify;
}

unsigned short * scaleaddonGetHighlightColor (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionHighlightColor].value.c;
}

unsigned short scaleaddonGetHighlightColorRed (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionHighlightColor].value.c[0];
}

unsigned short scaleaddonGetHighlightColorGreen (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionHighlightColor].value.c[1];
}

unsigned short scaleaddonGetHighlightColorBlue (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionHighlightColor].value.c[2];
}

unsigned short scaleaddonGetHighlightColorAlpha (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionHighlightColor].value.c[3];
}

CompOption * scaleaddonGetHighlightColorOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionHighlightColor];
}

void scaleaddonSetHighlightColorNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionHighlightColor] = notify;
}

int scaleaddonGetLayoutMode (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionLayoutMode].value.i;
}

CompOption * scaleaddonGetLayoutModeOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionLayoutMode];
}

void scaleaddonSetLayoutModeNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionLayoutMode] = notify;
}

Bool scaleaddonGetConstrainPullToScreen (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionConstrainPullToScreen].value.b;
}

CompOption * scaleaddonGetConstrainPullToScreenOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionConstrainPullToScreen];
}

void scaleaddonSetConstrainPullToScreenNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionConstrainPullToScreen] = notify;
}

Bool scaleaddonGetExitAfterPull (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return os->opt[ScaleaddonScreenOptionExitAfterPull].value.b;
}

CompOption * scaleaddonGetExitAfterPullOption (CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[ScaleaddonScreenOptionExitAfterPull];
}

void scaleaddonSetExitAfterPullNotify (CompScreen *s, scaleaddonScreenOptionChangeNotifyProc notify)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    os->notify[ScaleaddonScreenOptionExitAfterPull] = notify;
}

CompOption * scaleaddonGetDisplayOption (CompDisplay *d, ScaleaddonDisplayOptions num)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * scaleaddonGetScreenOption (CompScreen *s, ScaleaddonScreenOptions num)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo scaleaddonOptionsDisplayOptionInfo[] = {
    { "close_key", "key", 0, 0, 0 },
    { "close_button", "button", 0, 0, 0 },
    { "pull_key", "key", 0, 0, 0 },
    { "pull_button", "button", 0, 0, 0 },
    { "zoom_key", "key", 0, 0, 0 },
    { "zoom_button", "button", 0, 0, 0 },
};

static Bool scaleaddonOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, ScaleaddonDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ScaleaddonDisplayOptionCloseKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ScaleaddonDisplayOptionCloseKey])
                (*od->notify[ScaleaddonDisplayOptionCloseKey]) (d, o, ScaleaddonDisplayOptionCloseKey);
            return TRUE;
        }
        break;
     case ScaleaddonDisplayOptionCloseButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ScaleaddonDisplayOptionCloseButton])
                (*od->notify[ScaleaddonDisplayOptionCloseButton]) (d, o, ScaleaddonDisplayOptionCloseButton);
            return TRUE;
        }
        break;
     case ScaleaddonDisplayOptionPullKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ScaleaddonDisplayOptionPullKey])
                (*od->notify[ScaleaddonDisplayOptionPullKey]) (d, o, ScaleaddonDisplayOptionPullKey);
            return TRUE;
        }
        break;
     case ScaleaddonDisplayOptionPullButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ScaleaddonDisplayOptionPullButton])
                (*od->notify[ScaleaddonDisplayOptionPullButton]) (d, o, ScaleaddonDisplayOptionPullButton);
            return TRUE;
        }
        break;
     case ScaleaddonDisplayOptionZoomKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ScaleaddonDisplayOptionZoomKey])
                (*od->notify[ScaleaddonDisplayOptionZoomKey]) (d, o, ScaleaddonDisplayOptionZoomKey);
            return TRUE;
        }
        break;
     case ScaleaddonDisplayOptionZoomButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ScaleaddonDisplayOptionZoomButton])
                (*od->notify[ScaleaddonDisplayOptionZoomButton]) (d, o, ScaleaddonDisplayOptionZoomButton);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * scaleaddonOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    SCALEADDON_OPTIONS_DISPLAY(d);
    *count = ScaleaddonDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo scaleaddonOptionsScreenOptionInfo[] = {
    { "window_title", "int", "<min>0</min><max>2</max>", 0, 0 },
    { "title_bold", "bool", 0, 0, 0 },
    { "title_size", "int", "<min>6</min><max>48</max>", 0, 0 },
    { "border_size", "int", "<min>1</min><max>20</max>", 0, 0 },
    { "font_color", "color", 0, 0, 0 },
    { "back_color", "color", 0, 0, 0 },
    { "window_highlight", "bool", 0, 0, 0 },
    { "highlight_color", "color", 0, 0, 0 },
    { "layout_mode", "int", "<min>0</min><max>0</max>", 0, 0 },
    { "constrain_pull_to_screen", "bool", 0, 0, 0 },
    { "exit_after_pull", "bool", 0, 0, 0 },
};

static Bool scaleaddonOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, ScaleaddonScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ScaleaddonScreenOptionWindowTitle:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionWindowTitle])
                (*os->notify[ScaleaddonScreenOptionWindowTitle]) (s, o, ScaleaddonScreenOptionWindowTitle);
            return TRUE;
        }
        break;
     case ScaleaddonScreenOptionTitleBold:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionTitleBold])
                (*os->notify[ScaleaddonScreenOptionTitleBold]) (s, o, ScaleaddonScreenOptionTitleBold);
            return TRUE;
        }
        break;
     case ScaleaddonScreenOptionTitleSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionTitleSize])
                (*os->notify[ScaleaddonScreenOptionTitleSize]) (s, o, ScaleaddonScreenOptionTitleSize);
            return TRUE;
        }
        break;
     case ScaleaddonScreenOptionBorderSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionBorderSize])
                (*os->notify[ScaleaddonScreenOptionBorderSize]) (s, o, ScaleaddonScreenOptionBorderSize);
            return TRUE;
        }
        break;
     case ScaleaddonScreenOptionFontColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionFontColor])
                (*os->notify[ScaleaddonScreenOptionFontColor]) (s, o, ScaleaddonScreenOptionFontColor);
            return TRUE;
        }
        break;
     case ScaleaddonScreenOptionBackColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionBackColor])
                (*os->notify[ScaleaddonScreenOptionBackColor]) (s, o, ScaleaddonScreenOptionBackColor);
            return TRUE;
        }
        break;
     case ScaleaddonScreenOptionWindowHighlight:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionWindowHighlight])
                (*os->notify[ScaleaddonScreenOptionWindowHighlight]) (s, o, ScaleaddonScreenOptionWindowHighlight);
            return TRUE;
        }
        break;
     case ScaleaddonScreenOptionHighlightColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionHighlightColor])
                (*os->notify[ScaleaddonScreenOptionHighlightColor]) (s, o, ScaleaddonScreenOptionHighlightColor);
            return TRUE;
        }
        break;
     case ScaleaddonScreenOptionLayoutMode:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionLayoutMode])
                (*os->notify[ScaleaddonScreenOptionLayoutMode]) (s, o, ScaleaddonScreenOptionLayoutMode);
            return TRUE;
        }
        break;
     case ScaleaddonScreenOptionConstrainPullToScreen:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionConstrainPullToScreen])
                (*os->notify[ScaleaddonScreenOptionConstrainPullToScreen]) (s, o, ScaleaddonScreenOptionConstrainPullToScreen);
            return TRUE;
        }
        break;
     case ScaleaddonScreenOptionExitAfterPull:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScaleaddonScreenOptionExitAfterPull])
                (*os->notify[ScaleaddonScreenOptionExitAfterPull]) (s, o, ScaleaddonScreenOptionExitAfterPull);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * scaleaddonOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    SCALEADDON_OPTIONS_SCREEN(s);
    *count = ScaleaddonScreenOptionNum;
    return os->opt;
}

static Bool scaleaddonOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ScaleaddonOptionsScreen *os;
    
    SCALEADDON_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ScaleaddonOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &scaleaddonOptionsMetadata, scaleaddonOptionsScreenOptionInfo, os->opt, ScaleaddonScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void scaleaddonOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    SCALEADDON_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, ScaleaddonScreenOptionNum);

    free (os);
}

static Bool scaleaddonOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ScaleaddonOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ScaleaddonOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[ScaleaddonOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &scaleaddonOptionsMetadata, scaleaddonOptionsDisplayOptionInfo, od->opt, ScaleaddonDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void scaleaddonOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    SCALEADDON_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, ScaleaddonDisplayOptionNum);

    free (od);
}

static Bool scaleaddonOptionsInit (CompPlugin *p)
{
    ScaleaddonOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (ScaleaddonOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&scaleaddonOptionsMetadata, "scaleaddon",scaleaddonOptionsDisplayOptionInfo, ScaleaddonDisplayOptionNum, scaleaddonOptionsScreenOptionInfo, ScaleaddonScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&scaleaddonOptionsMetadata, "scaleaddon");
    if (scaleaddonPluginVTable && scaleaddonPluginVTable->init)
        return scaleaddonPluginVTable->init (p);
    return TRUE;
}

static void scaleaddonOptionsFini (CompPlugin *p)
{
    if (scaleaddonPluginVTable && scaleaddonPluginVTable->fini)
        scaleaddonPluginVTable->fini (p);

    if (ScaleaddonOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (ScaleaddonOptionsDisplayPrivateIndex);

    compFiniMetadata (&scaleaddonOptionsMetadata);
}

static CompBool scaleaddonOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) scaleaddonOptionsInitDisplay,
        (InitPluginObjectProc) scaleaddonOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void scaleaddonOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) scaleaddonOptionsFiniDisplay,
        (FiniPluginObjectProc) scaleaddonOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool scaleaddonOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = scaleaddonOptionsInitObject (p, o);
    if (scaleaddonPluginVTable->initObject)
        rv &= scaleaddonPluginVTable->initObject (p, o);
    return rv;
}

static void scaleaddonOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (scaleaddonPluginVTable->finiObject)
        scaleaddonPluginVTable->finiObject (p, o);
    scaleaddonOptionsFiniObject (p, o);
}

static CompOption * scaleaddonOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) scaleaddonOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) scaleaddonOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool scaleaddonOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) scaleaddonOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) scaleaddonOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
scaleaddonOptionsGetMetadata (CompPlugin *plugin)
{
    return &scaleaddonOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!scaleaddonPluginVTable)
    {
        scaleaddonPluginVTable = getCompPluginInfo ();
        memcpy(&scaleaddonOptionsVTable, scaleaddonPluginVTable, sizeof(CompPluginVTable));
        scaleaddonOptionsVTable.getMetadata = scaleaddonOptionsGetMetadata;
        scaleaddonOptionsVTable.init = scaleaddonOptionsInit;
        scaleaddonOptionsVTable.fini = scaleaddonOptionsFini;
        scaleaddonOptionsVTable.initObject = scaleaddonOptionsInitObjectWrapper;
        scaleaddonOptionsVTable.finiObject = scaleaddonOptionsFiniObjectWrapper;
        scaleaddonOptionsVTable.getObjectOptions = scaleaddonOptionsGetObjectOptions;
	scaleaddonOptionsVTable.setObjectOption = scaleaddonOptionsSetObjectOption;
	
    }
    return &scaleaddonOptionsVTable;
}

