/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimenum.h 865 2009-03-31 07:03:38Z takahiko $
 */

#ifndef __DKIM_ENUM_H__
#define __DKIM_ENUM_H__

typedef enum _dkim_signalg {
    DKIM_SIGNALG_NULL = 0,
    DKIM_SIGNALG_RSA_SHA1,
    DKIM_SIGNALG_RSA_SHA256,
    DKIM_SIGNALG_ANY = 0xffffffff,
} dkim_signalg_t;

typedef enum _dkim_canonalg {
    DKIM_CANONALG_NULL = 0,
    DKIM_CANONALG_SIMPLE,
    DKIM_CANONALG_RELAXED,
    DKIM_CANONALG_NOWSP,    // obsolete
    DKIM_CANONALG_ANY = 0xffffffff,
} dkim_canonalg_t;

typedef enum _dkim_pubkeyalg {
    DKIM_PUBKEYALG_NULL = 0,
    DKIM_PUBKEYALG_RSA,
    DKIM_PUBKEYALG_ANY = 0xffffffff,
} dkim_pubkeyalg_t;

typedef enum _dkim_digestalg {
    DKIM_DIGESTALG_NULL = 0x00,
    DKIM_DIGESTALG_SHA1 = 0x01,
    DKIM_DIGESTALG_SHA256 = 0x02,
    DKIM_DIGESTALG_ANY = 0xffffffff,
} dkim_digestalg_t;

typedef enum _dkim_srvtype {
    DKIM_SRVTYPE_NULL = 0x00,
    DKIM_SRVTYPE_EMAIL = 0x01,
    DKIM_SRVTYPE_ANY = 0xffffffff,
} dkim_srvtype_t;

typedef enum _dkim_keyflag {
    DKIM_KEYFLAG_NULL = 0x00,
    DKIM_KEYFLAG_TESTING = 0x01,
    DKIM_KEYFLAG_PROHIBIT_SUBDOMAIN = 0x02,
} dkim_keyflag_t;

typedef enum _dkim_keyretr {
    DKIM_KEYRETR_NULL = 0,
    DKIM_KEYRETR_DNS_TXT,
} dkim_keyretr_t;

typedef enum _dkim_adsp_signpractice {
    DKIM_ADSP_SIGNPRACTICE_NULL = 0,
    DKIM_ADSP_SIGNPRACTICE_UNKNOWN,
    DKIM_ADSP_SIGNPRACTICE_ALL,
    DKIM_ADSP_SIGNPRACTICE_DISCARDABLE,
} dkim_adsp_signpractice_t;

extern dkim_canonalg_t DkimEnum_lookupCanonAlgByName(const char *keyword);
extern dkim_canonalg_t DkimEnum_lookupCanonAlgByNameSlice(const char *head, const char *tail);
extern const char *DkimEnum_lookupCanonAlgByValue(dkim_canonalg_t val);

extern dkim_pubkeyalg_t DkimEnum_lookupPubkeyAlgByName(const char *keyword);
extern dkim_pubkeyalg_t DkimEnum_lookupPubkeyAlgByNameSlice(const char *head, const char *tail);
extern const char *DkimEnum_lookupPubkeyAlgByValue(dkim_pubkeyalg_t val);

extern dkim_digestalg_t DkimEnum_lookupDigestAlgByName(const char *keyword);
extern dkim_digestalg_t DkimEnum_lookupDigestAlgByNameSlice(const char *head, const char *tail);
extern const char *DkimEnum_lookupDigestAlgByValue(dkim_digestalg_t val);

extern dkim_srvtype_t DkimEnum_lookupServiceTypeByName(const char *keyword);
extern dkim_srvtype_t DkimEnum_lookupServiceTypeByNameSlice(const char *head, const char *tail);
extern const char *DkimEnum_lookupServiceTypeByValue(dkim_srvtype_t val);

extern dkim_keyflag_t DkimEnum_lookupKeyFlagByName(const char *keyword);
extern dkim_keyflag_t DkimEnum_lookupKeyFlagByNameSlice(const char *head, const char *tail);
extern const char *DkimEnum_lookupKeyFlagByValue(dkim_keyflag_t val);

extern dkim_keyretr_t DkimEnum_lookupKeyRetrByName(const char *keyword);
extern dkim_keyretr_t DkimEnum_lookupKeyRetrByNameSlice(const char *head, const char *tail);
extern const char *DkimEnum_lookupKeyRetrByValue(dkim_keyretr_t val);

extern dkim_adsp_signpractice_t DkimEnum_lookupSignPracticeByName(const char *keyword);
extern dkim_adsp_signpractice_t DkimEnum_lookupSignPracticeByNameSlice(const char *head,
                                                                       const char *tail);
extern const char *DkimEnum_lookupSignPracticeByValue(dkim_adsp_signpractice_t val);

#endif /* __DKIM_ENUM_H__ */
