/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimparse.h 653 2009-02-28 20:35:27Z takahiko $
 */

#ifndef __DKIM_PARSE_H__
#define __DKIM_PARSE_H__

#include "xbuffer.h"
#include "dkim.h"
#include "dkimpolicy.h"

extern XBuffer *DkimParse_decodeBase64(const DkimPolicy *policy, const char *head, const char *tail,
                                       const char **nextp, dkim_stat_t *dstat);
extern XBuffer *DkimParse_encodeBase64(const DkimPolicy *policy, const void *s, size_t size,
                                       dkim_stat_t *dstat);
extern XBuffer *DkimParse_encodeLocalpartToDkimQuotedPrintable(const DkimPolicy *policy,
                                                               const void *s, size_t size,
                                                               dkim_stat_t *dstat);
extern long long DkimParse_longlong(const char *head, const char *tail, unsigned int digits,
                                    const char **nextp);
extern dkim_stat_t DkimParse_tflag(const DkimPolicy *policy, const char *head, const char *tail,
                                   const char **nextp, const dkim_keyflag_t accept_flag_mask,
                                   dkim_keyflag_t *tflag);

#endif /* __DKIM_PARSE_H__ */
