/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimverifypolicy.c 702 2009-03-08 06:11:35Z takahiko $
 */

#include "rcsid.h"
RCSID("$Id: dkimverifypolicy.c 702 2009-03-08 06:11:35Z takahiko $");

#include <sys/types.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <openssl/evp.h>

#include "dkimlogger.h"
#include "dkim.h"
#include "dkimenum.h"
#include "dkimverifypolicy.h"

/**
 * DkimVerifyPolicy オブジェクトの構築
 * @return 空の DkimVerifyPolicy オブジェクト
 */
DkimVerifyPolicy *
DkimVerifyPolicy_new(void)
{
    DkimVerifyPolicy *self = (DkimVerifyPolicy *) malloc(sizeof(DkimVerifyPolicy));
    if (NULL == self) {
        return NULL;
    }   // end if
    memset(self, 0, sizeof(DkimVerifyPolicy));

    // 初期化
    DkimPolicy_init((DkimPolicy *) self);

    return self;
}   // end function : DkimVerifyPolicy_new

/**
 * DkimVerifyPolicy オブジェクトの解放
 * @param self 解放する DkimVerifyPolicy オブジェクト
 */
void
DkimVerifyPolicy_free(DkimVerifyPolicy *self)
{
    assert(NULL != self);
    DkimPolicy_cleanup((DkimPolicy *) self);
    free(self);
}   // end function : DkimVerifyPolicy_free

/**
 * 同時に検証する署名ヘッダの最大数を設定する.
 * ここで指定した値を越える署名ヘッダが一通のメッセージに含まれていた場合,
 * それらの署名ヘッダは無視される.
 * @param verifycnt 同時に検証する署名ヘッダの数
 */
void
DkimVerifyPolicy_setSignHeaderLimit(DkimVerifyPolicy *self, size_t header_limit)
{
    assert(NULL != self);
    self->sign_header_limit = header_limit;
}   // end function : DkimVerifyPolicy_setSignHeaderLimit

/**
 * 期限切れの署名を受け入れる.
 * @param reject 期限切れの署名を受け入れる場合は true, 失敗扱いにする場合は false.
 */
void
DkimVerifyPolicy_acceptExpiredSignature(DkimVerifyPolicy *self, bool accept)
{
    assert(NULL != self);
    self->accept_expired_signature = accept;
}   // end function : DkimVerifyPolicy_acceptExpiredSignature
