dnl AC_C_ALWAYS_INLINE
dnl Define inline to something appropriate, including the new always_inline
dnl attribute from gcc 3.1
dnl Based on code by Michel LESPINASSE <walken@zoy.org>
dnl This variant leaves inline unchanged and defines always_inline.
AC_DEFUN([AC_C_ALWAYS_INLINE],
    [AC_C_INLINE
    if test x"$GCC" = x"yes" -a x"$ac_cv_c_inline" = x"inline"; then
	AC_MSG_CHECKING([for always_inline])
	dnl We know that GCC 3.3
	if expr match "`"$CC" -dumpversion`" '3\.4\.' >/dev/null; then
	    ac_cv_always_inline='yes, but gxine uses a construct on which GCC 3.4 fails'
	else
	    SAVE_CFLAGS="$CFLAGS"
	    CFLAGS="$CFLAGS -Wall -Werror"
	    AC_TRY_COMPILE([],[inline __attribute__ ((__always_inline__)) void f (void);],
		[ac_cv_always_inline=yes],[ac_cv_always_inline=no])
	    CFLAGS="$SAVE_CFLAGS"
	fi
	AC_MSG_RESULT([$ac_cv_always_inline])
	if test x"$ac_cv_always_inline" = x"yes"; then
	    always_inline='inline __attribute__ ((__always_inline__))'
	else
	    always_inline=inline
	fi
    else
	always_inline=''
    fi
    AC_DEFINE_UNQUOTED([always_inline],[$always_inline],[use to force inlining (if possible)])
    ])

AC_DEFUN([PKG_CHECK_MODULE_ATLEAST],
    [PKG_CHECK_MODULES([$1], [$2] >= [$3], :)
    AC_MSG_RESULT([  found version $(pkg-config --modversion $2)])
    ])

dnl Work around unneeded -l<lib> in some libraries' pkg-config files
dnl Intent is to minimise direct dependencies
dnl Assumption: --as-needed does nothing where all deps must be direct
AC_DEFUN([AC_LD_ASNEEDED],
    [SAVE_LDFLAGS="$LDFLAGS"
    LDFLAGS="$lt_prog_compiler_wl--as-needed $LDFLAGS"
    AC_MSG_CHECKING([whether the linker supports --as-needed])
    AC_TRY_LINK([], [], ac_cv_ld_asneeded=yes, ac_cv_ld_asneeded=no)
    AC_MSG_RESULT([$ac_cv_ld_asneeded])
    test x"$ac_cv_ld_asneeded" = xyes || LDFLAGS="$SAVE_LDFLAGS"
    ])
