/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _FRESHKLAM_H_
#define _FRESHKLAM_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <kdirlister.h> //stack allocated
#include <kurl.h>       //stack allocated
#include <kresolver.h> // namespace
#include <khtml_part.h>
#include "update.h"

namespace DOM {
  class Node;
}


using namespace KNetwork;

class KPrinter;
class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QListBox;
class QPushButton;
class QLabel;
class KProcess;
class KConfig;
class KURLRequester;
class KLineEdit;
class KProgressDialog;
class KProcIO;
class KHTMLPart;
class KlamavUpdate;

/**
 * This class serves as the main window for Freshklam.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Freshklam : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Freshklam(QWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Freshklam();

    /**
     * Use this method to load whatever file/URL you have
     */
    void  setDirName(QString);
    QString  getCurrentDBDir();
    bool isFreshklamAlive();
    QPushButton *search_button, *cancel_button;
    void enableAutoUpdates();

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);



private:
    void setupAccel();
    void setupActions();

private:
    //FreshklamView *m_view;



signals:
    void itemSelected(QString abs_filename, int line);


public slots:
    void slotSearch();
    void slotCancel();
    void checkForNewClamAVNow();
    void getCurrentVersionOfClamAV( );
    void toggleUpgradeButtons(bool);
private slots:
/*    void slotProg();*/
    void childExited();
    void processDied();
    void receivedOutput(KProcess *proc, char *buffer, int buflen);
    void slotClear();
    void writeConf();
    void handleChecks();
    //void arkollonExited(KProcess *arkollonproc);
/*    void klamavInstallationExited(KProcess *arkollonproc);
    void clamavInstallationExited(KProcess *arkollonproc);*/
    //void newItems( const KFileItemList& );
    void resolved(KResolverResults result);
    void checkForNewKlamAVNow();
    void readVersionLine(KProcIO *);
/*    void parseSFPage();
    void parseSFPageHack();*/
/*    void updateCanceled();*/
    void versionExited();
private:
/*    void getLatestVersionFromSF(KURL url);
    void getLatestVersionFromSFHack(KURL url);*/
    void processOutput();
    void finish();
    void getout();
    void updateMailClient();
    void enableInputs();
    void disableInputs();
    bool killPID();
    void  createDBDir();
/*    void  downloadComponent(QString component, QString version, QString extension);*/
    void startProgressDialog( const QString & text );
    void checkInternet();
    void connectToHost();
/*    void checkForNewKlamAV();*/
    void initCheckBoxes();
/*    void getVersionFromLink( const DOM::Node &n );
    void completedSearchForUpdates(const QString &component, const QString &extension);*/
    void updateMetaDB();
/*    QString getMirror();*/
    QLineEdit *template_edit;
    QComboBox *check_combo;
    KURLRequester *dir_combo;
    KURLRequester *proxy_dir_combo;
    QCheckBox *daemon_box;
    QCheckBox* clamav_box;
    QCheckBox* klamav_box;
    QCheckBox *recursive_box;
    QListBox *resultbox;
    QLabel *status_label, *matches_label;
    KProcess *childproc;
    KProcIO *versionproc;
    QString buf;
    KConfig* config;
    QStringList lastSearchItems;
    QStringList lastDownloadPaths;
    KLineEdit    *proxyIP;
    KLineEdit    *proxyPort;
    KLineEdit    *proxyUser;
    KLineEdit    *proxyPass;
    QString tempFileName;
    QString errorMessage;
    QString pidFileName;
    bool freshklamAlive;
    KProgressDialog *progressDialog;
    QTimer *timer;
/*    bool upgradeinprogress;*/
    bool checkingDirectly;
/*    double highestsofarnumeric;
    QString highestsofarraw;
    QString highestsofarfilename;*/
    KResolver m_resolver;
/*    QString currentClamAVVersion;
    KHTMLPart *filelist;*/
    QPushButton *clamav_options;
    QPushButton *klamav_options;

// private:
//     KDirLister clamav_lister;
//     KURL       clamav_url;
//     KDirLister klamav_lister;
//     KURL       klamav_url;
     KURL       m_url;
    KlamavUpdate* updater;
};

#endif // _Freshklam_H_
