(* Demonstration program showing a choice dialog using radio buttons. *)

open Printf
open Newt

let () =
  let r =
    init_and_finish (
      fun () ->
	cls ();

	centered_window 20 10 "Choice dialog";

	let radio1 = radio_button 1 1 "Choice 1" true None in
	let radio2 = radio_button 1 2 "Choice 2" false (Some radio1) in
	let radio3 = radio_button 1 3 "Choice 3" false (Some radio2) in
	let radio4 = radio_button 1 4 "Choice 4" false (Some radio3) in

	let ok = button 8 6 "  OK  " in
	let form = form None None [] in
	form_add_components form [radio1; radio2; radio3; radio4; ok];

	ignore (run_form form);
	pop_window ();

	let r = radio_get_current radio1 in
	if component_equals r radio1 then "Choice 1"
	else if component_equals r radio2 then "Choice 2"
	else if component_equals r radio3 then "Choice 3"
	else if component_equals r radio4 then "Choice 4"
	else "Unknown"
    ) in

  prerr_endline ("result: " ^ r);

  Gc.compact ()
