/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chartmodel.hxx,v $
 *
 *  $Revision: 1.1.2.6 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/18 14:39:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef OOX_DRAWINGML_CHART_CHARTMODEL_HXX
#define OOX_DRAWINGML_CHART_CHARTMODEL_HXX

#include "oox/drawingml/chart/modelbase.hxx"

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

class PlotAreaModel;
class LegendModel;

/** Chart model that contains the entire OOXML chart structure.
 */
class ChartModel
{
public:
    explicit            ChartModel();
    virtual             ~ChartModel();

    /** Returns true, if this chart model contains a plot area. */
    inline bool         hasPlotArea() const { return mxPlotArea.get() != 0; }
    /** Returns a pointer to an existing plot area, or null if not present. */
    inline PlotAreaModel* getPlotArea() const { return mxPlotArea.get(); }
    /** Creates and returns a new plot area model object. */
    PlotAreaModel&      createPlotArea();

    /** Returns true, if this chart model contains a legend. */
    inline bool         hasLegend() const { return mxLegend.get() != 0; }
    /** Returns a pointer to an existing legend, or null if not present. */
    inline LegendModel* getLegend() const { return mxLegend.get(); }
    /** Creates and returns a new legend model object. */
    LegendModel&        createLegend();

private:
    typedef ::boost::shared_ptr< PlotAreaModel >    PlotAreaRef;
    typedef ::boost::shared_ptr< LegendModel >      LegendRef;

    PlotAreaRef         mxPlotArea;
    LegendRef           mxLegend;
};

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

#endif

