/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chartobjecttable.hxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/12 12:02:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef OOX_DRAWINGML_CHART_CHARTOBJECTTABLE_HXX
#define OOX_DRAWINGML_CHART_CHARTOBJECTTABLE_HXX

#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/container/XNameContainer.hpp>

namespace com { namespace sun { namespace star {
    namespace chart2 { class XChartDocument; }
} } }

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

/** This helper manages named objects in a chart document, e.g. gradients,
    bitmaps, or line dashes.
 */
class ChartObjectTable
{
public:
    explicit            ChartObjectTable(
                            const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XChartDocument >& rxDoc,
                            const ::rtl::OUString& rServiceName,
                            const ::rtl::OUString& rObjNameBase );

    /** Returns a named formatting object from the chart document. */
    ::com::sun::star::uno::Any getObject( const ::rtl::OUString& rObjName );
    /** Inserts a named formatting object into the chart document. */
    ::rtl::OUString     insertObject( const ::com::sun::star::uno::Any& rObj );

private:
    void                createContainer();

private:
    ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >
                        mxFactory;              /// Factory to create the container.
    ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameContainer >
                        mxContainer;            /// Container for the objects.
    ::rtl::OUString     maServiceName;          /// Service name to create the container.
    ::rtl::OUString     maObjNameBase;          /// Base of names for inserted objects.
    sal_Int32           mnIndex;                /// Index to create unique identifiers.
};

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

#endif

