/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chartfragment.cxx,v $
 *
 *  $Revision: 1.1.2.4 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/18 14:40:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "oox/drawingml/chart/chartfragment.hxx"
#include "oox/drawingml/chart/chartmodel.hxx"
#include "oox/drawingml/chart/legendcontext.hxx"
#include "oox/drawingml/chart/plotareacontext.hxx"

using ::rtl::OUString;
using ::oox::core::ContextWrapper;
using ::oox::core::XmlFilterBase;

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

ChartFragment::ChartFragment( XmlFilterBase& rFilter, const OUString& rFragmentPath, ChartModel& rModel ) :
    ChartFragmentBase< ChartModel >( rFilter, rFragmentPath, rModel )
{
}

ChartFragment::~ChartFragment()
{
}

// oox.core.ContextHandler2Helper interface -----------------------------------

ContextWrapper ChartFragment::onCreateContext( sal_Int32 nElement, const AttributeList& )
{
    switch( getCurrentElement() )
    {
        case C_TOKEN( chartSpace ):
            return  (nElement == C_TOKEN( chart ));

        case C_TOKEN( chart ):
            switch( nElement )
            {
                case C_TOKEN( plotArea ):
                    return new PlotAreaContext( *this, getModel().createPlotArea() );
                case C_TOKEN( legend ):
                    return new LegendContext( *this, getModel().createLegend() );
            }
            return  (nElement == C_TOKEN( title ));
    }
    return false;
}

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

