/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QEdje.
 *
 * QEdje is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QEdje is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QEdje.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qzion.h>
#include <qedje.h>
#include <QtGui>
#include <QtCore>


int main(int argc, char **argv)
{
    QString filename, group;
    QApplication app(argc, argv);
    QZionCanvas *canvas = new QZionCanvas();

    if (app.arguments().size() >= 2)
        filename = app.arguments().at(1);
    else
        filename = "collections/theme2.edj";

    if (app.arguments().size() >= 3)
        group = app.arguments().at(2);
    else
        group = "world";

    canvas->show();
    QEdje *world = new QEdje(canvas, filename, group);
    world->show();

    return app.exec();
}
