/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "qzionmacros.h"
#include "qzioncommon.h"
#include "qzionobject_p.h"
#include "qzioncustomobject.h"



class QZionCustomObjectPrivate : public QGraphicsItem
{
public:
    QZionCustomObjectPrivate(QGraphicsItem *parent = 0);
    virtual ~QZionCustomObjectPrivate();

    QSize size() const;
    void setSize(const QSize &size);

    virtual QRectF boundingRect() const;

    virtual void paint(QPainter * painter,
                       const QStyleOptionGraphicsItem* option, QWidget* widget);

    QZionCustomObject *owner;

private:
    QRectF _boundingRect;
};


QZionCustomObjectPrivate::QZionCustomObjectPrivate(QGraphicsItem *parent)
    : QGraphicsItem(parent)
{
    setFlag(QGraphicsItem::ItemClipsToShape, true);
}

QZionCustomObjectPrivate::~QZionCustomObjectPrivate()
{

}

QSize QZionCustomObjectPrivate::size() const
{
    return _boundingRect.size().toSize();
}

void QZionCustomObjectPrivate::setSize(const QSize &size)
{
    if (size == this->size())
        return;

    prepareGeometryChange();
    _boundingRect = QRectF(0, 0, size.width(), size.height());
    update();
}

QRectF QZionCustomObjectPrivate::boundingRect() const
{
    return _boundingRect;
}

void QZionCustomObjectPrivate::paint(QPainter *painter,
                                     const QStyleOptionGraphicsItem *, QWidget *)
{
    owner->paint(painter);
}


QZionCustomObject::QZionCustomObject(QZionAbstractCanvas *canvas)
    : QZionObject(canvas)
{
    QZINIT(QZionCustomObject, canvas);
}

QZionCustomObject::~QZionCustomObject()
{
    QZDELETE(QZionCustomObject);
}

QSize QZionCustomObject::size() const
{
    QZD(QZionCustomObject);
    return d->size();
}

void QZionCustomObject::setSize(const QSize &size)
{
    QZD(QZionCustomObject);
    d->setSize(size);
    QZionObject::setSize(size);
}
