/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONOBJECT_P_H__
#define __QZIONOBJECT_P_H__

#include "qzionobject.h"
#include "qzionabstractcanvas.h"

class QZionObjectPrivate
{
public:
    QZionObject *owner;
    QGraphicsItem *item;

    QPoint pos;
    int opacity;
    bool visible;
    int attributes;
    bool mouseEvents;
    QZionRectangle *clipper;
    QZionAbstractCanvas *canvas;
    bool skipUpdate;

    QZionObjectPrivate();
    virtual ~QZionObjectPrivate() {}

    QGraphicsItem *realGroup(QZionAbstractCanvas *cv);
};

#endif
