import sys
from math import cos, sin

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from qzion import *

images = []
frames = 0
lastTime = 0
counter = QTime()


def tick():
    global frames, lastTime

    SLOW = 5
    w, h = 120, 160
    win_h, win_w = 400, 400

    frames += 1.0

    for i, image in enumerate(images):
        x = (win_w / 2) - (w / 2)
        x += sin(float(frames + (i * 13)) / (36.7 * SLOW)) * (w / 2)
        y = (win_h / 2) - (h / 2)
        y += cos(float(frames + (i * 28)) / (43.8 * SLOW)) * (h / 2)

        image.setPos(x, y)

    if frames % 5 == 0:
        elapsed = counter.elapsed() / 1000
        if elapsed != lastTime:
            lastTime = elapsed
            print "fps:", int(frames / elapsed)


if __name__ == "__main__":
    app = QApplication(sys.argv)
    canvas = QZionCanvas()
    canvas.show()

    timer = QTimer()

    for i in xrange(128):
        image = QZionImage(canvas, "image.png")
        image.show()
        images.append(image)

    QObject.connect(timer, SIGNAL("timeout()"), tick)

    timer.start()
    counter.start()
    sys.exit(app.exec_())
