/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A date edit for skrooge (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgdateeditdesignerplugin.h"
#include "skgdateedit.h"

#include "kicon.h"

#include <QtPlugin>

SKGDateEditDesignerPlugin::SKGDateEditDesignerPlugin(QObject *parent)
                : QObject(parent)
{
        initialized = false;
}

void SKGDateEditDesignerPlugin::initialize(QDesignerFormEditorInterface * /* core */)
{
        if (initialized) return;

        initialized = true;
}

bool SKGDateEditDesignerPlugin::isInitialized() const
{
        return initialized;
}

QWidget *SKGDateEditDesignerPlugin::createWidget(QWidget *parent)
{
        return new SKGDateEdit(parent);
}

QString SKGDateEditDesignerPlugin::name() const
{
        return "SKGDateEdit";
}

QString SKGDateEditDesignerPlugin::group() const
{
        return "SKG Widgets";
}

QIcon SKGDateEditDesignerPlugin::icon() const
{
        return KIcon("skrooge.png");
}

QString SKGDateEditDesignerPlugin::toolTip() const
{
        return "A date editor used by skrooge";
}

QString SKGDateEditDesignerPlugin::whatsThis() const
{
        return "A date editor used by skrooge";
}

bool SKGDateEditDesignerPlugin::isContainer() const
{
        return false;
}

QString SKGDateEditDesignerPlugin::domXml() const
{
        return "<widget class=\"SKGDateEdit\" name=\"SKGDateEdit\">\n"
               " <property name=\"geometry\">\n"
               "  <rect>\n"
               "   <x>0</x>\n"
               "   <y>0</y>\n"
               "   <width>100</width>\n"
               "   <height>10</height>\n"
               "  </rect>\n"
               " </property>\n"
               "</widget>\n";
}

QString SKGDateEditDesignerPlugin::includeFile() const
{
        return "skgdateedit.h";
}

