/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtabwidget.h"
#include "skgnodeobject.h"
#include "skgservices.h"
#include "skgtransactionmng.h"
#include "skgtraces.h"
#include "skgmainpanel.h"

#include "kmessagebox.h"

#include <QtGui/QWidget>

SKGTabWidget::SKGTabWidget(SKGMainPanel* iParent, SKGDocument* iDocument)
                : QWidget(), parent(iParent), document(iDocument)
{
        SKGTRACEIN(5, "SKGTabWidget::SKGTabWidget");
}

SKGTabWidget::~SKGTabWidget()
{
        SKGTRACEIN(5, "SKGTabWidget::~SKGTabWidget");
        document=NULL;
        parent=NULL;
}

bool SKGTabWidget::close()
{
        SKGTRACEIN(5, "SKGTabWidget::close");
        //Is this widget linked to a bookmark ?
        if (bookmarkID.length()) {
                //Yes. Is state modified ?
                SKGNodeObject node(document, SKGServices::stringToInt(bookmarkID));
                if (node.exist()) {
                        QStringList data=SKGServices::splitCSVLine(node.getData());
                        QString fullname=node.getFullName();
                        if (data.count()>3) {
                                QString currentState=getState().trimmed();
                                QString oldState=data[3].trimmed();
                                SKGTRACEL(5) << "oldState     =" << oldState << endl;
                                SKGTRACEL(5) << "currentState =" << currentState << endl;
                                if (currentState!=oldState) {
                                        QApplication::setOverrideCursor(QCursor(Qt::ArrowCursor));
                                        int conf=KMessageBox::questionYesNo(this,
                                                                            tr("Bookmark [%1] has been modified. Do you want to update it with current state ?").arg(fullname),
                                                                            tr("Bookmark has been modified"),
                                                                            KStandardGuiItem::yes(),
                                                                            KStandardGuiItem::no(),
                                                                            QString("updateBookmarkOnClose"));
                                        QApplication::restoreOverrideCursor();
                                        if (conf==KMessageBox::Yes) {
                                                SKGError err;
                                                {
                                                        SKGBEGINTRANSACTION(*document, tr("Bookmark update [%1]").arg(fullname), err);
                                                        data[3]=currentState;
                                                        if (err.isSucceeded()) err=node.setData(SKGServices::stringsToCsv(data));
                                                        if (err.isSucceeded()) err=node.save();
                                                }
                                                SKGMainPanel::displayErrorMessage(err);
                                        }
                                }
                        }
                }
        }

        return QWidget::close();
}

SKGObjectBase::SKGListSKGObjectBase SKGTabWidget::getSelectedObjects()
{
        SKGObjectBase::SKGListSKGObjectBase selection;
        return selection;
}

int SKGTabWidget::getNbSelectedObjects()
{
        return getSelectedObjects().count();
}

SKGMainPanel * SKGTabWidget::getMainPanel()
{
        return parent;
}

SKGDocument * SKGTabWidget::getDocument()
{
        return document;
}

QWidget* SKGTabWidget::getWidgetForPrint()
{
        return this;
}

QString SKGTabWidget::getState()
{
        return "";
}

void SKGTabWidget::setState(const QString& /*iState*/ )
{
}

void SKGTabWidget::setBookmarkID(const QString& iId)
{
        bookmarkID=iId;
}

QString SKGTabWidget::getBookmarkID()
{
        return bookmarkID;
}
#include "skgtabwidget.moc"
