/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is part of Skrooge and defines the main of skrooge.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocumentbank.h"

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kstandarddirs.h>
#include <KDE/KLocale>
#include <ksplashscreen.h>

#include <QBitmap>

/**
 * Description of the application
 */
static const char description[] = I18N_NOOP("Personal finance management tool for KDE4, with the aim of being highly intuitive, while providing powerful functions such as reporting (including graphics), persistent Undo/Redo, encryption, and much more...");

#define VER1_(x) #x
#define VER_(x) VER1_(x)
#define VER VER_(SKGVERSION)

/**
 * The main of the application
 * @param argc number of arguments
 * @param argv arguments
 * @return return code
 */
int main(int argc, char **argv)
{
        SKGTRACESEPARATOR;
        SKGTRACE << "STARTING SKROOGE" << endl << flush;
        SKGTRACESEPARATOR;
        QStringList argument;
        for (int i=1; i<argc; ++i) {
                SKGTRACE << "Argument " << i << "/" << argc << " : " << argv[i] << endl;
                argument << argv[i];
        }
        KAboutData about("skrooge",
                         0,
                         ki18n("Skrooge"),
                         VER,
                         ki18n(description),
                         KAboutData::License_GPL_V3,
                         ki18n("(c) 2007 Stephane MANKOWSKI & Guillaume DE BURE"),
                         KLocalizedString(),
                         "http://skrooge.sourceforge.net",
                         "miraks@users.sourceforge.net");

        about.addAuthor( ki18n("Stephane MANKOWSKI"), ki18n("Architect & Developer"), "miraks@users.sourceforge.net" );
        about.addAuthor( ki18n("Guillaume DE BURE"), ki18n("Developer"), "willy9@users.sourceforge.net" );
        about.addAuthor( ki18n("Thierry DAUCOURT"), ki18n("Graphist"), "thdox@users.sourceforge.net" );
        KCmdLineArgs::init(argc, argv, &about);

        KCmdLineOptions options;
        options.add("+[URL]", ki18n( "Document to open" ));
        KCmdLineArgs::addCmdLineOptions(options);
        KApplication app;

        //Creation splash screen
        //KSplashScreen splash(QPixmap ( KStandardDirs::locate("data", QString::fromLatin1("skrooge/images/splash.png"))),Qt::WindowStaysOnTopHint);
        QPixmap pix( KStandardDirs::locate("data", QString::fromLatin1("skrooge/images/splash.png")));
        KSplashScreen splash(pix);
        //TODO splash.setMask(pix.mask());
        splash.show();
        splash.showMessage(i18n("Loading skrooge ..."), Qt::AlignLeft, QColor(221, 130, 8));

        app.processEvents();

        //Creating a main panel on a bank document
        SKGDocumentBank doc(SKGDocument::CopiedInFile);
        SKGMainPanel *widget = new SKGMainPanel(&splash, &doc, argument);

        splash.finish(widget);

        // see if we are starting with session management
        if (app.isSessionRestored()) {
                RESTORE(SKGMainPanel(&splash, &doc,  argument));
        } else {
                widget->show();
        }

        int rc=0;
        if (SKGServices::getenv("SKGTESTMODE").isEmpty()) {
                rc=app.exec();
                widget=NULL;
        }

        if (widget) {
                delete widget;
                widget=NULL;
        }
        SKGTraces::exit(rc);
        return 0;
}
