/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for operation management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgsplittabledelegate.h"
#include "skgcombobox.h"
#include "skgcalculatoredit.h"
#include "skgmainpanel.h"

SKGSplitTableDelegate::SKGSplitTableDelegate(QObject* parent, const SKGDocument* iDoc): QItemDelegate(parent), document((SKGDocument*) iDoc)
{}

SKGSplitTableDelegate::~SKGSplitTableDelegate()
{
        document=NULL;
}

QWidget *SKGSplitTableDelegate::createEditor(QWidget *parent,
                const QStyleOptionViewItem & option ,
                const QModelIndex & index ) const
{
        if (index.column() == 0) {
                SKGComboBox *editor = new SKGComboBox(parent);
                editor->setEditable(true);
                if (document) SKGMainPanel::fillComboWithDistinctValue(editor, document, "category", "t_fullname", "");

                return editor;
        } else if (index.column() == 2) {
                SKGCalculatorEdit *editor = new SKGCalculatorEdit(parent);
                editor->setMode(SKGCalculatorEdit::EXPRESSION);

                return editor;
        }

        return QItemDelegate::createEditor( parent, option , index );
}

#include "skgsplittabledelegate.moc"

