/*
 * Photo Image Print System
 * Copyright (C) 2002-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2002-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */

#ifndef MAKEPPD_DEFINITIONS_H
#define MAKEPPD_DEFINITIONS_H

#define	COUNT(array)	sizeof(array)/sizeof((array)[0])

#define	PPD_FILE_LEADINGPART(file, pc_filename, model, short_name) fprintf(file, "*PPD-Adobe: \"4.3\"\n\n\
*%%\n\
*%% Photo Image Print System\n\
*%%   Copyright (C) SEIKO EPSON CORPORATION 2005.\n\
*%%\n\
\n\
*FormatVersion:         \"4.3\"\n\
*FileVersion:           \"1.0\"\n\
*LanguageVersion:       English\n\
*LanguageEncoding:      ISOLatin1\n\
*PCFileName:            \"%s\"\n\
*Manufacturer:          \"EPSON\"\n\
*Product:               \"(Photo Image Print System Lite)\"\n\
*cupsVersion:           1.1\n\
*cupsManualCopies:      True\n\
*cupsModelNumber:       1\n\
*cupsFilter:            \"application/vnd.cups-raster 0 rastertopips\"\n\
*ModelName:             \"%s\"\n\
*ShortNickName:         \"%s\"\n\
*NickName:              \"EPSON  %s, Photo Image Print System Lite\"\n\
*PSVersion:             \"(3010.000) 550\"\n\
*LanguageLevel:         \"3\"\n\
*ColorDevice:           True\n\
*DefaultColorSpace:     RGB\n\
*FileSystem:            True\n\
*Throughput:            \"1\"\n\
*LandscapeOrientation:  Plus90\n\
*VariablePaperSize:     False\n\
*TTRasterizer:          Type42\n\
\n\
", pc_filename, short_name, model, model);

#define INK_SEC(file)	fprintf(file, "*OpenUI *Ink/Ink: Boolean\n\
*OrderDependency: 30 AnySetup *Ink\n\
*DefaultInk: COLOR\n\
*Ink COLOR/Color:     \"<</cupsBitsPerColor 8/cupsColorOrder 0/cupsColorSpace 1/cupsCompression 1>>setpagedevice\"\n\
*Ink MONO/Monochrome: \"<</cupsBitsPerColor 8/cupsColorOrder 0/cupsColorSpace 0/cupsCompression 1>>setpagedevice\"\n\
*CloseUI: *Ink\n\
\n");


#define PPD_FILE_TRAILINGPART(file) fprintf(file,"\
*OpenUI *Ink/Ink: PickOne\n\
*OrderDependency: 30 AnySetup *Ink\n\
*DefaultInk: COLOR\n\
*Ink COLOR/Color:     \"<</cupsBitsPerColor 8/cupsColorOrder 0/cupsColorSpace 1/cupsCompression 1>>setpagedevice\"\n\
*Ink MONO/Monochrome: \"<</cupsBitsPerColor 8/cupsColorOrder 0/cupsColorSpace 0/cupsCompression 1>>setpagedevice\"\n\
*CloseUI: *Ink\n\
\n\
*DefaultFont: Courier\n\
*Font AvantGarde-Book: Standard \"(001.006S)\" Standard ROM\n\
*Font AvantGarde-BookOblique: Standard \"(001.006S)\" Standard ROM\n\
*Font AvantGarde-Demi: Standard \"(001.007S)\" Standard ROM\n\
*Font AvantGarde-DemiOblique: Standard \"(001.007S)\" Standard ROM\n\
*Font Bookman-Demi: Standard \"(001.004S)\" Standard ROM\n\
*Font Bookman-DemiItalic: Standard \"(001.004S)\" Standard ROM\n\
*Font Bookman-Light: Standard \"(001.004S)\" Standard ROM\n\
*Font Bookman-LightItalic: Standard \"(001.004S)\" Standard ROM\n\
*Font Courier: Standard \"(002.004S)\" Standard ROM\n\
*Font Courier-Bold: Standard \"(002.004S)\" Standard ROM\n\
*Font Courier-BoldOblique: Standard \"(002.004S)\" Standard ROM\n\
*Font Courier-Oblique: Standard \"(002.004S)\" Standard ROM\n\
*Font Helvetica: Standard \"(001.006S)\" Standard ROM\n\
*Font Helvetica-Bold: Standard \"(001.007S)\" Standard ROM\n\
*Font Helvetica-BoldOblique: Standard \"(001.007S)\" Standard ROM\n\
*Font Helvetica-Narrow: Standard \"(001.006S)\" Standard ROM\n\
*Font Helvetica-Narrow-Bold: Standard \"(001.007S)\" Standard ROM\n\
*Font Helvetica-Narrow-BoldOblique: Standard \"(001.007S)\" Standard ROM\n\
*Font Helvetica-Narrow-Oblique: Standard \"(001.006S)\" Standard ROM\n\
*Font Helvetica-Oblique: Standard \"(001.006S)\" Standard ROM\n\
*Font NewCenturySchlbk-Bold: Standard \"(001.009S)\" Standard ROM\n\
*Font NewCenturySchlbk-BoldItalic: Standard \"(001.007S)\" Standard ROM\n\
*Font NewCenturySchlbk-Italic: Standard \"(001.006S)\" Standard ROM\n\
*Font NewCenturySchlbk-Roman: Standard \"(001.007S)\" Standard ROM\n\
*Font Palatino-Bold: Standard \"(001.005S)\" Standard ROM\n\
*Font Palatino-BoldItalic: Standard \"(001.005S)\" Standard ROM\n\
*Font Palatino-Italic: Standard \"(001.005S)\" Standard ROM\n\
*Font Palatino-Roman: Standard \"(001.005S)\" Standard ROM\n\
*Font Symbol: Special \"(001.007S)\" Special ROM\n\
*Font Times-Bold: Standard \"(001.007S)\" Standard ROM\n\
*Font Times-BoldItalic: Standard \"(001.009S)\" Standard ROM\n\
*Font Times-Italic: Standard \"(001.007S)\" Standard ROM\n\
*Font Times-Roman: Standard \"(001.007S)\" Standard ROM\n\
*Font ZapfChancery-MediumItalic: Standard \"(001.007S)\" Standard ROM\n\
*Font ZapfDingbats: Special \"(001.004S)\" Standard ROM\n");

#define PAPERSIZE_SEC_LEADINGPART(file, default_value) fprintf(file, "\n\
*OpenUI *PageSize/Media Size: PickOne\n\
*OrderDependency: 10 AnySetup *PageSize\n\
*DefaultPageSize: %s\n\
", default_value);

#define	PAPERSIZE_SEC_TRAILINGPART(file) fprintf(file, "*CloseUI: *PageSize\n\n");

#define PAPERREGION_SEC_LEADINGPART(file, default_value) fprintf(file, "*OpenUI *PageRegion: PickOne\n\
*OrderDependency: 10 AnySetup *PageRegion\n\
*DefaultPageRegion: %s\n\
", default_value);

#define	PAPERREGION_SEC_TRAILINGPART(file) fprintf(file, "*CloseUI: *PageRegion\n\n");

#define IMAGEABLEAREA_SEC_LEADINGPART(file, default_value) fprintf(file, "*DefaultImageableArea: %s\n", default_value);
#define	IMAGEABLEAREA_SEC_TRAILINGPART(file) fprintf(file, "\n");

#define PAPERDIMENSION_SEC_LEADINGPART(file, default_value) fprintf(file, "*DefaultPaperDimension: %s\n", default_value);
#define	PAPERDIMENSION_SEC_TRAILINGPART(file) fprintf(file, "\n");

#define QUALITY_SEC_LEADINGPART(file, default_value) fprintf(file, "*OpenUI *Quality/Quality: PickOne\n\
*OrderDependency: 20 AnySetup *Quality\n\
*DefaultQuality: %s\n\
", default_value);

#define	QUALITY_SEC_TRAILINGPART(file) fprintf(file, "*CloseUI: *Quality\n\n");

typedef enum {
	STS_SUCCESS,
	STS_PRINTER_NOT_CONNECTED,
	STS_PRINTER_ERROR,
	STS_PAPERLIST_FILE_NOT_FOUND,
	STS_PAPERLIST_FILE_ERROR,
	STS_PRTOPT_FILE_NOT_FOUND,
	STS_PRTOPT_FILE_ERROR,
	STS_PRTOPT_INFO_NOT_FOUND,
	STS_PRTOPT_MEDIASIZE_NOT_RECOGNIZED,
	STS_PRTOPT_MEDIATYPE_NOT_RECOGNIZED,
	STS_PPD_FILE_CANNOT_CREATED,
	STS_PPD_FILE_CANNOT_WRITTEN,
	STS_NUM
} STATUS;

/* #ifndef PPD_DEBUG */
/* #define PPD_DEBUG */
/* #endif */

#ifndef UNIX
#define UNIX
#endif

#define MAX_PATH 255
#define MAX_LINE 255

#endif /* MAKEPPD_DEFINITIONS_H */

