/*
 * Photo Image Print System
 * Copyright (C) 2000-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "pipsCom.h"

/* ȥåȤΥǥץ֤顼ξ硢-1֤ */
int
connect_server (char *host)
{
  int sockfd;
  int len;
  struct sockaddr_in address;
  struct hostent *hostinfo;
  struct servent *servinfo;

  if (host == NULL)
      host = "localhost";

  hostinfo = gethostbyname (host);
  if (!hostinfo) return -1;

  servinfo = getservbyname ("cbtd", "tcp");
  if (!servinfo) return -1;

  sockfd = socket (AF_INET, SOCK_STREAM, 0);
  address.sin_family = AF_INET;
  address.sin_addr = *(struct in_addr *)*hostinfo->h_addr_list;
  address.sin_port = servinfo->s_port;

  len = sizeof (address);
  if (connect (sockfd, (struct sockaddr *)&address, len) == -1)
    {
      return -1;
    }
  return sockfd;
}

int
deconnect_server (int fd)
{
  close (fd);
  return 0;
}

int
command_shot (int fd, int key, char* replay)
{
  unsigned char status_packet[]  = { 'p', 'c', 'p', 0x00, 0x05, 's', 't', 0x01, 0x00, 0x01 };
  unsigned char clean_packet[]   = { 'p', 'c', 'p', 0x00, 0x05, 'c', 'h', 0x01, 0x00, 0x01 };
  unsigned char pattern_packet[] = { 'p', 'c', 'p', 0x00, 0x05, 'n', 'c', 0x01, 0x00, 0x00 };
  char rep_buf[REPLAY_SIZE_MAX];
  int rep_size;

  switch (key)
    {
    case PIPS_PACKET_STATUS:
      write (fd, status_packet, sizeof (status_packet));
      break;

    case PIPS_PACKET_CLEAN:
      write (fd, clean_packet, sizeof (clean_packet));
      break;

    case PIPS_PACKET_PATTERN:
      write (fd, pattern_packet, sizeof (pattern_packet));
      break;

    default:
      return 1;
    }

  if (read (fd, rep_buf, 5) < 0)
    return 1;
  rep_size = ((int)rep_buf[3] << 8) + (int)rep_buf[4];
  if (read (fd, rep_buf, rep_size) < 1)
    return 1;

  if (replay != NULL)
    memcpy (replay, rep_buf, rep_size);

  return 0;
}
