# config-functions.sh
#
# configuration functions for Relax & Recover
#
#    Relax & Recover is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    Relax & Recover is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with Relax & Recover; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#

# find out which OS Vendor and Version we run on (SuSE, SLES, RHEL, Fedora, Debian, ...)
SetOSVendorAndVersion () {
	# if (magically) these variables are already set, skip doing it again
	# this is needed, so that they can be overridden in $WORKFLOW.conf
	# if this happens, then ALL the variables OS_* have to be set there !!
	#
	if test "$OS_VENDOR" = generic -o "$OS_VERSION" = none ; then
	
		# try to use lsb_release
		if type lsb_release >/dev/null 2>&1 ; then
			OS_VENDOR="$(lsb_release -i -s | tr -s " \t" _)"
			OS_VERSION="$(lsb_release -r -s | tr -s " \t" _)"
		else
			# we have to go the classical way
			Error "The LSB package is not installed.
	Currently there is no support to detect the OS and VERSION without LSB support.
	Please either install the LSB package (that supplies the 'lsb_release' command)
	or improve $PRODUCT to handle this situation better.

	As an alternative you can manually override OS_VENDOR and OS_VERSION in the 
	'$CONFIG_DIR/os.conf' file. Please be sure to test your setup !

	See '$SHARE_DIR/lib/config-functions.sh' for more details about this matter.
"
		fi
	fi

	# combined stuff
	OS_VENDOR_VERSION="$OS_VENDOR/$OS_VERSION"
	OS_VENDOR_ARCH="$OS_VENDOR/$MACHINE"
	OS_VENDOR_VERSION_ARCH="$OS_VENDOR/$OS_VERSION/$MACHINE"

}
