//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VariationalOperatorNuDxUV.hpp,v 1.4 2004/08/28 08:28:03 delpinux Exp $

#ifndef VARIATIONAL_OPERATOR_NU_DX_U_V_HPP
#define VARIATIONAL_OPERATOR_NU_DX_U_V_HPP

#include <VariationalBilinearOperator.hpp>
#include <UserFunction.hpp>
/**
 * @file   VariationalOperatorNuDxUV.hpp
 * @author Stephane Del Pino
 * @date   Sun Jun 23 13:48:04 2002
 * 
 * @brief  \f$ a(u,v) = \int\nu\partial_{x_i} u v\f$
 * 
 * 
 */

class VariationalNuDxUVOperator
  : public VariationalBilinearOperator
{
private:
  ReferenceCounting<UserFunction> __nu;	/**< \f$\nu\f$ */

  const size_t __number;
public:
  /** 
   * Access to \f$\nu\f$
   * 
   * 
   * @return *__nu
   */
  const UserFunction& nu() const
  {
    return *__nu;
  }

  const size_t& number() const
  {
    return __number;
  }

  /** 
   * "Multiplies" the operator by a function
   * 
   * @param u the given function
   * 
   * @return the new operator
   */
  ReferenceCounting<VariationalBilinearOperator>
  operator * (ConstReferenceCounting<UserFunction> u) const
  {
    VariationalNuDxUVOperator* newOperator = new VariationalNuDxUVOperator(*this);
    (*newOperator).__nu = new MulUserFunction(__nu, u);
    return newOperator;
  }

  /** 
   * Constructor
   * 
   * @param unknownNumber 
   * @param testFunctionNumber 
   * @param nu \f$\nu\f$
   * @param number the \f$ i\f$ in \f$\partial_{x_i}\f$
   * 
   * @return 
   */
  VariationalNuDxUVOperator(const size_t unknownNumber,
			    const size_t testFunctionNumber,
			    ReferenceCounting<UserFunction> nu,
			    const size_t& number)
    : VariationalBilinearOperator(VariationalBilinearOperator::nuDxUV,
				  unknownNumber, testFunctionNumber),
      __nu(nu),
      __number(number)
  {
    ;
  }

  /** 
   * Copyt constructor
   * 
   * @param V 
   * 
   */
  VariationalNuDxUVOperator(const VariationalNuDxUVOperator& V)
    : VariationalBilinearOperator(V),
      __nu(V.__nu),
      __number(V.__number)
  {
    ;
  }

  /** 
   * Destructor
   * 
   * 
   */
  ~VariationalNuDxUVOperator()
  {
    ;
  }
};

#endif // VARIATIONAL_OPERATOR_NU_DX_U_V_HPP

