//////////////////////////////////////////////////////////////////////////////
// diag.C

#define WITH_GLOBAL_VARIABLES
#define WITH_DEPGRAPH

#include "dl.h"
#include "diag.h"
#include "generate.h"
#include <ctype.h>
#include <stdio.h>

WATOMS   diagH;
LITERALS diagO;

bool diagParseLiterals;

//////////////////////////////////////////////////////////////////////////////
// Helper functions as expected by LEX/FLEX

extern "C" int diagyywrap()    // End-of-file handler for LEX
    {
    return 1;
    }

int diagyyerror(const char* s)
    {
    return yyerror(s);
    }


#include "diag_parser2.c"


//////////////////////////////////////////////////////////////////////////////


const char *AB       = "ab";
const char *SOL      = "_sol";
const char *SOL1     = "_sol1";
const char *NOT_SOL  = "_notsol";
const char *SUCC     = "_succ";
const char *HYP      = "_hyp";
const char *EQ       = "_eq";
const char *FACT     = "_fact";
const char *ISNTSOL  = "_isntsol";
const char *NOTOBS   = "_notobs";

static void CreateMinDiagnosis(RULES&, const size_t,
                       const WATOMS&, const LITERALS&,
                       const CONSTRAINTS&, const size_t);
static void RewritePos(RULES&, const size_t,  
                       const WATOMS&, const LITERALS&,
		       const CONSTRAINTS&, const size_t);

////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
static void CreateReiterConstraints(const WATOMS& H)
//
// Generate the constraints:":- Hj, not _sol(j)." for each hypothesis Hj
  
    {
    unsigned j = 0;

    for ( WATOMS::const_iterator h = H.begin();
        h != H.end();
        h++)
        { 
        j++;

        char s[10];    
        sprintf(s,"%u",j); 
        TERMS *id = new TERMS;
        (*id).push_back(TERM(s));
        
        ATOM *sol = new ATOM(SOL,id);

        CONSTRAINT con(true);
	con.add(*h);
        con.add(LITERAL(true,*sol));
        
        Constraints.push_back( con );

        if( FTraceLevel >= 1 )
            cdebug << Constraints.back() << endl;

        }
    }

////////////////////////////////////////////////////////////////////////////////
static void CreateSingleErrorGuess(const WATOMS& H)
//
// Generate the rule "_sol(1) v _sol(2)... :-" for each hypothesis Hj

    {    
    DISJUNCTION dis;
    unsigned j=0;

    if ( H.size() == 0 )
            {
            cerr << "Cannot perform single error diagnostic reasoning without "
                    "hypotheses."
                 << endl;
            exit(1);
            }
    else
       {
        for(WATOMS::const_iterator i=H.begin(); 
            i != H.end(); 
            i++)
            {
            j++;
             
            
            char s[10]; 
            sprintf(s,"%u",j); 
    
            TERMS *id = new TERMS;
            (*id).push_back(TERM(s));        

            ATOM *at = new ATOM(SOL,id);

            dis.add(*at); 
            }   
          
       IDB.push_back( RULE(&dis,0) );

       if( FTraceLevel >= 1 )
       cdebug << IDB.back() << endl;       
       }
    }

   

////////////////////////////////////////////////////////////////////////////////
static void CreateGeneralGuess(const WATOMS& H)
//
// Generate the rules "_sol(j) v _notsol(j) :-" for each hypothesis Hj

{
    unsigned int j=0;
    for (WATOMS::const_iterator i = H.begin(); 
         i != H.end(); 
         i++)
         {
         if ( H.begin() == H.end() )
             {
             cerr << "Warning! Empty set of hypotheses!"<<endl;
             exit(1);
             }
         else
             {
             j++;
 
             char s[10]; 
             sprintf(s,"%u",j); 

             TERMS *id = new TERMS;
             (*id).push_back(TERM(s));        
 
             ATOM *at = new ATOM(SOL,id);
             ATOM *at1 = new ATOM(NOT_SOL,id);

             DISJUNCTION dis;
             dis.add(*at);
             dis.add(*at1);
        
             IDB.push_back( RULE(&dis,0) );  
 
             if( FTraceLevel >= 1 )
                 cdebug << IDB.back() << endl;       
             }  
         }                
 }



//////////////////////////////////////////////////////////////////////////////
static void CheckReiterPreconditions(
// Verify that
// * all predicates in the hypotheses are equal to "ab";
// * all rules have no negative body literal different from "ab"; and
// * all constraints have no negative literal different from "ab".
//
// In the case of subset minimal diagnosis, also verify that
// * all rules are non-disjunctive; and
// * hypotheses do not occur in the head or in the positive body of any rule.

    const WATOMS&         H,
    RULES::const_iterator begin, 
    RULES::const_iterator end,
    const CONSTRAINTS&    Constraints,
    size_t                oldCsize )
    {
    for(WATOMS::const_iterator h = H.begin(); h != H.end(); h++)
        {
        if ( strcmp( (*h).getPredName() , AB ) != 0 )
            {
            cerr << "Cannot perform Reiter diagnostic reasoning for "
                    "hypotheses with predicate different from \"ab\"."
                 << endl;
            exit(1);
            }
        }

    for(RULES::const_iterator i=begin; i != end; i++)
        {
        const CONJUNCTION *body=(*i).getBody();

        if( FDiag == FRONTEND_DIAG_MIN )
            {
            if( (*i).isDisjunctive() )
                {
                cerr << "Cannot perform Reiter subset minimal diagnostic "
                        "reasoning on disjunctive theories."
                     << endl;
                exit(1);
                }

            // At this point we know that there is only a single head literal
            // it suffices to check the first element of the head.
            if( ! strcmp( (*(i->getHead().begin())).getPredName(), AB ) )
                {
                cerr << "\"ab\" may not be used as a head literal for Reiter "
                        "subset minimal diagnostic reasoning."
                     << endl;
                exit(1);
                }
            }

        if( body )
            {
            if( FDiag == FRONTEND_DIAG_MIN )
                {
                for( CONJUNCTION::const_iterator j=(*body).pos_begin();
                     j != (*body).pos_end(); 
                     j++ )
                    {
                    if( ! strcmp( (*j).getPredName(),AB) ) 
                        {
                        cerr << "\"ab\" may not be used in the positive body "
                                "for Reiter subset minimal diagnostic "
                                "reasoning."
                             << endl;
                        exit(1);
                        }
                    }
                }

            for( CONJUNCTION::const_iterator j=(*body).neg_begin();
                 j != (*body).neg_end(); 
                 j++ )
                {
                if( strcmp( (*j).getPredName(),AB) ) 
                    {
                    cerr << "Cannot perform Reiter diagnostic reasoning "
                            "for theories with negative body literals "
                            "different from \"ab\"."
                         << endl;
                    exit(1);
                    }
                }
	    }
	}
                    
    for( CONSTRAINTS::const_iterator j = Constraints.begin();
         j != Constraints.begin()+oldCsize;
         j++ )
        {
	for( CONJUNCTION::const_iterator k=(*j).begin();
             k != (*j).end(); 
	     k++ )
            {
            if ( strcmp( (*k).getPredName() , AB ) != 0  
                 && (*k).isNegative() )
                {
                cerr << "Cannot perform Reiter diagnostic reasoning "
                        "for theories with constraints with negative body "
                        "literals different from \"ab\"."
                     << endl;
                exit(1);
                }
	    }
	}
    }
 

////////////////////////////////////////////////////////////////////////////////
static void ProcessObservations_Reiter(const LITERALS& O)
//
// If the observation is negative add the rule ":- Oi " to the constraints, 
// otherwise add " Oi :- true." to the theory, for each observation Oi

    {
    for(LITERALS::const_iterator i=O.begin(); 
        i!=O.end();
        i++)      
        {
        if( (*i).isNegative() )
            {
            CONSTRAINT con(true);

            con.add(LITERAL(false,(*i)));
            Constraints.push_back(con);

            if( FTraceLevel >= 1 )
                 cdebug << Constraints.back() << endl; 
            }
        else
            { 
            DISJUNCTION dis;

            dis.add(*i);

            IDB.push_back( RULE(&dis,0) );
                                         
            if( FTraceLevel >= 1 )
                cdebug << IDB.back() << endl; 
                
            }
        }
     
    }


////////////////////////////////////////////////////////////////////////////////

class DiagAtomPrinter : public unary_function<ATOM&,void>
    {
public:
    void operator() (const ATOM &a) const
        {
        if( strcmp(a.getPredName(),SOL) == 0 )
            {
            // Obtain the first parameter of a...
            const TERM &id = *(a.getParams()->begin());
            // ...and convert it.
            int n = atoi(id.getNameAsString());

            cout << " " << diagH[n-1];
            }
        }
    };

////////////////////////////////////////////////////////////////////////////////
bool DiagCallback(
          MODEL_GENERATOR *mg,
    const INTERPRET  *N,
    const GINTERPRET *M )
//
    {
    assert( N || M );

    if( FTraceLevel >= 1 )
        cout << "Stable model " << *M << endl << "gives diagnosis: ";
    else
        cout << "Diagnosis:";

    if( N )
        N->foreachPositive( DiagAtomPrinter() );

    if( M )
        {
        for (unsigned i = 0; i < GATOMSET::getSize(); i++)
            {
            if( (*M).isTrue(GATOM(i)) )
                {
                const ATOM &a=GATOM(i).getTheRealOne();

                DiagAtomPrinter p;
                p(a);
                }
            }
        }

    cout << endl;
    if( ! OptionSilent )
        cout << endl;

    if( mg )
        mg->incrNumberOfModelsPrinted();

    return true;
    }

////////////////////////////////////////////////////////////////////////////////
void RewriteNeg()
    {
    cerr << "Minimal diagnostic reasoning not yet implemented "
         << "for theories with negation or negative observations." <<endl;
    exit(1);
    } 

////////////////////////////////////////////////////////////////////////////////
static void CreateMinDiagnosis( 
    RULES&             T, 
    const size_t       oldTsize, 
    const WATOMS&      H,
    const LITERALS&    O,
    const CONSTRAINTS& Constraints,
    const size_t       oldCsize)
    {
    bool disjT = false;
    bool negT = false;
   
    for(size_t u=0;
        u < oldTsize  &&  ( !disjT || !negT );
        u++)
        {
        disjT = ( disjT || T[u].isDisjunctive() );

        const CONJUNCTION* body=T[u].getBody();
        if( body )
            negT = ( negT || (body->neg_begin() != body->neg_end()) );
        }

    if( disjT )  
        {
        cerr << "Cannot perform minimal diagnostic reasoning for disjunctive "
                "theories -- that task is $Sigma^P_3$ hard!" << endl;
        exit(1);
        }

    bool posO=true;
    for( vector<LITERAL>::const_iterator j=O.begin(); 
         j != O.end()  &&  posO;
         j++)
        {
        if( (*j).isNegative() )
            posO=false;
        } 

    if( ! negT  &&  posO )
        RewritePos(T,oldTsize,H,O,Constraints,oldCsize);
    else
        RewriteNeg();
    }


////////////////////////////////////////////////////////////////////////////////
static void RewriteTheory(
//
// Generate the rule "=Ti(x,I) :- =Tj(x,I),_hyp (I)." 
// for each rule "Ti(x) :- Tj(x)" in the theory T.

    RULES   &T,
    unsigned oldTsize )
    {
    for(unsigned u=0; u < oldTsize; u++)
        {
        RULE &r=T[u];

        DISJUNCTION head;
        
        for( DISJUNCTION::const_iterator h = r.getHead().begin();
             h != r.getHead().end();
             h++ )
            {
            assert(strlen((*h).getPredName()) < IDENT_LENGTH);
            char predName[IDENT_LENGTH+1];
            strcpy(predName,"=");
            strcat(predName,(*h).getPredName());

            TERMS *id;
            if( (*h).getParams() )
                id = new TERMS(*((*h).getParams()));
            else
                id = new TERMS;
            (*id).push_back(TERM(27)); 

            ATOM *at = new ATOM(predName,id);
            
            head.add(*at);
            }

        if( r.getBody() )
            {
            CONJUNCTION body;

            for( CONJUNCTION::const_iterator b = r.getBody()->begin();
                 b != r.getBody()->end();
                 b++ )
                { 
                // Keep EDB and builtins as is...
                if( (*b).isEDB()  ||  (*b).isBuiltin() )
                    body.add(LITERAL(*b));
                // ...but rewrite all other literals.
                else
                    {
                    assert(strlen((*b).getPredName()) < IDENT_LENGTH);
                    char predName[IDENT_LENGTH+1];
                    strcpy(predName,"=");
                    strcat(predName,(*b).getPredName());

                    TERMS *id;
                    if( (*b).getParams() )
                        id = new TERMS(*((*b).getParams()));
                    else
                        id = new TERMS;
                    (*id).push_back(TERM(27)); 

                    ATOM *at = new ATOM(predName,id);
                
                    body.add(LITERAL((*b).isNegative(),*at)); 
                    }
                }

            TERMS *id1 = new TERMS;
            (*id1).push_back(TERM(27)); 

            ATOM *at1 = new ATOM(HYP,id1);
                 
            body.add(*at1); 
            IDB.push_back( RULE(&head,&body) );
        
            if( FTraceLevel >= 1 )
                cdebug << IDB.back() << endl;
            }
        else
            {          
            IDB.push_back( RULE(&head,0) );
            
            if( FTraceLevel >= 1 )
                cdebug << IDB.back() << endl;
            }
	}
    }


////////////////////////////////////////////////////////////////////////////////
static void RewriteConstraints(const CONSTRAINTS& Constraints, size_t oldCsize)
//
// Generate the new rule:"_notobs(I) :- _hyp(I), =c1(x,I), not =c2(y,I)." for  
// each constraint " :- c1(x), not c2(y) " in the theory T.
 
    {    
    for (CONSTRAINTS::const_iterator i = Constraints.begin();
         i != Constraints.begin()+oldCsize;
         i++)
         {
         DISJUNCTION head;
               
         TERMS *id = new TERMS;
         (*id).push_back(TERM(27)); 
       
         ATOM *at = new ATOM(NOTOBS,id);

         head.add(*at);

         CONJUNCTION body;

         for( CONJUNCTION::const_iterator j=(*i).begin();
              j != (*i).end(); 
              j++ )
              {
              // Keep EDB and builtins as is...
              if( (*j).isEDB()  ||  (*j).isBuiltin() )
                  body.add(LITERAL(*j));
              // ...but rewrite all other literals.
              else
                  {
                  assert(strlen((*j).getPredName()) < IDENT_LENGTH);
                  char predName[IDENT_LENGTH+1];
                  strcpy(predName,"=");
                  strcat(predName,(*j).getPredName());

                  TERMS *id;
                  if( (*j).getParams() )
                      id = new TERMS(*((*j).getParams()));
                  else
                      id = new TERMS;
                     (*id).push_back(TERM(27)); 

                  ATOM *at = new ATOM(predName,id);
                  body.add(LITERAL((*j).isNegative(),*at)); 
                  }
             }
            TERMS *id1 = new TERMS;
            (*id1).push_back(TERM(27)); 

            ATOM *at1 = new ATOM(HYP,id1);
            body.add(LITERAL(false,*at1)); 

            IDB.push_back(RULE(&head,&body) );
                    
            if( FTraceLevel >= 1 )
               cdebug << IDB.back() << endl;
          }
      }


////////////////////////////////////////////////////////////////////////////////
static void CreateNewRule()
//
// Generate the new rule:"_sol1(K,I):-_sol(K),_hyp(I),not _eq(K,I)."

    {
    DISJUNCTION head;

    TERMS *id = new TERMS;
    (*id).push_back(TERM(28));
    (*id).push_back(TERM(27));

    ATOM *at = new ATOM(SOL1,id);  
    head.add(*at);

    CONJUNCTION body;

    TERMS *id1 = new TERMS;
    (*id1).push_back(TERM(28));

    ATOM *at1 = new ATOM(SOL,id1);
    body.add(*at1);

    TERMS *id2 = new TERMS;
    (*id2).push_back(TERM(27)); 

    ATOM *at2 = new ATOM(HYP,id2);
    body.add(*at2);

    TERMS *id3 = new TERMS;
    (*id3).push_back(TERM(28));
    (*id3).push_back(TERM(27));

    ATOM *at3 = new ATOM(EQ,id3);  
    body.add(LITERAL(true,*at3));

    IDB.push_back( RULE(&head,&body) );

        
    if( FTraceLevel >= 1 )
        cdebug << IDB.back() << endl;
    }


////////////////////////////////////////////////////////////////////////////////
static void CreateNewRule1()
//
//Generate the new rule:" _eq(X,X) :- _hyp(X). "

    {
    DISJUNCTION head;

    TERMS *id = new TERMS;
    (*id).push_back(TERM(29));
    (*id).push_back(TERM(29));

    ATOM *at = new ATOM(EQ,id);  
    head.add(*at);

    CONJUNCTION body;

    TERMS *id1 = new TERMS;
    (*id1).push_back(TERM(29)); 

    ATOM *at1 = new ATOM(HYP,id1);
    body.add(LITERAL(false,*at1));

    IDB.push_back( RULE(&head,&body) );
        
    if( FTraceLevel >= 1 )
        cdebug << IDB.back() << endl;
    }


////////////////////////////////////////////////////////////////////////////////
static void CreateNewRule2a()
//
// Generate the new rule "_fact(0)."

    {
    DISJUNCTION head;

    TERMS *id = new TERMS;
    (*id).push_back(TERM("0"));

    ATOM *at = new ATOM(FACT,id);  
    head.add(*at);

    IDB.push_back( RULE(&head,0) );
        
    if( FTraceLevel >= 1 )
        cdebug << IDB.back()<< endl;
    }


////////////////////////////////////////////////////////////////////////////////
static void CreateNewRule2b()
//
// Generate the new rule "_isntsol(F) :- _fact(F)."
    
    {
    DISJUNCTION head;

    TERMS *id = new TERMS;
    (*id).push_back(TERM(26));

    ATOM *at = new ATOM(ISNTSOL,id);  
    head.add(*at);

    CONJUNCTION body;

    TERMS *id1 = new TERMS;
    (*id1).push_back(TERM(26)); 

    ATOM *at1 = new ATOM(FACT,id1);
    body.add(LITERAL(false,*at1));

    IDB.push_back( RULE(&head,&body));

    if( FTraceLevel >= 1 )
        cdebug << IDB.back() << endl;
    }


////////////////////////////////////////////////////////////////////////////////
static void CreateNewRule2c()
//
// Generate the new rule "_isntsol(I) :- _isntsol(K), _succ(K,I), _notobs(I)."
    
    {
    DISJUNCTION head;

    TERMS *id = new TERMS;
    (*id).push_back(TERM(27));

    ATOM *at = new ATOM(ISNTSOL,id);  
    head.add(*at);

    CONJUNCTION body;

    TERMS *id1 = new TERMS;
    (*id1).push_back(TERM(28)); 

    ATOM *at1 = new ATOM(ISNTSOL,id1);
    body.add(LITERAL(false,*at1));

    TERMS *id2 = new TERMS;
    (*id2).push_back(TERM(28)); 
    (*id2).push_back(TERM(27));

    ATOM *at2 = new ATOM(SUCC,id2);
    body.add(LITERAL(false,*at2));

    TERMS *id3 = new TERMS;
    (*id3).push_back(TERM(27));

    ATOM *at3 = new ATOM(NOTOBS,id3);
    body.add(LITERAL(false,*at3));
    
    IDB.push_back( RULE(&head,&body));
        
    if( FTraceLevel >= 1 )
        cdebug << IDB.back() << endl;
    }


////////////////////////////////////////////////////////////////////////////////
static void CreateNewRule2d()
//
// Generate the new rule "_isntsol(I) :- _isntsol(K), _succ(K,I), not _sol(I)."

    {
    DISJUNCTION head;

    TERMS *id = new TERMS;
    (*id).push_back(TERM(27));

    ATOM *at = new ATOM(ISNTSOL,id);  
    head.add(*at);

    CONJUNCTION body;

    TERMS *id1 = new TERMS;
    (*id1).push_back(TERM(28)); 

    ATOM *at1 = new ATOM(ISNTSOL,id1);
    body.add(LITERAL(false,*at1));

    TERMS *id2 = new TERMS;
    (*id2).push_back(TERM(28)); 
    (*id2).push_back(TERM(27));

    ATOM *at2 = new ATOM(SUCC,id2);
    body.add(LITERAL(false,*at2));

    TERMS *id3 = new TERMS;
    (*id3).push_back(TERM(27));        

    ATOM *at3 = new ATOM(SOL,id);
    body.add(LITERAL(true,*at3));

    IDB.push_back( RULE(&head,&body) );
        
    if( FTraceLevel >= 1 )
        cdebug << IDB.back() << endl;
    }


//////////////////////////////////////////////////////////////////////////////
static void Constraint2(const WATOMS& H)
//
// Generate a new constraint ":- not _isntsol(j)" where j is the number
// of the hypotheses 

    {
    CONSTRAINT body(true);

    TERMS *id1 = new TERMS;
    char s[10]; 
    sprintf(s,"%u",(unsigned)H.size());
    (*id1).push_back(TERM(s));

    ATOM *at1 = new ATOM(ISNTSOL,id1);

    body.add( LITERAL(true,*at1));
    Constraints.push_back(body);  

     if( FTraceLevel >= 1 )
        cdebug << Constraints.back() << endl;
            
    }

////////////////////////////////////////////////////////////////////////////////
static void CreateNewRule3(const LITERALS& O)
//
// Generate a rule "_notobs(I) :- _hyp(I), not =Oi(x,I)"
// for each observation Oi(x).

    {   
    for(vector<LITERAL>::const_iterator i=O.begin(); 
        i!=O.end();
        i++)
        {
        DISJUNCTION head;

        TERMS *id = new TERMS;
        (*id).push_back(TERM(27)); 
       
        ATOM *at = new ATOM(NOTOBS,id);
        head.add(*at);
        
        CONJUNCTION body;

        TERMS *id1 = new TERMS;
        (*id1).push_back(TERM(27)); 
       
        ATOM *at1 = new ATOM(HYP,id1);
        body.add(LITERAL(false,*at1));
 
        TERMS *id2;
        if( (*i).getParams() )
           id2 = new TERMS(*((*i).getParams()));
        else
           id2 = new TERMS;
        (*id2).push_back(TERM(27)); 
       
        char predName[IDENT_LENGTH+1];
        strcpy(predName,"=");
        strcat(predName,(*i).getPredName());

        ATOM *at2 = new ATOM(predName,id2);
        body.add(LITERAL(true,*at2));
        
        IDB.push_back( RULE(&head,&body) );

        if( FTraceLevel >= 1 )
            cdebug << IDB.back() << endl;
        }
    }

////////////////////////////////////////////////////////////////////////////////
static void CreateNewRule3a(const LITERALS& O)
//
// Generate the rules:"_notobs(I) :- _hyp(I), =Oi(x,I)." if the observations 
// Oi(x) are negative, otherwise generate the rule:"=Oi(x,I) :- _hyp(I)."

{   
    for(vector<LITERAL>::const_iterator i=O.begin(); 
        i!=O.end();
        i++)
        {
        if ( (*i).isNegative() )
            {
            DISJUNCTION head;

            TERMS *id = new TERMS;
            (*id).push_back(TERM(27)); 
       
            ATOM *at = new ATOM(NOTOBS,id);
            head.add(*at);
        
            CONJUNCTION body;

            TERMS *id1 = new TERMS;
            (*id1).push_back(TERM(27)); 
       
            ATOM *at1 = new ATOM(HYP,id1);
            body.add(LITERAL(false,*at1));
 
            TERMS *id2;
            if( (*i).getParams() )
                id2 = new TERMS(*((*i).getParams()));
            else
                id2 = new TERMS;
               (*id2).push_back(TERM(27)); 
       
            char predName[IDENT_LENGTH+1];
            strcpy(predName,"=");
            strcat(predName,(*i).getPredName());

            ATOM *at2 = new ATOM(predName,id2);
            body.add(LITERAL(false,*at2));
        
            IDB.push_back( RULE(&head,&body) );

            if( FTraceLevel >= 1 )
                cdebug << IDB.back() << endl;
            }
        else
            {
            DISJUNCTION head;

            TERMS *id = new TERMS;

            if( (*i).getParams() )
                id = new TERMS(*((*i).getParams()));
            else
                id = new TERMS;
               (*id).push_back(TERM(27)); 
       
            char predName[IDENT_LENGTH+1];
            strcpy(predName,"=");
            strcat(predName,(*i).getPredName());

            ATOM *at = new ATOM(predName,id);
            head.add(*at);

            CONJUNCTION body;

            TERMS *id1 = new TERMS;
            (*id1).push_back(TERM(27)); 
       
            ATOM *at1 = new ATOM(HYP,id1);
            body.add(LITERAL(false,*at1));
 
            IDB.push_back( RULE(&head,&body) );

            if( FTraceLevel >= 1 )
                cdebug << IDB.back() << endl;
            }
        }
  }

////////////////////////////////////////////////////////////////////////////////
static void AddHyp_AddSucc(const WATOMS& H)
//
//Generate the facts:"_hyp(i)" and  "_succ(i-1,i)"for each hypotheses Hi

    {
    for(unsigned j = 0; j < H.size(); j++)
        {
        DISJUNCTION head1;

        char s1[10]; 
        sprintf(s1,"%u",j+1); 

        TERMS *id1 = new TERMS;
        (*id1).push_back(TERM(s1));

        ATOM *at1 = new ATOM(HYP,id1);
        head1.add(*at1);

        IDB.push_back( RULE(&head1,0) );

        if( FTraceLevel >= 1 )
             cdebug << IDB.back() << endl;


        DISJUNCTION head2;

        char s2[10]; 
        sprintf(s2,"%u",j);

        TERMS *id2 = new TERMS;
        (*id2).push_back(TERM(s2));
        (*id2).push_back(TERM(s1));

        ATOM *at2 = new ATOM(SUCC,id2);
        head2.add(*at2);
       
        IDB.push_back( RULE(&head2,0) );

        if( FTraceLevel >= 1 )
            cdebug << IDB.back()<< endl;
        }    
    }


////////////////////////////////////////////////////////////////////////////////
static void RewriteRules(const WATOMS& H)
//
// Generate the rules:"=Hi(x,I) :- _sol1(i,I)." for each hypothesis Hi
// with i that goes from 1 to number of hypotheses

    {
    unsigned j=0;

    for(WATOMS::const_iterator h = H.begin(); h != H.end(); h++)
        {            
        j++;

        DISJUNCTION head;

        char predName[IDENT_LENGTH+1];
        strcpy(predName,"=");
        strcat(predName,(*h).getPredName());

        TERMS *id1;
        if( (*h).getParams() )
           id1 = new TERMS(*((*h).getParams()));
        else
           id1 = new TERMS;
        (*id1).push_back(TERM(27)); 

        ATOM *at1 = new ATOM(predName,id1);
        
        head.add(*at1);

        CONJUNCTION body;

        char s[10];    
        sprintf(s,"%u",j); 
        TERMS *id = new TERMS;
        (*id).push_back(TERM(s));
        (*id).push_back(TERM(27));
        
        ATOM *at = new ATOM(SOL1,id);  
        body.add(*at);
        
        IDB.push_back( RULE(&head,&body));
        
        if( FTraceLevel >= 1 )
            cdebug << IDB.back() << endl;
        }  
    }

////////////////////////////////////////////////////////////////////////////////
static void MinimalityReiterConstraints(const WATOMS& H)
//
// Generate the rules:"_notobs(I) :- =Hi(x,I), _hyp(I), not _sol1(i,I)." 
// for each hypothesis Hi

    {
    // Counter representing the index of the hypotheses.
    unsigned j=0;
    
    for(WATOMS::const_iterator h = H.begin(); h != H.end(); h++)
        {
	// for each hypothesis...

	// increase the hypothesis index
        j++;

	// create the rule head

	DISJUNCTION dis;

	// create _notobs(I)

	TERMS *id_head = new TERMS;
	(*id_head).push_back(TERM(27));
	
	ATOM *notobs = new ATOM(NOTOBS,id_head);

	dis.add(*notobs);

	// create the rule body

        CONJUNCTION con;

	// create =H_j(x,I)

        char predName[IDENT_LENGTH+1];
        strcpy(predName,"=");
        strcat(predName,(*h).getPredName());

        TERMS *id1;
        if( (*h).getParams() )
           id1 = new TERMS(*((*h).getParams()));
        else
           id1 = new TERMS;
        (*id1).push_back(TERM(27)); 

        ATOM *h_i = new ATOM(predName,id1);

        con.add(*h_i);

	// create _hyp(I)

	TERMS *id2 = new TERMS;
	(*id2).push_back(TERM(27));

	ATOM *hyp = new ATOM(HYP,id2);

	con.add(*hyp);

	// create _sol1(j)

        char s[10];    
        sprintf(s,"%u",j); 
        TERMS *id = new TERMS;
        (*id).push_back(TERM(s));
        (*id).push_back(TERM(27));
        
        ATOM *at = new ATOM(SOL1,id);  

        con.add(LITERAL(true,*at));

	// add the rule

        IDB.push_back( RULE(&dis,&con) );

        if( FTraceLevel >= 1 )
            cdebug << IDB.back() << endl;
        }  
    }

 
void RewritePos(
    RULES&             T,
    const size_t       oldTsize,
    const WATOMS&      H,
    const LITERALS&    O,
    const CONSTRAINTS& Constraints,
    const size_t       oldCsize)
    {
  
    if( FTraceLevel >= 1 )
        cdebug << "RewriteTheory()" << endl;
    RewriteTheory(T,oldTsize);

    if( FTraceLevel >= 1 )
        cdebug << "CreateNewRule()" << endl;
    CreateNewRule();
    
    if( FTraceLevel >= 1 )
        cdebug << "CreateNewRule1()" << endl;
    CreateNewRule1();

    if( FTraceLevel >= 1 )
        cdebug << "CreateNewRule2a()" << endl;
    CreateNewRule2a();

    if( FTraceLevel >= 1 )
        cdebug << "CreateNewRule2b()" << endl;
    CreateNewRule2b();

    if( FTraceLevel >= 1 )
        cdebug << "CreateNewRule2c()" << endl;
    CreateNewRule2c();
    
    if( FTraceLevel >= 1 )
        cdebug << "CreateNewRule2d()" << endl;
    CreateNewRule2d();
    if( FTraceLevel >= 1 )
        cdebug << "Constraint2(H)" << endl;
    Constraint2(H);

    if( OptionFrontend == FRONTEND_DIAG_REITER )
        {
        if( FTraceLevel >= 1 )
            cdebug << "CreateNewRule3a(O)" << endl;
        CreateNewRule3a(O);
        
        if( FTraceLevel >= 1 )
            cdebug << "RewriteConstraints()" << endl;
        RewriteConstraints(Constraints, oldCsize);

        if( FTraceLevel >= 1 )
            cdebug << "MinimalityReiterConstraints(H)" << endl;
	MinimalityReiterConstraints(H);
        }
    else
        {
        if( FTraceLevel >= 1 )
            cdebug << "CreateNewRule3(O)" << endl;
        CreateNewRule3(O);
        }

    if( FTraceLevel >= 1 )
        cdebug << "AddHyp_AddSucc(H)" << endl;
    AddHyp_AddSucc(H);
    
    if( FTraceLevel >= 1 )
        cdebug << "RewriteRules(H)" << endl;
    RewriteRules(H);
    }       

////////////////////////////////////////////////////////////////////////////////
static void CreateGeneralRule(const WATOMS& H)
//
// Generate the rules:"Hj :- _sol(j)." for each hypothesis Hj
  
    {
    unsigned j = 0;

    for ( WATOMS::const_iterator h = H.begin();
        h != H.end();
        h++)
        { 
        j++;

        char s[10];    
        sprintf(s,"%u",j); 
        TERMS *id = new TERMS;
        (*id).push_back(TERM(s));
        
        ATOM *at = new ATOM(SOL,id);  
    
        DISJUNCTION dis;
        dis.add(*h);

        CONJUNCTION con;
        con.add(*at);
        
        IDB.push_back( RULE(&dis,&con) );

        if( FTraceLevel >= 1 )
            cdebug << IDB.back() << endl;        
                      
        }
    }


////////////////////////////////////////////////////////////////////////////////
static void CreateGeneralConstraints(const LITERALS& O)
                                     
//
// Generate the constraint ":- Oi" if the observation is negative (O=not Oi)
// and the constraint ":- not Oi" if the observation is positive (O=Oi) 
// for each obs Oi
 
    {
    for(vector<LITERAL>::const_iterator i=O.begin(); 
        i!=O.end();
        i++)
        {
        CONSTRAINT con1(true);

        con1.add( LITERAL(!(*i).isNegative(),(*i)) );

        Constraints.push_back(con1);
    
        if( FTraceLevel >= 1 )
            cdebug << Constraints.back() << endl;
        }
   }

////////////////////////////////////////////////////////////////////////////////
static void CreateWeakConstraints(const vector<WEIGHTEDATOM>& H)
//
// Generate the weak constraint :~ Hj. [wj] for each hypothesis Hj 
// with penalty wj. 
   { 
   for ( WATOMS::const_iterator h = H.begin();
           h != H.end();
           h++)
      {
      WEAKCONSTRAINT wcon(TERM((*h).getWeight()*SCALEFACT,0));
      wcon.add(*h);
      WConstraints.push_back(wcon);
      }
   }
//////////////////////////////////////////////////////////////////////////////
void CreateDiagnosis( 
//
          RULES&    T, 
    const WATOMS&   H, 
    const LITERALS& O)

    {
    const size_t oldTsize=T.size();
    const size_t oldCsize=Constraints.size();
    
    if( FTraceLevel >= 1 )
        {
        cdebug << "The theory is" << endl << "  ";
        print_list(cdebug,T,"\n  ");  

        cdebug << endl << "The hypotheses are ";
        print_list(cdebug,H,", ");
        cdebug << endl;

        cdebug << "The observations are ";
        print_list(cdebug,O,", ");
        cdebug << endl << endl;
        }

    if( Query )
        {
        cerr << "Cannot perform diagnostic reasoning in the presence of "
                "a query."
             << endl;
        exit(1);
        }

    if( OptionFrontend == FRONTEND_DIAG_REITER )
        {
        CheckReiterPreconditions(H,T.begin(),T.end(),Constraints,oldCsize); 
        ProcessObservations_Reiter(O);
        CreateGeneralRule(H);
	CreateReiterConstraints(H);

        if ( FDiag == FRONTEND_DIAG_SINGLE )
            CreateSingleErrorGuess(H);                         
        else
            {
            CreateGeneralGuess(H);
            if ( FDiag == FRONTEND_DIAG_MIN )
                {                      
                RewritePos(T,oldTsize,H,O,Constraints,oldCsize);
                }
            }
        }
    else        // Abductive Diagnosis 
        {
        CreateGeneralRule(H);
        CreateGeneralConstraints(O);  
        
        if( FDiag == FRONTEND_DIAG_SINGLE )
            CreateSingleErrorGuess(H);
        else
            {
            CreateGeneralGuess(H);
            if( FDiag == FRONTEND_DIAG_WEIGHTED )
                CreateWeakConstraints(H);
            else if( FDiag == FRONTEND_DIAG_MIN )
                CreateMinDiagnosis( T,oldTsize,
                                    H,O,Constraints,oldCsize );
            }
        }
 
    }

// Local Variables:
// c-file-style: "dl"
// End:
