//////////////////////////////////////////////////////////////////////////////
// literal.h

#ifndef LITERAL_H
#define LITERAL_H


//////////////////////////////////////////////////////////////////////////////
template <class T>
class TLITERAL : public T 
//////////////////////////////////////////////////////////////////////////////
    {
    bool neg;

public:
    TLITERAL()
        : T(), neg(false)
        {
        }

    TLITERAL(const T& atom2)
        : T(atom2), neg(false)
        {
        }

    TLITERAL(const TLITERAL& literal2)
        : T(literal2), neg(literal2.neg)
        {
        }

    TLITERAL(const TLITERAL& literal2, const TERM v2c[]) 
        : T(literal2,v2c), neg(literal2.neg)
        {
        }

    TLITERAL(bool neg2, const T& atom2)
        : T(atom2), neg(neg2)
        {
        }

    TLITERAL& operator= (const TLITERAL& literal2) 
        {
        if( this != &literal2 )
            {
            (T&)(*this)=(T&)literal2;
            neg=literal2.neg;
            }
 
        return *this;
        }


    bool isNegative() const
        {
        return neg;
        }

    /** determines if this LITERAL can save others.
     * No, this is not the beginning of a religion.
     * @return whether this can provide safety.
     */
    bool isSaviour() const
        // A saviour literal is a positive literal which is neither
        // builtin (except simple builtins), nor aggregate (except
        // assignment aggregates).
        {
        return ! isNegative()
               && ( ! this->isBuiltin()  ||  this->isComplexBuiltin() )
               && ( ! this->isAggregate() || this->getAggregate().isAssignment() );
        }

    const T& getAtom() const
        {
        return *(const T*)this;
        }

    int operator!= (const TLITERAL &l) const
        {
        int diff = isNegative() - l.isNegative();
 
        if (diff)
           return diff;
 
        return getAtom() != l.getAtom();
        }

    bool operator== (const TLITERAL &l) const
        {
        return ( *this != l ) == 0;
        }
    };


//////////////////////////////////////////////////////////////////////////////
template <class T>
inline ostream& operator<< (ostream &out, const TLITERAL<T> &literal)
//
    {
    if( literal.isNegative() )
        out << "not ";
    out << literal.getAtom();

    return out;
    }

#endif

// Local Variables:
// mode: c++
// c-file-style: "dl"
// End:
