//////////////////////////////////////////////////////////////////////////////
// program.h

#ifndef PROGRAM_H
#define PROGRAM_H

//////////////////////////////////////////////////////////////////////////////
template <class T>
class TPROGRAM : vector<const T*>
//
    {
    typename vector<const T*>::const_iterator inherited_begin() const 
        {
        return vector<const T*>::begin();
        }

    typename vector<const T*>::iterator inherited_begin()
        {
        return vector<const T*>::begin();
        }

    typename vector<const T*>::const_iterator inherited_end() const 
        {
        return vector<const T*>::end();
        }

public:
    class const_iterator
        {
        typename vector<const T*>::const_iterator i;
    public:
        const_iterator()
            : i(0)
            { }

        const_iterator(const const_iterator& i2)
            : i(i2.i)
            { }

        const_iterator(const typename vector<const T*>::const_iterator i2)
            : i(i2)
            { }

        void operator= (const const_iterator& i2)
            {
            i=i2.i;
            }


        const T& operator* () const
            {
            return *(*i);
            }

        const T* operator->() const
            {
            return &(operator*());
            }

        void operator++ ()
            {
            i++;
            }

        void operator++ (int)
            {
            i++;
            }

        bool operator== (const const_iterator& i2) const
            {
            return i == i2.i;
            }

        bool operator!= (const const_iterator& i2) const
            {
            return i != i2.i;
            }
        };

private:
    typename vector<const T*>::const_iterator sep;

public:
    TPROGRAM() : vector<const T*>()
        {
        sep=inherited_end();
        }

    TPROGRAM(const TPROGRAM& prog2)  : vector<const T*>()
        {
        reserve(prog2.size());

        insert(vector<const T*>::end(),prog2.inherited_begin(), prog2.sep);

        sep=inherited_end();

        insert(vector<const T*>::end(),prog2.sep, prog2.inherited_end());
        }

    void operator= (const TPROGRAM&)
        {
        assert( 0 );
        }


    size_t size() const
        {
        return vector<const T*>::size();
        }

    const_iterator begin()      const { return inherited_begin(); }
    const_iterator end()        const { return inherited_end();   }

    const_iterator exit_begin() const { return begin(); }
    const_iterator exit_end()   const { return sep;   }
    const_iterator rec_begin()  const { return sep;   }
    const_iterator rec_end()    const { return end(); }

    size_t rec_size() const
        {
        assert( sep <= inherited_end() );
        return inherited_end() - sep;
        }

    size_t exit_size() const
        {
        assert( sep >= inherited_begin() );
        return sep - inherited_begin();
        }

    void addExit(const T &rule)
        {
        assert( inherited_begin() <= sep && sep <= inherited_end() );

        sep=insert(inherited_begin()+(sep-inherited_begin()),&rule)+1;

        assert( inherited_begin() <= sep && sep <= inherited_end() );
        }

    void addRecursive(const T& rule)
        {
        assert( inherited_begin() <= sep && sep <= inherited_end() );

        size_t offset=sep-inherited_begin();
        push_back(&rule);
        sep=inherited_begin()+offset;

        assert( inherited_begin() <= sep && sep <= inherited_end() );
        }
    };


//////////////////////////////////////////////////////////////////////////////
template <class T>
inline ostream& operator<< (ostream& out, const TPROGRAM<T>& p)
//
    {
    out << "{ ";
    for( typename TPROGRAM<T>::const_iterator i=p.begin();
         i != p.end();
         i++ )
        {
        out << *i << " ";
        }
    out << "}";

    return out;
    }

#endif

// Local Variables:
// c-file-style: "dl"
// End:
