#!/bin/sh

# Usage: $0 base-dir log-dir tmp-dir

if test -z "$3"; then
  exit 1
fi

BASEDIR="$1"
LOGDIR="$2"
TMPDIR="$3"

cd $TMPDIR

summary="DLV-summary.txt"

echo -n "# DATE build-time build-mem text-size " > $summary
#for i in $LOGDIR/DLV-performance*; do
#  tests=`cat $i | grep '^[[:space:]]*[^ ]\+ |.*|' | sed -e 's/^[[:space:]]*\([^ ]*\).*$/\1/g' | tr '\n' ' '`
#  break
#done
#echo $tests >> $summary
cat $BASEDIR/tests >> $summary
echo >> $summary

for i in $LOGDIR/DLV-performance*; do
  echo $i | sed -e 's/.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)\(\|-.*\)$/\1/' | tr '\n' ' ' | cat >> $summary
  cat $i | grep '^TIME:' | sed -e 's/^TIME: \(.*\)$/\1/g' | tr '\n' ' ' | cat >> $summary
  cat $i | grep '^total:' | sed -e 's/^total: \(.*\) kB$/\1/g' | tr '\n' ' ' | cat >> $summary
  ( grep '^FILESIZE:' $i || echo "FILESIZE: a a a a a a 0" ) | cut -d ' ' -f 8 | tr '\n' ' ' | cat >> $summary
  cat $i | grep '^[[:space:]]*[^ ]\+ |.*|' | sed -e 's/^[^|]*|[^0-9]*\([0-9]*\.[0-9]*\).*|.*$/\1/g' | sed -e 's/^.*|.*|.*$/0/g' | tr '\n' ' ' >> $summary
  echo >> $summary;
done

if test -f $BASEDIR/DLV-summary.gp-`hostname`; then
  gnuplot $BASEDIR/DLV-summary.gp-`hostname`
else
  gnuplot $BASEDIR/DLV-summary.gp
fi
